/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.slack.client.methods.params.channels.BaseChannelsFilter;
import com.hubspot.slack.client.methods.params.channels.ChannelsListParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChannelsListParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChannelsListParams
implements ChannelsListParamsIF {
    @Nullable
    private final Boolean shouldExcludeArchived;
    private final boolean shouldExcludeMembers;
    @Nullable
    private final String cursor;
    @Nullable
    private final Integer limit;

    private ChannelsListParams(Builder builder) {
        this.shouldExcludeArchived = builder.shouldExcludeArchived;
        this.cursor = builder.cursor;
        this.limit = builder.limit;
        this.shouldExcludeMembers = builder.shouldExcludeMembersIsSet() ? builder.shouldExcludeMembers : ChannelsListParamsIF.super.shouldExcludeMembers();
    }

    private ChannelsListParams(@Nullable Boolean shouldExcludeArchived, boolean shouldExcludeMembers, @Nullable String cursor, @Nullable Integer limit) {
        this.shouldExcludeArchived = shouldExcludeArchived;
        this.shouldExcludeMembers = shouldExcludeMembers;
        this.cursor = cursor;
        this.limit = limit;
    }

    @Override
    @JsonProperty(value="exclude_archived")
    public Optional<Boolean> shouldExcludeArchived() {
        return Optional.ofNullable(this.shouldExcludeArchived);
    }

    @Override
    @JsonProperty(value="exclude_members")
    public boolean shouldExcludeMembers() {
        return this.shouldExcludeMembers;
    }

    @Override
    @JsonProperty
    public Optional<String> getCursor() {
        return Optional.ofNullable(this.cursor);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getLimit() {
        return Optional.ofNullable(this.limit);
    }

    public final ChannelsListParams withShouldExcludeArchived(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.shouldExcludeArchived, newValue)) {
            return this;
        }
        return new ChannelsListParams(newValue, this.shouldExcludeMembers, this.cursor, this.limit);
    }

    public final ChannelsListParams withShouldExcludeArchived(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.shouldExcludeArchived, value)) {
            return this;
        }
        return new ChannelsListParams(value, this.shouldExcludeMembers, this.cursor, this.limit);
    }

    public final ChannelsListParams withShouldExcludeMembers(boolean value) {
        if (this.shouldExcludeMembers == value) {
            return this;
        }
        return new ChannelsListParams(this.shouldExcludeArchived, value, this.cursor, this.limit);
    }

    public final ChannelsListParams withCursor(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.cursor, newValue)) {
            return this;
        }
        return new ChannelsListParams(this.shouldExcludeArchived, this.shouldExcludeMembers, newValue, this.limit);
    }

    public final ChannelsListParams withCursor(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.cursor, value)) {
            return this;
        }
        return new ChannelsListParams(this.shouldExcludeArchived, this.shouldExcludeMembers, value, this.limit);
    }

    public final ChannelsListParams withLimit(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ChannelsListParams(this.shouldExcludeArchived, this.shouldExcludeMembers, this.cursor, newValue);
    }

    public final ChannelsListParams withLimit(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ChannelsListParams(this.shouldExcludeArchived, this.shouldExcludeMembers, this.cursor, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChannelsListParams && this.equalTo(0, (ChannelsListParams)another);
    }

    private boolean equalTo(int synthetic, ChannelsListParams another) {
        return Objects.equals(this.shouldExcludeArchived, another.shouldExcludeArchived) && this.shouldExcludeMembers == another.shouldExcludeMembers && Objects.equals(this.cursor, another.cursor) && Objects.equals(this.limit, another.limit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.shouldExcludeArchived);
        h += (h << 5) + Boolean.hashCode(this.shouldExcludeMembers);
        h += (h << 5) + Objects.hashCode(this.cursor);
        h += (h << 5) + Objects.hashCode(this.limit);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelsListParams{");
        if (this.shouldExcludeArchived != null) {
            builder.append("shouldExcludeArchived=").append(this.shouldExcludeArchived);
        }
        if (builder.length() > 19) {
            builder.append(", ");
        }
        builder.append("shouldExcludeMembers=").append(this.shouldExcludeMembers);
        if (this.cursor != null) {
            builder.append(", ");
            builder.append("cursor=").append(this.cursor);
        }
        if (this.limit != null) {
            builder.append(", ");
            builder.append("limit=").append(this.limit);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChannelsListParams fromJson(Json json) {
        Builder builder = ChannelsListParams.builder();
        if (json.shouldExcludeArchived != null) {
            builder.setShouldExcludeArchived(json.shouldExcludeArchived);
        }
        if (json.shouldExcludeMembersIsSet) {
            builder.setShouldExcludeMembers(json.shouldExcludeMembers);
        }
        if (json.cursor != null) {
            builder.setCursor(json.cursor);
        }
        if (json.limit != null) {
            builder.setLimit(json.limit);
        }
        return builder.build();
    }

    public static ChannelsListParams copyOf(ChannelsListParamsIF instance) {
        if (instance instanceof ChannelsListParams) {
            return (ChannelsListParams)instance;
        }
        return ChannelsListParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChannelsListParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SHOULD_EXCLUDE_MEMBERS = 1L;
        private long optBits;
        @Nullable
        private Boolean shouldExcludeArchived;
        private boolean shouldExcludeMembers;
        @Nullable
        private String cursor;
        @Nullable
        private Integer limit;

        private Builder() {
        }

        public final Builder from(BaseChannelsFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ChannelsListParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            BaseChannelsFilter instance;
            long bits = 0L;
            if (object instanceof BaseChannelsFilter) {
                instance = (BaseChannelsFilter)object;
                if ((bits & 1L) == 0L) {
                    Optional<Boolean> shouldExcludeArchivedOptional = instance.shouldExcludeArchived();
                    if (shouldExcludeArchivedOptional.isPresent()) {
                        this.setShouldExcludeArchived(shouldExcludeArchivedOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setShouldExcludeMembers(instance.shouldExcludeMembers());
                    bits |= 2L;
                }
            }
            if (object instanceof ChannelsListParamsIF) {
                Optional<Integer> limitOptional;
                instance = (ChannelsListParamsIF)object;
                Optional<String> cursorOptional = instance.getCursor();
                if (cursorOptional.isPresent()) {
                    this.setCursor(cursorOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<Boolean> shouldExcludeArchivedOptional = instance.shouldExcludeArchived();
                    if (shouldExcludeArchivedOptional.isPresent()) {
                        this.setShouldExcludeArchived(shouldExcludeArchivedOptional);
                    }
                    bits |= 1L;
                }
                if ((limitOptional = instance.getLimit()).isPresent()) {
                    this.setLimit(limitOptional);
                }
                if ((bits & 2L) == 0L) {
                    this.setShouldExcludeMembers(instance.shouldExcludeMembers());
                    bits |= 2L;
                }
            }
        }

        public final Builder setShouldExcludeArchived(@Nullable Boolean shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived;
            return this;
        }

        public final Builder setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived.orElse(null);
            return this;
        }

        public final Builder setShouldExcludeMembers(boolean shouldExcludeMembers) {
            this.shouldExcludeMembers = shouldExcludeMembers;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setCursor(@Nullable String cursor) {
            this.cursor = cursor;
            return this;
        }

        public final Builder setCursor(Optional<String> cursor) {
            this.cursor = cursor.orElse(null);
            return this;
        }

        public final Builder setLimit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Builder setLimit(Optional<Integer> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        public ChannelsListParams build() {
            return new ChannelsListParams(this);
        }

        private boolean shouldExcludeMembersIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChannelsListParamsIF", generator="Immutables")
    static final class Json
    implements ChannelsListParamsIF {
        @Nullable
        Optional<Boolean> shouldExcludeArchived = Optional.empty();
        boolean shouldExcludeMembers;
        boolean shouldExcludeMembersIsSet;
        @Nullable
        Optional<String> cursor = Optional.empty();
        @Nullable
        Optional<Integer> limit = Optional.empty();

        Json() {
        }

        @JsonProperty(value="exclude_archived")
        public void setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived;
        }

        @JsonProperty(value="exclude_members")
        public void setShouldExcludeMembers(boolean shouldExcludeMembers) {
            this.shouldExcludeMembers = shouldExcludeMembers;
            this.shouldExcludeMembersIsSet = true;
        }

        @JsonProperty
        public void setCursor(Optional<String> cursor) {
            this.cursor = cursor;
        }

        @JsonProperty
        public void setLimit(Optional<Integer> limit) {
            this.limit = limit;
        }

        @Override
        public Optional<Boolean> shouldExcludeArchived() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean shouldExcludeMembers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCursor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getLimit() {
            throw new UnsupportedOperationException();
        }
    }
}

