/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.TimeIntervalFilter;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.channels.AbstractChannelsHistoryParams;
import com.hubspot.slack.client.methods.params.channels.PagingDirection;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AbstractChannelsHistoryParams", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChannelsHistoryParams
extends AbstractChannelsHistoryParams {
    @Nullable
    private final String newestTimestamp;
    @Nullable
    private final String oldestTimestamp;
    private final transient PagingDirection pagingDirection;
    private final String channelId;
    @Nullable
    private final Integer count;
    @Nullable
    private final Boolean inclusive;
    @Nullable
    private final Boolean shouldIncludeUnreads;

    private ChannelsHistoryParams(@Nullable String newestTimestamp, @Nullable String oldestTimestamp, String channelId, @Nullable Integer count, @Nullable Boolean inclusive, @Nullable Boolean shouldIncludeUnreads) {
        this.newestTimestamp = newestTimestamp;
        this.oldestTimestamp = oldestTimestamp;
        this.channelId = channelId;
        this.count = count;
        this.inclusive = inclusive;
        this.shouldIncludeUnreads = shouldIncludeUnreads;
        this.pagingDirection = Objects.requireNonNull(super.getPagingDirection(), "pagingDirection");
    }

    @Override
    @JsonProperty(value="latest")
    public Optional<String> getNewestTimestamp() {
        return Optional.ofNullable(this.newestTimestamp);
    }

    @Override
    @JsonProperty(value="oldest")
    public Optional<String> getOldestTimestamp() {
        return Optional.ofNullable(this.oldestTimestamp);
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public PagingDirection getPagingDirection() {
        return this.pagingDirection;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public Optional<Integer> getCount() {
        return Optional.ofNullable(this.count);
    }

    @Override
    @JsonProperty(value="is_inclusive")
    public Optional<Boolean> isInclusive() {
        return Optional.ofNullable(this.inclusive);
    }

    @Override
    @JsonProperty(value="unreads")
    public Optional<Boolean> shouldIncludeUnreads() {
        return Optional.ofNullable(this.shouldIncludeUnreads);
    }

    public final ChannelsHistoryParams withNewestTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.newestTimestamp, newValue)) {
            return this;
        }
        return ChannelsHistoryParams.validate(new ChannelsHistoryParams(newValue, this.oldestTimestamp, this.channelId, this.count, this.inclusive, this.shouldIncludeUnreads));
    }

    public final ChannelsHistoryParams withNewestTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.newestTimestamp, value)) {
            return this;
        }
        return ChannelsHistoryParams.validate(new ChannelsHistoryParams(value, this.oldestTimestamp, this.channelId, this.count, this.inclusive, this.shouldIncludeUnreads));
    }

    public final ChannelsHistoryParams withOldestTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.oldestTimestamp, newValue)) {
            return this;
        }
        return ChannelsHistoryParams.validate(new ChannelsHistoryParams(this.newestTimestamp, newValue, this.channelId, this.count, this.inclusive, this.shouldIncludeUnreads));
    }

    public final ChannelsHistoryParams withOldestTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.oldestTimestamp, value)) {
            return this;
        }
        return ChannelsHistoryParams.validate(new ChannelsHistoryParams(this.newestTimestamp, value, this.channelId, this.count, this.inclusive, this.shouldIncludeUnreads));
    }

    public final ChannelsHistoryParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return ChannelsHistoryParams.validate(new ChannelsHistoryParams(this.newestTimestamp, this.oldestTimestamp, newValue, this.count, this.inclusive, this.shouldIncludeUnreads));
    }

    public final ChannelsHistoryParams withCount(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.count, newValue)) {
            return this;
        }
        return ChannelsHistoryParams.validate(new ChannelsHistoryParams(this.newestTimestamp, this.oldestTimestamp, this.channelId, newValue, this.inclusive, this.shouldIncludeUnreads));
    }

    public final ChannelsHistoryParams withCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.count, value)) {
            return this;
        }
        return ChannelsHistoryParams.validate(new ChannelsHistoryParams(this.newestTimestamp, this.oldestTimestamp, this.channelId, value, this.inclusive, this.shouldIncludeUnreads));
    }

    public final ChannelsHistoryParams withInclusive(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.inclusive, newValue)) {
            return this;
        }
        return ChannelsHistoryParams.validate(new ChannelsHistoryParams(this.newestTimestamp, this.oldestTimestamp, this.channelId, this.count, newValue, this.shouldIncludeUnreads));
    }

    public final ChannelsHistoryParams withInclusive(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.inclusive, value)) {
            return this;
        }
        return ChannelsHistoryParams.validate(new ChannelsHistoryParams(this.newestTimestamp, this.oldestTimestamp, this.channelId, this.count, value, this.shouldIncludeUnreads));
    }

    public final ChannelsHistoryParams withShouldIncludeUnreads(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.shouldIncludeUnreads, newValue)) {
            return this;
        }
        return ChannelsHistoryParams.validate(new ChannelsHistoryParams(this.newestTimestamp, this.oldestTimestamp, this.channelId, this.count, this.inclusive, newValue));
    }

    public final ChannelsHistoryParams withShouldIncludeUnreads(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.shouldIncludeUnreads, value)) {
            return this;
        }
        return ChannelsHistoryParams.validate(new ChannelsHistoryParams(this.newestTimestamp, this.oldestTimestamp, this.channelId, this.count, this.inclusive, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChannelsHistoryParams && this.equalTo(0, (ChannelsHistoryParams)another);
    }

    private boolean equalTo(int synthetic, ChannelsHistoryParams another) {
        return Objects.equals(this.newestTimestamp, another.newestTimestamp) && Objects.equals(this.oldestTimestamp, another.oldestTimestamp) && this.pagingDirection.equals((Object)another.pagingDirection) && this.channelId.equals(another.channelId) && Objects.equals(this.count, another.count) && Objects.equals(this.inclusive, another.inclusive) && Objects.equals(this.shouldIncludeUnreads, another.shouldIncludeUnreads);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.newestTimestamp);
        h += (h << 5) + Objects.hashCode(this.oldestTimestamp);
        h += (h << 5) + this.pagingDirection.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + Objects.hashCode(this.count);
        h += (h << 5) + Objects.hashCode(this.inclusive);
        h += (h << 5) + Objects.hashCode(this.shouldIncludeUnreads);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelsHistoryParams{");
        if (this.newestTimestamp != null) {
            builder.append("newestTimestamp=").append(this.newestTimestamp);
        }
        if (this.oldestTimestamp != null) {
            if (builder.length() > 22) {
                builder.append(", ");
            }
            builder.append("oldestTimestamp=").append(this.oldestTimestamp);
        }
        if (builder.length() > 22) {
            builder.append(", ");
        }
        builder.append("pagingDirection=").append((Object)this.pagingDirection);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        if (this.count != null) {
            builder.append(", ");
            builder.append("count=").append(this.count);
        }
        if (this.inclusive != null) {
            builder.append(", ");
            builder.append("inclusive=").append(this.inclusive);
        }
        if (this.shouldIncludeUnreads != null) {
            builder.append(", ");
            builder.append("shouldIncludeUnreads=").append(this.shouldIncludeUnreads);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChannelsHistoryParams fromJson(Json json) {
        Builder builder = ChannelsHistoryParams.builder();
        if (json.newestTimestamp != null) {
            builder.setNewestTimestamp(json.newestTimestamp);
        }
        if (json.oldestTimestamp != null) {
            builder.setOldestTimestamp(json.oldestTimestamp);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.count != null) {
            builder.setCount(json.count);
        }
        if (json.inclusive != null) {
            builder.setInclusive(json.inclusive);
        }
        if (json.shouldIncludeUnreads != null) {
            builder.setShouldIncludeUnreads(json.shouldIncludeUnreads);
        }
        return builder.build();
    }

    private static ChannelsHistoryParams validate(ChannelsHistoryParams instance) {
        instance.validate();
        return instance;
    }

    public static ChannelsHistoryParams copyOf(AbstractChannelsHistoryParams instance) {
        if (instance instanceof ChannelsHistoryParams) {
            return (ChannelsHistoryParams)instance;
        }
        return ChannelsHistoryParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractChannelsHistoryParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String newestTimestamp;
        @Nullable
        private String oldestTimestamp;
        @Nullable
        private String channelId;
        @Nullable
        private Integer count;
        @Nullable
        private Boolean inclusive;
        @Nullable
        private Boolean shouldIncludeUnreads;

        private Builder() {
        }

        public final Builder from(AbstractChannelsHistoryParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(TimeIntervalFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> oldestTimestampOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof AbstractChannelsHistoryParams) {
                Optional<Boolean> shouldIncludeUnreadsOptional;
                Optional<Integer> countOptional;
                instance = (AbstractChannelsHistoryParams)object;
                if ((bits & 1L) == 0L) {
                    oldestTimestampOptional = instance.getOldestTimestamp();
                    if (oldestTimestampOptional.isPresent()) {
                        this.setOldestTimestamp(oldestTimestampOptional);
                    }
                    bits |= 1L;
                }
                if ((countOptional = ((AbstractChannelsHistoryParams)instance).getCount()).isPresent()) {
                    this.setCount(countOptional);
                }
                if ((bits & 2L) == 0L) {
                    Optional<Boolean> inclusiveOptional = ((AbstractChannelsHistoryParams)instance).isInclusive();
                    if (inclusiveOptional.isPresent()) {
                        this.setInclusive(inclusiveOptional);
                    }
                    bits |= 2L;
                }
                if ((shouldIncludeUnreadsOptional = ((AbstractChannelsHistoryParams)instance).shouldIncludeUnreads()).isPresent()) {
                    this.setShouldIncludeUnreads(shouldIncludeUnreadsOptional);
                }
                if ((bits & 4L) == 0L) {
                    Optional<String> newestTimestampOptional = instance.getNewestTimestamp();
                    if (newestTimestampOptional.isPresent()) {
                        this.setNewestTimestamp(newestTimestampOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.setChannelId(((AbstractChannelsHistoryParams)instance).getChannelId());
                    bits |= 8L;
                }
            }
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 8L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 8L;
                }
            }
            if (object instanceof TimeIntervalFilter) {
                instance = (TimeIntervalFilter)object;
                if ((bits & 1L) == 0L) {
                    oldestTimestampOptional = instance.getOldestTimestamp();
                    if (oldestTimestampOptional.isPresent()) {
                        this.setOldestTimestamp(oldestTimestampOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<Boolean> inclusiveOptional = instance.isInclusive();
                    if (inclusiveOptional.isPresent()) {
                        this.setInclusive(inclusiveOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    Optional<String> newestTimestampOptional = instance.getNewestTimestamp();
                    if (newestTimestampOptional.isPresent()) {
                        this.setNewestTimestamp(newestTimestampOptional);
                    }
                    bits |= 4L;
                }
            }
        }

        public final Builder setNewestTimestamp(@Nullable String newestTimestamp) {
            this.newestTimestamp = newestTimestamp;
            return this;
        }

        public final Builder setNewestTimestamp(Optional<String> newestTimestamp) {
            this.newestTimestamp = newestTimestamp.orElse(null);
            return this;
        }

        public final Builder setOldestTimestamp(@Nullable String oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp;
            return this;
        }

        public final Builder setOldestTimestamp(Optional<String> oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp.orElse(null);
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setCount(@Nullable Integer count) {
            this.count = count;
            return this;
        }

        public final Builder setCount(Optional<Integer> count) {
            this.count = count.orElse(null);
            return this;
        }

        public final Builder setInclusive(@Nullable Boolean inclusive) {
            this.inclusive = inclusive;
            return this;
        }

        public final Builder setInclusive(Optional<Boolean> inclusive) {
            this.inclusive = inclusive.orElse(null);
            return this;
        }

        public final Builder setShouldIncludeUnreads(@Nullable Boolean shouldIncludeUnreads) {
            this.shouldIncludeUnreads = shouldIncludeUnreads;
            return this;
        }

        public final Builder setShouldIncludeUnreads(Optional<Boolean> shouldIncludeUnreads) {
            this.shouldIncludeUnreads = shouldIncludeUnreads.orElse(null);
            return this;
        }

        public ChannelsHistoryParams build() {
            this.checkRequiredAttributes();
            return ChannelsHistoryParams.validate(new ChannelsHistoryParams(this.newestTimestamp, this.oldestTimestamp, this.channelId, this.count, this.inclusive, this.shouldIncludeUnreads));
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build ChannelsHistoryParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractChannelsHistoryParams", generator="Immutables")
    static final class Json
    extends AbstractChannelsHistoryParams {
        @Nullable
        Optional<String> newestTimestamp = Optional.empty();
        @Nullable
        Optional<String> oldestTimestamp = Optional.empty();
        @Nullable
        String channelId;
        @Nullable
        Optional<Integer> count = Optional.empty();
        @Nullable
        Optional<Boolean> inclusive = Optional.empty();
        @Nullable
        Optional<Boolean> shouldIncludeUnreads = Optional.empty();

        Json() {
        }

        @JsonProperty(value="latest")
        public void setNewestTimestamp(Optional<String> newestTimestamp) {
            this.newestTimestamp = newestTimestamp;
        }

        @JsonProperty(value="oldest")
        public void setOldestTimestamp(Optional<String> oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setCount(Optional<Integer> count) {
            this.count = count;
        }

        @JsonProperty(value="is_inclusive")
        public void setInclusive(Optional<Boolean> inclusive) {
            this.inclusive = inclusive;
        }

        @JsonProperty(value="unreads")
        public void setShouldIncludeUnreads(Optional<Boolean> shouldIncludeUnreads) {
            this.shouldIncludeUnreads = shouldIncludeUnreads;
        }

        @Override
        public Optional<String> getNewestTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getOldestTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public PagingDirection getPagingDirection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isInclusive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> shouldIncludeUnreads() {
            throw new UnsupportedOperationException();
        }
    }
}

