/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.bookmarks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.bookmarks.BookmarksEditParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BookmarksEditParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class BookmarksEditParams
implements BookmarksEditParamsIF {
    private final String channelId;
    private final transient String channel;
    private final String bookmarkId;
    @Nullable
    private final String emoji;
    @Nullable
    private final String link;
    @Nullable
    private final String title;

    private BookmarksEditParams(String channelId, String bookmarkId, @Nullable String emoji, @Nullable String link, @Nullable String title) {
        this.channelId = channelId;
        this.bookmarkId = bookmarkId;
        this.emoji = emoji;
        this.link = link;
        this.title = title;
        this.channel = Objects.requireNonNull(BookmarksEditParamsIF.super.getChannel(), "channel");
    }

    @Override
    @JsonProperty
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public String getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public String getBookmarkId() {
        return this.bookmarkId;
    }

    @Override
    @JsonProperty
    public Optional<String> getEmoji() {
        return Optional.ofNullable(this.emoji);
    }

    @Override
    @JsonProperty
    public Optional<String> getLink() {
        return Optional.ofNullable(this.link);
    }

    @Override
    @JsonProperty
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public final BookmarksEditParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new BookmarksEditParams(newValue, this.bookmarkId, this.emoji, this.link, this.title);
    }

    public final BookmarksEditParams withBookmarkId(String value) {
        String newValue = Objects.requireNonNull(value, "bookmarkId");
        if (this.bookmarkId.equals(newValue)) {
            return this;
        }
        return new BookmarksEditParams(this.channelId, newValue, this.emoji, this.link, this.title);
    }

    public final BookmarksEditParams withEmoji(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.emoji, newValue)) {
            return this;
        }
        return new BookmarksEditParams(this.channelId, this.bookmarkId, newValue, this.link, this.title);
    }

    public final BookmarksEditParams withEmoji(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.emoji, value)) {
            return this;
        }
        return new BookmarksEditParams(this.channelId, this.bookmarkId, value, this.link, this.title);
    }

    public final BookmarksEditParams withLink(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.link, newValue)) {
            return this;
        }
        return new BookmarksEditParams(this.channelId, this.bookmarkId, this.emoji, newValue, this.title);
    }

    public final BookmarksEditParams withLink(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.link, value)) {
            return this;
        }
        return new BookmarksEditParams(this.channelId, this.bookmarkId, this.emoji, value, this.title);
    }

    public final BookmarksEditParams withTitle(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new BookmarksEditParams(this.channelId, this.bookmarkId, this.emoji, this.link, newValue);
    }

    public final BookmarksEditParams withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new BookmarksEditParams(this.channelId, this.bookmarkId, this.emoji, this.link, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BookmarksEditParams && this.equalTo(0, (BookmarksEditParams)another);
    }

    private boolean equalTo(int synthetic, BookmarksEditParams another) {
        return this.channelId.equals(another.channelId) && this.channel.equals(another.channel) && this.bookmarkId.equals(another.bookmarkId) && Objects.equals(this.emoji, another.emoji) && Objects.equals(this.link, another.link) && Objects.equals(this.title, another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.bookmarkId.hashCode();
        h += (h << 5) + Objects.hashCode(this.emoji);
        h += (h << 5) + Objects.hashCode(this.link);
        h += (h << 5) + Objects.hashCode(this.title);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BookmarksEditParams{");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("channel=").append(this.channel);
        builder.append(", ");
        builder.append("bookmarkId=").append(this.bookmarkId);
        if (this.emoji != null) {
            builder.append(", ");
            builder.append("emoji=").append(this.emoji);
        }
        if (this.link != null) {
            builder.append(", ");
            builder.append("link=").append(this.link);
        }
        if (this.title != null) {
            builder.append(", ");
            builder.append("title=").append(this.title);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BookmarksEditParams fromJson(Json json) {
        Builder builder = BookmarksEditParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.bookmarkId != null) {
            builder.setBookmarkId(json.bookmarkId);
        }
        if (json.emoji != null) {
            builder.setEmoji(json.emoji);
        }
        if (json.link != null) {
            builder.setLink(json.link);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        return builder.build();
    }

    public static BookmarksEditParams copyOf(BookmarksEditParamsIF instance) {
        if (instance instanceof BookmarksEditParams) {
            return (BookmarksEditParams)instance;
        }
        return BookmarksEditParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BookmarksEditParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_BOOKMARK_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String channelId;
        @Nullable
        private String bookmarkId;
        @Nullable
        private String emoji;
        @Nullable
        private String link;
        @Nullable
        private String title;

        private Builder() {
        }

        public final Builder from(BookmarksEditParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof BookmarksEditParamsIF) {
                Optional<String> titleOptional;
                instance = (BookmarksEditParamsIF)object;
                Optional<String> linkOptional = instance.getLink();
                if (linkOptional.isPresent()) {
                    this.setLink(linkOptional);
                }
                this.setBookmarkId(instance.getBookmarkId());
                Optional<String> emojiOptional = instance.getEmoji();
                if (emojiOptional.isPresent()) {
                    this.setEmoji(emojiOptional);
                }
                if ((titleOptional = instance.getTitle()).isPresent()) {
                    this.setTitle(titleOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setBookmarkId(String bookmarkId) {
            this.bookmarkId = Objects.requireNonNull(bookmarkId, "bookmarkId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setEmoji(@Nullable String emoji) {
            this.emoji = emoji;
            return this;
        }

        public final Builder setEmoji(Optional<String> emoji) {
            this.emoji = emoji.orElse(null);
            return this;
        }

        public final Builder setLink(@Nullable String link) {
            this.link = link;
            return this;
        }

        public final Builder setLink(Optional<String> link) {
            this.link = link.orElse(null);
            return this;
        }

        public final Builder setTitle(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder setTitle(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        public BookmarksEditParams build() {
            this.checkRequiredAttributes();
            return new BookmarksEditParams(this.channelId, this.bookmarkId, this.emoji, this.link, this.title);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean bookmarkIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.bookmarkIdIsSet()) {
                attributes.add("bookmarkId");
            }
            return "Cannot build BookmarksEditParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BookmarksEditParamsIF", generator="Immutables")
    static final class Json
    implements BookmarksEditParamsIF {
        @Nullable
        String channelId;
        @Nullable
        String bookmarkId;
        @Nullable
        Optional<String> emoji = Optional.empty();
        @Nullable
        Optional<String> link = Optional.empty();
        @Nullable
        Optional<String> title = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setBookmarkId(String bookmarkId) {
            this.bookmarkId = bookmarkId;
        }

        @JsonProperty
        public void setEmoji(Optional<String> emoji) {
            this.emoji = emoji;
        }

        @JsonProperty
        public void setLink(Optional<String> link) {
            this.link = link;
        }

        @JsonProperty
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBookmarkId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEmoji() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTitle() {
            throw new UnsupportedOperationException();
        }
    }
}

