/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.sms.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.sms.v3.model.PhysicalVolumes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Disk {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="partition_style")
    private PartitionStyleEnum partitionStyle;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="device_use")
    private DeviceUseEnum deviceUse;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="size")
    private Long size;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="used_size")
    private Long usedSize;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="physical_volumes")
    private List<PhysicalVolumes> physicalVolumes = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="disk_id")
    private String diskId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="os_disk")
    private Boolean osDisk;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="relation_name")
    private String relationName;

    public Disk withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Disk withPartitionStyle(PartitionStyleEnum partitionStyle) {
        this.partitionStyle = partitionStyle;
        return this;
    }

    public PartitionStyleEnum getPartitionStyle() {
        return this.partitionStyle;
    }

    public void setPartitionStyle(PartitionStyleEnum partitionStyle) {
        this.partitionStyle = partitionStyle;
    }

    public Disk withDeviceUse(DeviceUseEnum deviceUse) {
        this.deviceUse = deviceUse;
        return this;
    }

    public DeviceUseEnum getDeviceUse() {
        return this.deviceUse;
    }

    public void setDeviceUse(DeviceUseEnum deviceUse) {
        this.deviceUse = deviceUse;
    }

    public Disk withSize(Long size) {
        this.size = size;
        return this;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Disk withUsedSize(Long usedSize) {
        this.usedSize = usedSize;
        return this;
    }

    public Long getUsedSize() {
        return this.usedSize;
    }

    public void setUsedSize(Long usedSize) {
        this.usedSize = usedSize;
    }

    public Disk withPhysicalVolumes(List<PhysicalVolumes> physicalVolumes) {
        this.physicalVolumes = physicalVolumes;
        return this;
    }

    public Disk addPhysicalVolumesItem(PhysicalVolumes physicalVolumesItem) {
        if (this.physicalVolumes == null) {
            this.physicalVolumes = new ArrayList<PhysicalVolumes>();
        }
        this.physicalVolumes.add(physicalVolumesItem);
        return this;
    }

    public Disk withPhysicalVolumes(Consumer<List<PhysicalVolumes>> physicalVolumesSetter) {
        if (this.physicalVolumes == null) {
            this.physicalVolumes = new ArrayList<PhysicalVolumes>();
        }
        physicalVolumesSetter.accept(this.physicalVolumes);
        return this;
    }

    public List<PhysicalVolumes> getPhysicalVolumes() {
        return this.physicalVolumes;
    }

    public void setPhysicalVolumes(List<PhysicalVolumes> physicalVolumes) {
        this.physicalVolumes = physicalVolumes;
    }

    public Disk withDiskId(String diskId) {
        this.diskId = diskId;
        return this;
    }

    public String getDiskId() {
        return this.diskId;
    }

    public void setDiskId(String diskId) {
        this.diskId = diskId;
    }

    public Disk withOsDisk(Boolean osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    public Boolean getOsDisk() {
        return this.osDisk;
    }

    public void setOsDisk(Boolean osDisk) {
        this.osDisk = osDisk;
    }

    public Disk withRelationName(String relationName) {
        this.relationName = relationName;
        return this;
    }

    public String getRelationName() {
        return this.relationName;
    }

    public void setRelationName(String relationName) {
        this.relationName = relationName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Disk disk = (Disk)o;
        return Objects.equals(this.name, disk.name) && Objects.equals(this.partitionStyle, disk.partitionStyle) && Objects.equals(this.deviceUse, disk.deviceUse) && Objects.equals(this.size, disk.size) && Objects.equals(this.usedSize, disk.usedSize) && Objects.equals(this.physicalVolumes, disk.physicalVolumes) && Objects.equals(this.diskId, disk.diskId) && Objects.equals(this.osDisk, disk.osDisk) && Objects.equals(this.relationName, disk.relationName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.partitionStyle, this.deviceUse, this.size, this.usedSize, this.physicalVolumes, this.diskId, this.osDisk, this.relationName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Disk {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    partitionStyle: ").append(this.toIndentedString(this.partitionStyle)).append("\n");
        sb.append("    deviceUse: ").append(this.toIndentedString(this.deviceUse)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    usedSize: ").append(this.toIndentedString(this.usedSize)).append("\n");
        sb.append("    physicalVolumes: ").append(this.toIndentedString(this.physicalVolumes)).append("\n");
        sb.append("    diskId: ").append(this.toIndentedString(this.diskId)).append("\n");
        sb.append("    osDisk: ").append(this.toIndentedString(this.osDisk)).append("\n");
        sb.append("    relationName: ").append(this.toIndentedString(this.relationName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class DeviceUseEnum {
        public static final DeviceUseEnum BOOT = new DeviceUseEnum("BOOT");
        public static final DeviceUseEnum OS = new DeviceUseEnum("OS");
        private static final Map<String, DeviceUseEnum> STATIC_FIELDS = DeviceUseEnum.createStaticFields();
        private String value;

        private static Map<String, DeviceUseEnum> createStaticFields() {
            HashMap<String, DeviceUseEnum> map = new HashMap<String, DeviceUseEnum>();
            map.put("BOOT", BOOT);
            map.put("OS", OS);
            return Collections.unmodifiableMap(map);
        }

        DeviceUseEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeviceUseEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            DeviceUseEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new DeviceUseEnum(value);
            }
            return result;
        }

        public static DeviceUseEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            DeviceUseEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof DeviceUseEnum) {
                return this.value.equals(((DeviceUseEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class PartitionStyleEnum {
        public static final PartitionStyleEnum MBR = new PartitionStyleEnum("MBR");
        public static final PartitionStyleEnum GPT = new PartitionStyleEnum("GPT");
        private static final Map<String, PartitionStyleEnum> STATIC_FIELDS = PartitionStyleEnum.createStaticFields();
        private String value;

        private static Map<String, PartitionStyleEnum> createStaticFields() {
            HashMap<String, PartitionStyleEnum> map = new HashMap<String, PartitionStyleEnum>();
            map.put("MBR", MBR);
            map.put("GPT", GPT);
            return Collections.unmodifiableMap(map);
        }

        PartitionStyleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PartitionStyleEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            PartitionStyleEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new PartitionStyleEnum(value);
            }
            return result;
        }

        public static PartitionStyleEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            PartitionStyleEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof PartitionStyleEnum) {
                return this.value.equals(((PartitionStyleEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

