/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.rds.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Datastore {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="version")
    private String version;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="complete_version")
    private String completeVersion;

    public Datastore withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Datastore withVersion(String version) {
        this.version = version;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Datastore withCompleteVersion(String completeVersion) {
        this.completeVersion = completeVersion;
        return this;
    }

    public String getCompleteVersion() {
        return this.completeVersion;
    }

    public void setCompleteVersion(String completeVersion) {
        this.completeVersion = completeVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Datastore datastore = (Datastore)o;
        return Objects.equals(this.type, datastore.type) && Objects.equals(this.version, datastore.version) && Objects.equals(this.completeVersion, datastore.completeVersion);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.version, this.completeVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Datastore {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    completeVersion: ").append(this.toIndentedString(this.completeVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TypeEnum {
        public static final TypeEnum MYSQL = new TypeEnum("MySQL");
        public static final TypeEnum POSTGRESQL = new TypeEnum("PostgreSQL");
        public static final TypeEnum SQLSERVER = new TypeEnum("SQLServer");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("MySQL", MYSQL);
            map.put("PostgreSQL", POSTGRESQL);
            map.put("SQLServer", SQLSERVER);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            TypeEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new TypeEnum(value);
            }
            return result;
        }

        public static TypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            TypeEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

