/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.ies.v1;

import com.huaweicloud.sdk.core.TypeCasts;
import com.huaweicloud.sdk.core.http.FieldExistence;
import com.huaweicloud.sdk.core.http.HttpMethod;
import com.huaweicloud.sdk.core.http.HttpRequestDef;
import com.huaweicloud.sdk.core.http.LocationType;
import com.huaweicloud.sdk.ies.v1.model.CreateEdgeSiteRequest;
import com.huaweicloud.sdk.ies.v1.model.CreateEdgeSiteRequestBody;
import com.huaweicloud.sdk.ies.v1.model.CreateEdgeSiteResponse;
import com.huaweicloud.sdk.ies.v1.model.DeleteEdgeSiteRequest;
import com.huaweicloud.sdk.ies.v1.model.DeleteEdgeSiteResponse;
import com.huaweicloud.sdk.ies.v1.model.ListEdgeSiteMetricsRequest;
import com.huaweicloud.sdk.ies.v1.model.ListEdgeSiteMetricsResponse;
import com.huaweicloud.sdk.ies.v1.model.ListEdgeSitesRequest;
import com.huaweicloud.sdk.ies.v1.model.ListEdgeSitesResponse;
import com.huaweicloud.sdk.ies.v1.model.ListQuotasRequest;
import com.huaweicloud.sdk.ies.v1.model.ListQuotasResponse;
import com.huaweicloud.sdk.ies.v1.model.ListSupportedRegionsRequest;
import com.huaweicloud.sdk.ies.v1.model.ListSupportedRegionsResponse;
import com.huaweicloud.sdk.ies.v1.model.ShowEdgeSiteRequest;
import com.huaweicloud.sdk.ies.v1.model.ShowEdgeSiteResponse;
import com.huaweicloud.sdk.ies.v1.model.UpdateEdgeSiteRequest;
import com.huaweicloud.sdk.ies.v1.model.UpdateEdgeSiteRequestBody;
import com.huaweicloud.sdk.ies.v1.model.UpdateEdgeSiteResponse;
import java.util.List;

public class IesMeta {
    public static final HttpRequestDef<CreateEdgeSiteRequest, CreateEdgeSiteResponse> createEdgeSite = IesMeta.genForcreateEdgeSite();
    public static final HttpRequestDef<DeleteEdgeSiteRequest, DeleteEdgeSiteResponse> deleteEdgeSite = IesMeta.genFordeleteEdgeSite();
    public static final HttpRequestDef<ListEdgeSitesRequest, ListEdgeSitesResponse> listEdgeSites = IesMeta.genForlistEdgeSites();
    public static final HttpRequestDef<ShowEdgeSiteRequest, ShowEdgeSiteResponse> showEdgeSite = IesMeta.genForshowEdgeSite();
    public static final HttpRequestDef<UpdateEdgeSiteRequest, UpdateEdgeSiteResponse> updateEdgeSite = IesMeta.genForupdateEdgeSite();
    public static final HttpRequestDef<ListEdgeSiteMetricsRequest, ListEdgeSiteMetricsResponse> listEdgeSiteMetrics = IesMeta.genForlistEdgeSiteMetrics();
    public static final HttpRequestDef<ListQuotasRequest, ListQuotasResponse> listQuotas = IesMeta.genForlistQuotas();
    public static final HttpRequestDef<ListSupportedRegionsRequest, ListSupportedRegionsResponse> listSupportedRegions = IesMeta.genForlistSupportedRegions();

    private static HttpRequestDef<CreateEdgeSiteRequest, CreateEdgeSiteResponse> genForcreateEdgeSite() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.POST, CreateEdgeSiteRequest.class, CreateEdgeSiteResponse.class).withName("CreateEdgeSite").withUri("/v1/{domain_id}/edge-sites").withContentType("application/json");
        builder.withRequestField("body", LocationType.Body, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(CreateEdgeSiteRequestBody.class), f -> f.withMarshaller(CreateEdgeSiteRequest::getBody, (req, v) -> req.setBody((CreateEdgeSiteRequestBody)v)));
        return builder.build();
    }

    private static HttpRequestDef<DeleteEdgeSiteRequest, DeleteEdgeSiteResponse> genFordeleteEdgeSite() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.DELETE, DeleteEdgeSiteRequest.class, DeleteEdgeSiteResponse.class).withName("DeleteEdgeSite").withUri("/v1/{domain_id}/edge-sites/{site_id}").withContentType("application/json");
        builder.withRequestField("site_id", LocationType.Path, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(DeleteEdgeSiteRequest::getSiteId, (req, v) -> req.setSiteId((String)v)));
        return builder.build();
    }

    private static HttpRequestDef<ListEdgeSitesRequest, ListEdgeSitesResponse> genForlistEdgeSites() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.GET, ListEdgeSitesRequest.class, ListEdgeSitesResponse.class).withName("ListEdgeSites").withUri("/v1/{domain_id}/edge-sites").withContentType("application/json");
        builder.withRequestField("limit", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(Integer.class), f -> f.withMarshaller(ListEdgeSitesRequest::getLimit, (req, v) -> req.setLimit((Integer)v)));
        builder.withRequestField("marker", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(ListEdgeSitesRequest::getMarker, (req, v) -> req.setMarker((String)v)));
        builder.withRequestField("sort_key", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(List.class), f -> f.withMarshaller(ListEdgeSitesRequest::getSortKey, (req, v) -> req.setSortKey((List<String>)v)));
        builder.withRequestField("sort_dir", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(List.class), f -> f.withMarshaller(ListEdgeSitesRequest::getSortDir, (req, v) -> req.setSortDir((List<String>)v)));
        builder.withRequestField("id", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(List.class), f -> f.withMarshaller(ListEdgeSitesRequest::getId, (req, v) -> req.setId((List<String>)v)));
        builder.withRequestField("name", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(List.class), f -> f.withMarshaller(ListEdgeSitesRequest::getName, (req, v) -> req.setName((List<String>)v)));
        builder.withRequestField("availability_zone_id", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(List.class), f -> f.withMarshaller(ListEdgeSitesRequest::getAvailabilityZoneId, (req, v) -> req.setAvailabilityZoneId((List<String>)v)));
        builder.withRequestField("status", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(List.class), f -> f.withMarshaller(ListEdgeSitesRequest::getStatus, (req, v) -> req.setStatus((List<String>)v)));
        return builder.build();
    }

    private static HttpRequestDef<ShowEdgeSiteRequest, ShowEdgeSiteResponse> genForshowEdgeSite() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.GET, ShowEdgeSiteRequest.class, ShowEdgeSiteResponse.class).withName("ShowEdgeSite").withUri("/v1/{domain_id}/edge-sites/{site_id}").withContentType("application/json");
        builder.withRequestField("site_id", LocationType.Path, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(ShowEdgeSiteRequest::getSiteId, (req, v) -> req.setSiteId((String)v)));
        return builder.build();
    }

    private static HttpRequestDef<UpdateEdgeSiteRequest, UpdateEdgeSiteResponse> genForupdateEdgeSite() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.PUT, UpdateEdgeSiteRequest.class, UpdateEdgeSiteResponse.class).withName("UpdateEdgeSite").withUri("/v1/{domain_id}/edge-sites/{site_id}").withContentType("application/json");
        builder.withRequestField("site_id", LocationType.Path, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(UpdateEdgeSiteRequest::getSiteId, (req, v) -> req.setSiteId((String)v)));
        builder.withRequestField("body", LocationType.Body, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(UpdateEdgeSiteRequestBody.class), f -> f.withMarshaller(UpdateEdgeSiteRequest::getBody, (req, v) -> req.setBody((UpdateEdgeSiteRequestBody)v)));
        return builder.build();
    }

    private static HttpRequestDef<ListEdgeSiteMetricsRequest, ListEdgeSiteMetricsResponse> genForlistEdgeSiteMetrics() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.GET, ListEdgeSiteMetricsRequest.class, ListEdgeSiteMetricsResponse.class).withName("ListEdgeSiteMetrics").withUri("/v1/{domain_id}/edge-sites/{site_id}/metric-data").withContentType("application/json");
        builder.withRequestField("site_id", LocationType.Path, FieldExistence.NON_NULL_NON_EMPTY, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(ListEdgeSiteMetricsRequest::getSiteId, (req, v) -> req.setSiteId((String)v)));
        builder.withRequestField("dim", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(ListEdgeSiteMetricsRequest.DimEnum.class), f -> f.withMarshaller(ListEdgeSiteMetricsRequest::getDim, (req, v) -> req.setDim((ListEdgeSiteMetricsRequest.DimEnum)v)));
        return builder.build();
    }

    private static HttpRequestDef<ListQuotasRequest, ListQuotasResponse> genForlistQuotas() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.GET, ListQuotasRequest.class, ListQuotasResponse.class).withName("ListQuotas").withUri("/v1/{domain_id}/quotas").withContentType("application/json");
        return builder.build();
    }

    private static HttpRequestDef<ListSupportedRegionsRequest, ListSupportedRegionsResponse> genForlistSupportedRegions() {
        HttpRequestDef.Builder builder = HttpRequestDef.builder((HttpMethod)HttpMethod.GET, ListSupportedRegionsRequest.class, ListSupportedRegionsResponse.class).withName("ListSupportedRegions").withUri("/v1/{domain_id}/regions").withContentType("application/json");
        builder.withRequestField("limit", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(Integer.class), f -> f.withMarshaller(ListSupportedRegionsRequest::getLimit, (req, v) -> req.setLimit((Integer)v)));
        builder.withRequestField("marker", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(String.class), f -> f.withMarshaller(ListSupportedRegionsRequest::getMarker, (req, v) -> req.setMarker((String)v)));
        builder.withRequestField("sort_key", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(List.class), f -> f.withMarshaller(ListSupportedRegionsRequest::getSortKey, (req, v) -> req.setSortKey((List<String>)v)));
        builder.withRequestField("sort_dir", LocationType.Query, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(List.class), f -> f.withMarshaller(ListSupportedRegionsRequest::getSortDir, (req, v) -> req.setSortDir((List<String>)v)));
        builder.withRequestField("X-Language", LocationType.Header, FieldExistence.NULL_IGNORE, (Class)TypeCasts.uncheckedConversion(ListSupportedRegionsRequest.XLanguageEnum.class), f -> f.withMarshaller(ListSupportedRegionsRequest::getXLanguage, (req, v) -> req.setXLanguage((ListSupportedRegionsRequest.XLanguageEnum)v)));
        return builder.build();
    }
}

