/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.iam.v3.model.IdentityToken;
import com.huaweicloud.sdk.iam.v3.model.ServicePolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TokenAuthIdentity {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="methods")
    private List<MethodsEnum> methods = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="token")
    private IdentityToken token;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="policy")
    private ServicePolicy policy;

    public TokenAuthIdentity withMethods(List<MethodsEnum> methods) {
        this.methods = methods;
        return this;
    }

    public TokenAuthIdentity addMethodsItem(MethodsEnum methodsItem) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodsEnum>();
        }
        this.methods.add(methodsItem);
        return this;
    }

    public TokenAuthIdentity withMethods(Consumer<List<MethodsEnum>> methodsSetter) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodsEnum>();
        }
        methodsSetter.accept(this.methods);
        return this;
    }

    public List<MethodsEnum> getMethods() {
        return this.methods;
    }

    public void setMethods(List<MethodsEnum> methods) {
        this.methods = methods;
    }

    public TokenAuthIdentity withToken(IdentityToken token) {
        this.token = token;
        return this;
    }

    public TokenAuthIdentity withToken(Consumer<IdentityToken> tokenSetter) {
        if (this.token == null) {
            this.token = new IdentityToken();
            tokenSetter.accept(this.token);
        }
        return this;
    }

    public IdentityToken getToken() {
        return this.token;
    }

    public void setToken(IdentityToken token) {
        this.token = token;
    }

    public TokenAuthIdentity withPolicy(ServicePolicy policy) {
        this.policy = policy;
        return this;
    }

    public TokenAuthIdentity withPolicy(Consumer<ServicePolicy> policySetter) {
        if (this.policy == null) {
            this.policy = new ServicePolicy();
            policySetter.accept(this.policy);
        }
        return this;
    }

    public ServicePolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(ServicePolicy policy) {
        this.policy = policy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenAuthIdentity tokenAuthIdentity = (TokenAuthIdentity)o;
        return Objects.equals(this.methods, tokenAuthIdentity.methods) && Objects.equals(this.token, tokenAuthIdentity.token) && Objects.equals(this.policy, tokenAuthIdentity.policy);
    }

    public int hashCode() {
        return Objects.hash(this.methods, this.token, this.policy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenAuthIdentity {\n");
        sb.append("    methods: ").append(this.toIndentedString(this.methods)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class MethodsEnum {
        public static final MethodsEnum TOKEN = new MethodsEnum("token");
        private static final Map<String, MethodsEnum> STATIC_FIELDS = MethodsEnum.createStaticFields();
        private String value;

        private static Map<String, MethodsEnum> createStaticFields() {
            HashMap<String, MethodsEnum> map = new HashMap<String, MethodsEnum>();
            map.put("token", TOKEN);
            return Collections.unmodifiableMap(map);
        }

        MethodsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodsEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            MethodsEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new MethodsEnum(value);
            }
            return result;
        }

        public static MethodsEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            MethodsEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodsEnum) {
                return this.value.equals(((MethodsEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

