/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PolicyStatement {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Action")
    private List<String> action = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Effect")
    private EffectEnum effect;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Condition")
    private Object condition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Resource")
    private List<String> resource = null;

    public PolicyStatement withAction(List<String> action) {
        this.action = action;
        return this;
    }

    public PolicyStatement addActionItem(String actionItem) {
        if (this.action == null) {
            this.action = new ArrayList<String>();
        }
        this.action.add(actionItem);
        return this;
    }

    public PolicyStatement withAction(Consumer<List<String>> actionSetter) {
        if (this.action == null) {
            this.action = new ArrayList<String>();
        }
        actionSetter.accept(this.action);
        return this;
    }

    public List<String> getAction() {
        return this.action;
    }

    public void setAction(List<String> action) {
        this.action = action;
    }

    public PolicyStatement withEffect(EffectEnum effect) {
        this.effect = effect;
        return this;
    }

    public EffectEnum getEffect() {
        return this.effect;
    }

    public void setEffect(EffectEnum effect) {
        this.effect = effect;
    }

    public PolicyStatement withCondition(Object condition) {
        this.condition = condition;
        return this;
    }

    public Object getCondition() {
        return this.condition;
    }

    public void setCondition(Object condition) {
        this.condition = condition;
    }

    public PolicyStatement withResource(List<String> resource) {
        this.resource = resource;
        return this;
    }

    public PolicyStatement addResourceItem(String resourceItem) {
        if (this.resource == null) {
            this.resource = new ArrayList<String>();
        }
        this.resource.add(resourceItem);
        return this;
    }

    public PolicyStatement withResource(Consumer<List<String>> resourceSetter) {
        if (this.resource == null) {
            this.resource = new ArrayList<String>();
        }
        resourceSetter.accept(this.resource);
        return this;
    }

    public List<String> getResource() {
        return this.resource;
    }

    public void setResource(List<String> resource) {
        this.resource = resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyStatement policyStatement = (PolicyStatement)o;
        return Objects.equals(this.action, policyStatement.action) && Objects.equals(this.effect, policyStatement.effect) && Objects.equals(this.condition, policyStatement.condition) && Objects.equals(this.resource, policyStatement.resource);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.effect, this.condition, this.resource);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyStatement {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    effect: ").append(this.toIndentedString(this.effect)).append("\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class EffectEnum {
        public static final EffectEnum ALLOW = new EffectEnum("Allow");
        public static final EffectEnum DENY = new EffectEnum("Deny");
        private static final Map<String, EffectEnum> STATIC_FIELDS = EffectEnum.createStaticFields();
        private String value;

        private static Map<String, EffectEnum> createStaticFields() {
            HashMap<String, EffectEnum> map = new HashMap<String, EffectEnum>();
            map.put("Allow", ALLOW);
            map.put("Deny", DENY);
            return Collections.unmodifiableMap(map);
        }

        EffectEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EffectEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            EffectEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new EffectEnum(value);
            }
            return result;
        }

        public static EffectEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            EffectEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof EffectEnum) {
                return this.value.equals(((EffectEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

