/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.iam.v3.model.MfaTotp;
import com.huaweicloud.sdk.iam.v3.model.PwdPassword;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MfaIdentity {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="methods")
    private List<MethodsEnum> methods = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="password")
    private PwdPassword password;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="totp")
    private MfaTotp totp;

    public MfaIdentity withMethods(List<MethodsEnum> methods) {
        this.methods = methods;
        return this;
    }

    public MfaIdentity addMethodsItem(MethodsEnum methodsItem) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodsEnum>();
        }
        this.methods.add(methodsItem);
        return this;
    }

    public MfaIdentity withMethods(Consumer<List<MethodsEnum>> methodsSetter) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodsEnum>();
        }
        methodsSetter.accept(this.methods);
        return this;
    }

    public List<MethodsEnum> getMethods() {
        return this.methods;
    }

    public void setMethods(List<MethodsEnum> methods) {
        this.methods = methods;
    }

    public MfaIdentity withPassword(PwdPassword password) {
        this.password = password;
        return this;
    }

    public MfaIdentity withPassword(Consumer<PwdPassword> passwordSetter) {
        if (this.password == null) {
            this.password = new PwdPassword();
            passwordSetter.accept(this.password);
        }
        return this;
    }

    public PwdPassword getPassword() {
        return this.password;
    }

    public void setPassword(PwdPassword password) {
        this.password = password;
    }

    public MfaIdentity withTotp(MfaTotp totp) {
        this.totp = totp;
        return this;
    }

    public MfaIdentity withTotp(Consumer<MfaTotp> totpSetter) {
        if (this.totp == null) {
            this.totp = new MfaTotp();
            totpSetter.accept(this.totp);
        }
        return this;
    }

    public MfaTotp getTotp() {
        return this.totp;
    }

    public void setTotp(MfaTotp totp) {
        this.totp = totp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MfaIdentity mfaIdentity = (MfaIdentity)o;
        return Objects.equals(this.methods, mfaIdentity.methods) && Objects.equals(this.password, mfaIdentity.password) && Objects.equals(this.totp, mfaIdentity.totp);
    }

    public int hashCode() {
        return Objects.hash(this.methods, this.password, this.totp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MfaIdentity {\n");
        sb.append("    methods: ").append(this.toIndentedString(this.methods)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    totp: ").append(this.toIndentedString(this.totp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class MethodsEnum {
        public static final MethodsEnum PASSWORD = new MethodsEnum("password");
        public static final MethodsEnum _TOTP = new MethodsEnum(" totp");
        private static final Map<String, MethodsEnum> STATIC_FIELDS = MethodsEnum.createStaticFields();
        private String value;

        private static Map<String, MethodsEnum> createStaticFields() {
            HashMap<String, MethodsEnum> map = new HashMap<String, MethodsEnum>();
            map.put("password", PASSWORD);
            map.put(" totp", _TOTP);
            return Collections.unmodifiableMap(map);
        }

        MethodsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodsEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            MethodsEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new MethodsEnum(value);
            }
            return result;
        }

        public static MethodsEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            MethodsEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodsEnum) {
                return this.value.equals(((MethodsEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

