/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iam.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.iam.v3.model.IdentityAssumerole;
import com.huaweicloud.sdk.iam.v3.model.ServicePolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AgencyAuthIdentity {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="methods")
    private List<MethodsEnum> methods = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="assume_role")
    private IdentityAssumerole assumeRole;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="policy")
    private ServicePolicy policy;

    public AgencyAuthIdentity withMethods(List<MethodsEnum> methods) {
        this.methods = methods;
        return this;
    }

    public AgencyAuthIdentity addMethodsItem(MethodsEnum methodsItem) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodsEnum>();
        }
        this.methods.add(methodsItem);
        return this;
    }

    public AgencyAuthIdentity withMethods(Consumer<List<MethodsEnum>> methodsSetter) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodsEnum>();
        }
        methodsSetter.accept(this.methods);
        return this;
    }

    public List<MethodsEnum> getMethods() {
        return this.methods;
    }

    public void setMethods(List<MethodsEnum> methods) {
        this.methods = methods;
    }

    public AgencyAuthIdentity withAssumeRole(IdentityAssumerole assumeRole) {
        this.assumeRole = assumeRole;
        return this;
    }

    public AgencyAuthIdentity withAssumeRole(Consumer<IdentityAssumerole> assumeRoleSetter) {
        if (this.assumeRole == null) {
            this.assumeRole = new IdentityAssumerole();
            assumeRoleSetter.accept(this.assumeRole);
        }
        return this;
    }

    public IdentityAssumerole getAssumeRole() {
        return this.assumeRole;
    }

    public void setAssumeRole(IdentityAssumerole assumeRole) {
        this.assumeRole = assumeRole;
    }

    public AgencyAuthIdentity withPolicy(ServicePolicy policy) {
        this.policy = policy;
        return this;
    }

    public AgencyAuthIdentity withPolicy(Consumer<ServicePolicy> policySetter) {
        if (this.policy == null) {
            this.policy = new ServicePolicy();
            policySetter.accept(this.policy);
        }
        return this;
    }

    public ServicePolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(ServicePolicy policy) {
        this.policy = policy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgencyAuthIdentity agencyAuthIdentity = (AgencyAuthIdentity)o;
        return Objects.equals(this.methods, agencyAuthIdentity.methods) && Objects.equals(this.assumeRole, agencyAuthIdentity.assumeRole) && Objects.equals(this.policy, agencyAuthIdentity.policy);
    }

    public int hashCode() {
        return Objects.hash(this.methods, this.assumeRole, this.policy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgencyAuthIdentity {\n");
        sb.append("    methods: ").append(this.toIndentedString(this.methods)).append("\n");
        sb.append("    assumeRole: ").append(this.toIndentedString(this.assumeRole)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class MethodsEnum {
        public static final MethodsEnum ASSUME_ROLE = new MethodsEnum("assume_role");
        private static final Map<String, MethodsEnum> STATIC_FIELDS = MethodsEnum.createStaticFields();
        private String value;

        private static Map<String, MethodsEnum> createStaticFields() {
            HashMap<String, MethodsEnum> map = new HashMap<String, MethodsEnum>();
            map.put("assume_role", ASSUME_ROLE);
            return Collections.unmodifiableMap(map);
        }

        MethodsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodsEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            MethodsEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new MethodsEnum(value);
            }
            return result;
        }

        public static MethodsEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            MethodsEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodsEnum) {
                return this.value.equals(((MethodsEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

