/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.utils;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.json.OffsetDateTimeDeserializer;
import com.huaweicloud.sdk.core.json.StrictBooleanDeserializer;
import com.huaweicloud.sdk.core.json.StrictDoubleDeserializer;
import com.huaweicloud.sdk.core.json.StrictFloatDeserializer;
import com.huaweicloud.sdk.core.json.StrictIntegerDeserializer;
import com.huaweicloud.sdk.core.json.StrictLongDeserializer;
import com.huaweicloud.sdk.core.json.StrictStringDeserializer;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlUtils {
    private static final Logger logger = LoggerFactory.getLogger(XmlUtils.class);
    private static final ObjectMapper OBJECT_MAPPER_IGNORE_UNKNOWN = XmlUtils.initializeBaseMapper();

    private XmlUtils() {
    }

    private static ObjectMapper initializeBaseMapper() {
        JacksonXmlModule xmlModule = new JacksonXmlModule();
        xmlModule.setDefaultUseWrapper(false);
        ObjectMapper mapper = new XmlMapper(xmlModule).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new SimpleModule().addDeserializer(OffsetDateTime.class, (JsonDeserializer)new OffsetDateTimeDeserializer())).registerModule((Module)new SimpleModule().addDeserializer(Boolean.class, (JsonDeserializer)new StrictBooleanDeserializer())).registerModule((Module)new SimpleModule().addDeserializer(Integer.class, (JsonDeserializer)new StrictIntegerDeserializer())).registerModule((Module)new SimpleModule().addDeserializer(Long.class, (JsonDeserializer)new StrictLongDeserializer())).registerModule((Module)new SimpleModule().addDeserializer(Double.class, (JsonDeserializer)new StrictDoubleDeserializer())).registerModule((Module)new SimpleModule().addDeserializer(Float.class, (JsonDeserializer)new StrictFloatDeserializer())).registerModule((Module)new SimpleModule().addDeserializer(String.class, (JsonDeserializer)new StrictStringDeserializer())).setFilterProvider((FilterProvider)new SimpleFilterProvider().setFailOnUnknownId(false));
        DeserializationConfig readConfig = mapper.getDeserializationConfig().with((FormatFeature)JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS);
        SerializationConfig writeConfig = mapper.getSerializationConfig().with((FormatFeature)JsonWriteFeature.ESCAPE_NON_ASCII);
        return mapper.setConfig(readConfig).setConfig(writeConfig);
    }

    public static ObjectMapper getDefaultMapper() {
        return OBJECT_MAPPER_IGNORE_UNKNOWN;
    }

    public static String toJSON(Object object) {
        try {
            return OBJECT_MAPPER_IGNORE_UNKNOWN.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toJSON] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        try {
            return (T)(StringUtils.isEmpty(json) ? null : OBJECT_MAPPER_IGNORE_UNKNOWN.readValue(json, clazz));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toObject] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> T toObject(String json, TypeReference<T> type) {
        try {
            return (T)(StringUtils.isEmpty(json) ? null : OBJECT_MAPPER_IGNORE_UNKNOWN.readValue(json, type));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toObject] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> List<T> toListObject(String json, Class<T> clazz) {
        try {
            return StringUtils.isEmpty(json) ? null : (List)OBJECT_MAPPER_IGNORE_UNKNOWN.readValue(json, OBJECT_MAPPER_IGNORE_UNKNOWN.getTypeFactory().constructParametricType(List.class, new Class[]{clazz}));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toListObject] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> Map<String, T> toMapObject(String json, Class<T> clazz) {
        try {
            return StringUtils.isEmpty(json) ? null : (Map)OBJECT_MAPPER_IGNORE_UNKNOWN.readValue(json, (JavaType)OBJECT_MAPPER_IGNORE_UNKNOWN.getTypeFactory().constructMapType(Map.class, String.class, clazz));
        }
        catch (JsonProcessingException e) {
            logger.error("[Method toListObject] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }

    public static <T> T fromStream(InputStream is, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER_IGNORE_UNKNOWN.readValue(is, clazz);
        }
        catch (IOException e) {
            logger.error("[Method fromStream] Internal Error occurs: ", (Throwable)e);
            throw new SdkException(e);
        }
    }
}

