/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.region;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.region.Region;
import com.huaweicloud.sdk.core.utils.PathUtils;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ProfileRegionCache {
    private static final ProfileRegionCache INSTANCE = ProfileRegionCache.createInstance();
    private static final String DEFAULT_REGIONS_FILE_NAME = "regions.yaml";
    private static final String REGIONS_FILE_ENV = "HUAWEICLOUD_SDK_REGIONS_FILE";
    protected final Map<String, Region> value;

    private ProfileRegionCache(Map<String, Region> value) {
        this.value = value;
    }

    protected static ProfileRegionCache getInstance() {
        return INSTANCE;
    }

    private static ProfileRegionCache createInstance() {
        Map map;
        LinkedHashMap<String, Region> result = new LinkedHashMap<String, Region>();
        String regionsFilePath = ProfileRegionCache.getRegionsFilePath();
        if (Objects.isNull(regionsFilePath) || !PathUtils.isPathExist(regionsFilePath)) {
            return new ProfileRegionCache(Collections.unmodifiableMap(result));
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            map = (Map)mapper.readValue(new File(regionsFilePath), (TypeReference)new TypeReference<Map<String, List<Region>>>(){});
        }
        catch (IOException e) {
            throw new SdkException(String.format("failed to resolve file '%s'", regionsFilePath), e);
        }
        for (Map.Entry entry : map.entrySet()) {
            for (Region region : (List)entry.getValue()) {
                result.put(((String)entry.getKey()).toUpperCase(Locale.ROOT) + region.getId(), region);
            }
        }
        return new ProfileRegionCache(Collections.unmodifiableMap(result));
    }

    private static String getRegionsFilePath() {
        String regionsFile = System.getenv(REGIONS_FILE_ENV);
        if (!StringUtils.isEmpty(regionsFile)) {
            return regionsFile;
        }
        String userHomePath = PathUtils.getUserHomePath();
        return StringUtils.isEmpty(userHomePath) ? null : userHomePath + File.separator + ".huaweicloud" + File.separator + DEFAULT_REGIONS_FILE_NAME;
    }
}

