/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.utils.BinaryUtils;
import com.huaweicloud.sdk.core.utils.SignUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.openeuler.BGMProvider;

public class SM3AKSKSigner {
    private static final String EMPTY_BODY_SM3 = "1ab21d8355cfa17f8e61194831e81a8f22bec8c728fefb747ed035eb5082aa2b";
    private static final String HMAC_SM3 = "HmacSM3";

    public static <T extends AbstractCredentials<T>> Map<String, String> sign(HttpRequest request, T credentials) {
        String dateTimeStamp;
        HashMap<String, String> authenticationHeaders = new HashMap<String, String>();
        authenticationHeaders.put("Host", request.getUrl().getAuthority());
        if (request.getHeader("X-Sdk-Date") == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            dateTimeStamp = sdf.format(new Date());
            authenticationHeaders.put("X-Sdk-Date", dateTimeStamp);
        } else {
            dateTimeStamp = request.getHeader("X-Sdk-Date");
        }
        TreeMap<String, String> allHeaders = new TreeMap<String, String>(authenticationHeaders);
        for (String key : request.getHeaders().keySet()) {
            allHeaders.put(key, request.getHeader(key));
        }
        String messageDigestContent = SM3AKSKSigner.calculateContentHash(request);
        String canonicalRequest = SM3AKSKSigner.createCanonicalRequest(request, allHeaders, messageDigestContent);
        byte[] signingKey = SM3AKSKSigner.deriveSigningKey(credentials.getSk());
        String stringToSign = SM3AKSKSigner.createStringToSign(canonicalRequest, dateTimeStamp);
        byte[] signature = SM3AKSKSigner.computeSignature(stringToSign, signingKey);
        String signatureResult = SM3AKSKSigner.buildAuthorizationHeader(allHeaders, signature, credentials.getAk());
        authenticationHeaders.put("Authorization", signatureResult);
        return authenticationHeaders;
    }

    private static String getCanonicalizedResourcePath(String resourcePath) {
        if (resourcePath == null || resourcePath.isEmpty()) {
            return "/";
        }
        try {
            resourcePath = new URI(resourcePath).getPath();
        }
        catch (URISyntaxException e) {
            throw new SdkException("Unable to resolve resource path", e);
        }
        String value = SignUtils.urlEncode(resourcePath, true);
        if (!value.startsWith("/")) {
            value = "/".concat(value);
        }
        if (!value.endsWith("/")) {
            value = value.concat("/");
        }
        return value;
    }

    private static String getCanonicalizedQueryString(Map<String, List<String>> parameters) {
        TreeMap<String, List<String>> sorted = new TreeMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            String encodedParamName = SignUtils.urlEncode(entry.getKey(), false);
            List<String> paramValues = entry.getValue();
            List encodeValues = paramValues.stream().map(paramValue -> SignUtils.urlEncode(paramValue, false)).sorted().collect(Collectors.toList());
            sorted.put(encodedParamName, encodeValues);
        }
        return SignUtils.convertSortedMap2QueryString(sorted);
    }

    private static String createCanonicalRequest(HttpRequest request, Map<String, String> headers, String messageDigestContent) {
        return String.join((CharSequence)"\n", request.getMethod().toString(), SM3AKSKSigner.getCanonicalizedResourcePath(request.getUrl().getPath()), SM3AKSKSigner.getCanonicalizedQueryString(request.getQueryParams()), SM3AKSKSigner.getCanonicalizedHeaderString(headers), SM3AKSKSigner.getSignedHeadersString(headers), messageDigestContent);
    }

    private static String createStringToSign(String canonicalRequest, String singerDate) {
        return String.join((CharSequence)"\n", "SDK-HMAC-SM3", singerDate, BinaryUtils.toHex(SM3AKSKSigner.hashSm3(canonicalRequest)));
    }

    private static byte[] deriveSigningKey(String secret) {
        return secret.getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] signSM3(byte[] data, byte[] key) {
        try {
            Mac mac = Mac.getInstance(HMAC_SM3);
            mac.init(new SecretKeySpec(key, HMAC_SM3));
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SdkException("Unable to calculate a request signature", e);
        }
    }

    private static byte[] computeSignature(String stringToSign, byte[] signingKey) {
        return SM3AKSKSigner.signSM3(stringToSign.getBytes(StandardCharsets.UTF_8), signingKey);
    }

    private static String buildAuthorizationHeader(Map<String, String> headers, byte[] signature, String accessKey) {
        String credential = "Access=" + accessKey;
        String signerHeaders = "SignedHeaders=" + SM3AKSKSigner.getSignedHeadersString(headers);
        String signatureHeader = "Signature=" + BinaryUtils.toHex(signature);
        return "SDK-HMAC-SM3 " + credential + ", " + signerHeaders + ", " + signatureHeader;
    }

    private static String[] getSignedHeaders(Map<String, String> headers) {
        String[] signedHeaders = headers.keySet().toArray(new String[0]);
        Arrays.sort(signedHeaders, String.CASE_INSENSITIVE_ORDER);
        return signedHeaders;
    }

    private static String getCanonicalizedHeaderString(Map<String, String> headers) {
        StringBuilder buffer = new StringBuilder();
        for (String signedHeader : SM3AKSKSigner.getSignedHeaders(headers)) {
            String value = headers.get(signedHeader);
            String key = signedHeader.toLowerCase(Locale.ROOT);
            buffer.append(key).append(":");
            if (value != null) {
                buffer.append(value.trim());
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private static String getSignedHeadersString(Map<String, String> headers) {
        String[] signedHeaders = SM3AKSKSigner.getSignedHeaders(headers);
        if (signedHeaders.length == 0) {
            return "";
        }
        return Arrays.stream(signedHeaders).map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.joining(";"));
    }

    private static String calculateContentHash(HttpRequest request) {
        String body = request.getBodyAsString();
        if (body == null || body.equals("")) {
            return EMPTY_BODY_SM3;
        }
        return BinaryUtils.toHex(SM3AKSKSigner.hashSm3(body));
    }

    private static byte[] hashSm3(String content) {
        byte[] srcData = content.getBytes(StandardCharsets.UTF_8);
        SM3Digest digest = new SM3Digest();
        digest.update(srcData, 0, srcData.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        return hash;
    }

    static {
        if (Security.getProvider("BGMProvider") == null) {
            Security.addProvider((Provider)new BGMProvider());
        }
    }
}

