/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.HcClient;
import com.huaweicloud.sdk.core.auth.AKSKSigner;
import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.auth.AuthCache;
import com.huaweicloud.sdk.core.auth.DerivedAKSKSigner;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.auth.SM3AKSKSigner;
import com.huaweicloud.sdk.core.auth.SigningAlgorithm;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpClient;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.internal.Iam;
import com.huaweicloud.sdk.core.internal.InnerIamMeta;
import com.huaweicloud.sdk.core.internal.model.CreateTokenWithIdTokenResponse;
import com.huaweicloud.sdk.core.internal.model.KeystoneListAuthDomainsRequest;
import com.huaweicloud.sdk.core.internal.model.KeystoneListAuthDomainsResponse;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class GlobalCredentials
extends AbstractCredentials<GlobalCredentials> {
    private String domainId;

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public GlobalCredentials withDomainId(String domainId) {
        this.domainId = domainId;
        return this;
    }

    Map<String, Object> getPathParams() {
        LinkedHashMap<String, Object> pathParam = new LinkedHashMap<String, Object>();
        if (Objects.nonNull(this.domainId)) {
            pathParam.put("domain_id", this.domainId);
        }
        return pathParam;
    }

    @Override
    public CompletableFuture<ICredential> processAuthParams(HcClient hcClient, String regionId) {
        if (!StringUtils.isEmpty(this.getIdpId()) || !StringUtils.isEmpty(this.getIdTokenFile())) {
            if (StringUtils.isEmpty(this.getIdpId())) {
                throw new SdkException("idpId is required when using idpId&idTokenFile");
            }
            if (StringUtils.isEmpty(this.getIdTokenFile())) {
                throw new SdkException("idTokenFile is required when using idpId&idTokenFile");
            }
            if (StringUtils.isEmpty(this.domainId)) {
                throw new SdkException("domainId is required when using idpId&idTokenFile");
            }
        }
        if (!StringUtils.isEmpty(this.domainId)) {
            return CompletableFuture.completedFuture(this);
        }
        String akWithName = this.getAk();
        if (Objects.nonNull(AuthCache.getAuth(akWithName)) && !StringUtils.isEmpty(AuthCache.getAuth(akWithName))) {
            this.domainId = AuthCache.getAuth(akWithName);
            return CompletableFuture.completedFuture(this);
        }
        String iamEndpoint = StringUtils.isEmpty(this.getIamEndpoint()) ? this.getDefaultIamEndpoint() : this.getIamEndpoint();
        HcClient inner = hcClient.overrideEndpoint(iamEndpoint);
        Function<HttpRequest, Boolean> derivedPredicate = this.getDerivedPredicate();
        this.setDerivedPredicate(null);
        KeystoneListAuthDomainsRequest request = new KeystoneListAuthDomainsRequest();
        KeystoneListAuthDomainsResponse response = inner.syncInvokeHttp(request, InnerIamMeta.KEYSTONE_LIST_AUTH_DOMAINS);
        if (Objects.isNull(response) || Objects.isNull(response.getDomains()) || response.getDomains().size() == 0) {
            throw new SdkException("No domain id found, please select one of the following solutions:\n\t1. Manually specify domain_id when initializing the credentials.\n\t2. Use the domain account to grant the current account permissions of the IAM service.\n\t3. Use AK/SK of the domain account.");
        }
        this.domainId = response.getDomains().get(0).getId();
        AuthCache.putAuth(akWithName, this.domainId);
        this.setDerivedPredicate(derivedPredicate);
        return CompletableFuture.completedFuture(this);
    }

    @Override
    public CompletableFuture<HttpRequest> processAuthRequest(HttpRequest httpRequest, HttpClient httpClient) {
        return CompletableFuture.completedFuture(this.syncProcessAuthRequest(httpRequest, httpClient));
    }

    @Override
    public HttpRequest syncProcessAuthRequest(HttpRequest httpRequest, HttpClient httpClient) {
        Map<String, String> headers;
        HttpRequest.HttpRequestBuilder builder = httpRequest.builder().addAutoFilledPathParam(this.getPathParams());
        if (this.needUpdateAuthToken()) {
            this.updateAuthTokenByIdToken(httpClient);
        } else if (this.needUpdateSecurityToken()) {
            this.updateSecurityTokenFromMetadata();
        }
        if (Objects.nonNull(this.getDomainId())) {
            builder.addHeader("X-Domain-Id", this.getDomainId());
        }
        if (Objects.nonNull(this.authToken)) {
            builder.addHeader("X-Auth-Token", this.authToken);
            return builder.build();
        }
        if (Objects.nonNull(this.getSecurityToken())) {
            builder.addHeader("X-Security-Token", this.getSecurityToken());
        }
        if (Objects.nonNull(httpRequest.getContentType()) && !httpRequest.getContentType().startsWith("application/json")) {
            builder.addHeader("X-Sdk-Content-Sha256", "UNSIGNED-PAYLOAD");
        }
        if (this.isDerivedAuth(httpRequest)) {
            headers = DerivedAKSKSigner.sign(builder.build(), this);
        } else if (httpRequest.getSigningAlgorithm() == SigningAlgorithm.HMAC_SHA256) {
            headers = AKSKSigner.sign(builder.build(), this);
        } else if (httpRequest.getSigningAlgorithm() == SigningAlgorithm.HMAC_SM3) {
            headers = SM3AKSKSigner.sign(builder.build(), this);
        } else {
            throw new SdkException("Failed to sign the request");
        }
        builder.addHeaders(headers);
        return builder.build();
    }

    @Override
    protected void updateAuthTokenByIdToken(HttpClient httpClient) {
        String iamEndpoint = StringUtils.isEmpty(this.getIamEndpoint()) ? "https://iam.myhuaweicloud.com" : this.getIamEndpoint();
        HttpRequest httpRequest = Iam.getDomainTokenWithIdTokenRequest(iamEndpoint, this.getIdpId(), this.getIdToken(), this.domainId);
        CreateTokenWithIdTokenResponse response = Iam.createTokenWithIdToken(httpClient, httpRequest);
        this.authToken = response.getSubjectToken();
        try {
            String expiredTime = response.getToken().getExpiresAt().replace("000Z", "Z");
            this.expiredAt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(expiredTime).getTime();
        }
        catch (ParseException e) {
            throw new SdkException(e);
        }
    }

    @Override
    public void processDerivedAuthParams(String derivedAuthServiceName, String regionId) {
        if (this.derivedAuthServiceName == null) {
            this.derivedAuthServiceName = derivedAuthServiceName;
        }
        if (this.regionId == null) {
            this.regionId = "globe";
        }
    }

    @Override
    public GlobalCredentials deepClone() {
        GlobalCredentials credentials = (GlobalCredentials)((GlobalCredentials)((GlobalCredentials)((GlobalCredentials)((GlobalCredentials)((GlobalCredentials)((GlobalCredentials)new GlobalCredentials().withDomainId(this.domainId).withAk(this.getAk())).withSk(this.getSk())).withIdpId(this.getIdpId())).withIdTokenFile(this.getIdTokenFile())).withDerivedPredicate(this.getDerivedPredicate())).withIamEndpoint(this.getIamEndpoint())).withSecurityToken(this.getSecurityToken());
        credentials.processDerivedAuthParams(this.derivedAuthServiceName, this.regionId);
        return credentials;
    }
}

