/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core;

import com.huaweicloud.sdk.core.exchange.SdkExchange;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public interface HttpListener {
    default public void preRequest(RequestListener requestListener) {
    }

    default public void postResponse(ResponseListener responseListener) {
    }

    public static HttpListener forRequestListener(final Consumer<RequestListener> func) {
        return new HttpListener(){

            @Override
            public void preRequest(RequestListener requestListener) {
                func.accept(requestListener);
            }
        };
    }

    public static HttpListener forResponseListener(final Consumer<ResponseListener> func) {
        return new HttpListener(){

            @Override
            public void postResponse(ResponseListener requestListener) {
                func.accept(requestListener);
            }
        };
    }

    public static interface ResponseListener {
        public String httpMethod();

        public String uri();

        public Map<String, List<String>> headers();

        public Optional<String> body();

        public int statusCode();

        public SdkExchange exchange();
    }

    public static interface RequestListener {
        public String httpMethod();

        public String uri();

        public Map<String, List<String>> headers();

        public Optional<String> body();

        public SdkExchange exchange();
    }
}

