/*
 * Decompiled with CFR 0.152.
 */
package com.hp.jipp.pdl.pwg;

import com.hp.jipp.model.Orientation;
import com.hp.jipp.model.PrintQuality;
import com.hp.jipp.pdl.OutputSettings;
import com.hp.jipp.pdl.PdlUtilKt;
import com.hp.jipp.pdl.RenderableDocument;
import com.hp.jipp.pdl.RenderablePage;
import com.hp.jipp.pdl.pwg.PwgHeader;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0086\b\u0018\u0000 02\u00020\u0001:\u000201B/\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\u0007H\u00c6\u0003J\t\u0010*\u001a\u00020\tH\u00c6\u0003J1\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010,\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020&H\u00d6\u0001J\t\u0010/\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00062"}, d2={"Lcom/hp/jipp/pdl/pwg/PwgSettings;", "", "output", "Lcom/hp/jipp/pdl/OutputSettings;", "sheetBack", "", "orientation", "Lcom/hp/jipp/model/Orientation;", "allowPadding", "", "(Lcom/hp/jipp/pdl/OutputSettings;Ljava/lang/String;Lcom/hp/jipp/model/Orientation;Z)V", "getAllowPadding", "()Z", "getOrientation", "()Lcom/hp/jipp/model/Orientation;", "getOutput", "()Lcom/hp/jipp/pdl/OutputSettings;", "pwgColorSpace", "Lcom/hp/jipp/pdl/pwg/PwgHeader$ColorSpace;", "getPwgColorSpace", "()Lcom/hp/jipp/pdl/pwg/PwgHeader$ColorSpace;", "pwgMediaPosition", "Lcom/hp/jipp/pdl/pwg/PwgHeader$MediaPosition;", "getPwgMediaPosition", "()Lcom/hp/jipp/pdl/pwg/PwgHeader$MediaPosition;", "pwgPrintQuality", "Lcom/hp/jipp/pdl/pwg/PwgHeader$PrintQuality;", "getPwgPrintQuality", "()Lcom/hp/jipp/pdl/pwg/PwgHeader$PrintQuality;", "getSheetBack", "()Ljava/lang/String;", "buildHeader", "Lcom/hp/jipp/pdl/pwg/PwgHeader;", "doc", "Lcom/hp/jipp/pdl/RenderableDocument;", "page", "Lcom/hp/jipp/pdl/RenderablePage;", "pageNumber", "", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "Companion", "PwgFeedTransform", "jipp-pdl"})
public final class PwgSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OutputSettings output;
    @NotNull
    private final String sheetBack;
    @NotNull
    private final Orientation orientation;
    private final boolean allowPadding;
    @NotNull
    private final PwgHeader.MediaPosition pwgMediaPosition;
    @NotNull
    private final PwgHeader.ColorSpace pwgColorSpace;
    @NotNull
    private final PwgHeader.PrintQuality pwgPrintQuality;
    private static final int POINTS_PER_INCH = 72;
    public static final int BITS_PER_BYTE = 8;

    @JvmOverloads
    public PwgSettings(@NotNull OutputSettings output, @NotNull String sheetBack, @NotNull Orientation orientation, boolean allowPadding) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)sheetBack, (String)"sheetBack");
        Intrinsics.checkNotNullParameter((Object)orientation, (String)"orientation");
        this.output = output;
        this.sheetBack = sheetBack;
        this.orientation = orientation;
        this.allowPadding = allowPadding;
        this.pwgMediaPosition = PwgSettings.Companion.toPwgMediaPosition(this.output.getSource());
        this.pwgColorSpace = PwgHeader.ColorSpace.Companion.from(this.output.getColorSpace());
        Object object = this.output.getQuality();
        if (object == null || (object = PwgSettings.Companion.toPwgPrintQuality(object)) == null) {
            object = PwgHeader.PrintQuality.Default;
        }
        this.pwgPrintQuality = object;
    }

    public /* synthetic */ PwgSettings(OutputSettings outputSettings, String string, Orientation orientation, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            outputSettings = new OutputSettings(null, null, null, null, false, 0, 63, null);
        }
        if ((n & 2) != 0) {
            string = "normal";
        }
        if ((n & 4) != 0) {
            orientation = Orientation.portrait;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(outputSettings, string, orientation, bl);
    }

    @NotNull
    public final OutputSettings getOutput() {
        return this.output;
    }

    @NotNull
    public final String getSheetBack() {
        return this.sheetBack;
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    public final boolean getAllowPadding() {
        return this.allowPadding;
    }

    @NotNull
    public final PwgHeader.MediaPosition getPwgMediaPosition() {
        return this.pwgMediaPosition;
    }

    @NotNull
    public final PwgHeader.ColorSpace getPwgColorSpace() {
        return this.pwgColorSpace;
    }

    @NotNull
    public final PwgHeader.PrintQuality getPwgPrintQuality() {
        return this.pwgPrintQuality;
    }

    @NotNull
    public final PwgHeader buildHeader(@NotNull RenderableDocument doc, @NotNull RenderablePage page, int pageNumber) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        PwgFeedTransform transform = PwgFeedTransform.Companion.lookup(pageNumber, this.output.getSides(), this.sheetBack);
        int n = doc.getDpi();
        int n2 = doc.getDpi();
        PwgHeader.Orientation orientation = PwgSettings.Companion.toPwgOrientation(this.orientation);
        int n3 = page.getWidthPixels() * 72 / doc.getDpi();
        int n4 = page.getHeightPixels() * 72 / doc.getDpi();
        int n5 = page.getWidthPixels();
        int n6 = page.getHeightPixels();
        int n7 = this.output.getColorSpace().getBytesPerPixel() * 8;
        PwgHeader.ColorSpace colorSpace = this.pwgColorSpace;
        boolean bl = !Intrinsics.areEqual((Object)this.output.getSides(), (Object)"one-sided");
        boolean bl2 = Intrinsics.areEqual((Object)this.output.getSides(), (Object)"two-sided-short-edge");
        PwgHeader.MediaPosition mediaPosition = this.pwgMediaPosition;
        PwgHeader.PrintQuality printQuality = this.pwgPrintQuality;
        int n8 = transform.getFeedTransform();
        int n9 = transform.getCrossFeedTransform();
        return new PwgHeader(null, null, null, null, bl, n, n2, false, null, null, mediaPosition, 0, 0, orientation, n3, n4, bl2, n5, n6, 8, n7, null, colorSpace, 0, n9, n8, 0, 0, 0, 0, 0, printQuality, 0, null, null, null, 2090867599, 15, null);
    }

    @NotNull
    public final OutputSettings component1() {
        return this.output;
    }

    @NotNull
    public final String component2() {
        return this.sheetBack;
    }

    @NotNull
    public final Orientation component3() {
        return this.orientation;
    }

    public final boolean component4() {
        return this.allowPadding;
    }

    @NotNull
    public final PwgSettings copy(@NotNull OutputSettings output, @NotNull String sheetBack, @NotNull Orientation orientation, boolean allowPadding) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)sheetBack, (String)"sheetBack");
        Intrinsics.checkNotNullParameter((Object)orientation, (String)"orientation");
        return new PwgSettings(output, sheetBack, orientation, allowPadding);
    }

    public static /* synthetic */ PwgSettings copy$default(PwgSettings pwgSettings, OutputSettings outputSettings, String string, Orientation orientation, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            outputSettings = pwgSettings.output;
        }
        if ((n & 2) != 0) {
            string = pwgSettings.sheetBack;
        }
        if ((n & 4) != 0) {
            orientation = pwgSettings.orientation;
        }
        if ((n & 8) != 0) {
            bl = pwgSettings.allowPadding;
        }
        return pwgSettings.copy(outputSettings, string, orientation, bl);
    }

    @NotNull
    public String toString() {
        return "PwgSettings(output=" + this.output + ", sheetBack=" + this.sheetBack + ", orientation=" + this.orientation + ", allowPadding=" + this.allowPadding + ')';
    }

    public int hashCode() {
        int result = this.output.hashCode();
        result = result * 31 + this.sheetBack.hashCode();
        result = result * 31 + this.orientation.hashCode();
        int n = this.allowPadding ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PwgSettings)) {
            return false;
        }
        PwgSettings pwgSettings = (PwgSettings)other;
        if (!Intrinsics.areEqual((Object)this.output, (Object)pwgSettings.output)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sheetBack, (Object)pwgSettings.sheetBack)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.orientation, (Object)pwgSettings.orientation)) {
            return false;
        }
        return this.allowPadding == pwgSettings.allowPadding;
    }

    @JvmOverloads
    public PwgSettings(@NotNull OutputSettings output, @NotNull String sheetBack, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)sheetBack, (String)"sheetBack");
        Intrinsics.checkNotNullParameter((Object)orientation, (String)"orientation");
        this(output, sheetBack, orientation, false, 8, null);
    }

    @JvmOverloads
    public PwgSettings(@NotNull OutputSettings output, @NotNull String sheetBack) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)sheetBack, (String)"sheetBack");
        this(output, sheetBack, null, false, 12, null);
    }

    @JvmOverloads
    public PwgSettings(@NotNull OutputSettings output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this(output, null, null, false, 14, null);
    }

    @JvmOverloads
    public PwgSettings() {
        this(null, null, null, false, 15, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/hp/jipp/pdl/pwg/PwgSettings$Companion;", "", "()V", "BITS_PER_BYTE", "", "POINTS_PER_INCH", "toPwgMediaPosition", "Lcom/hp/jipp/pdl/pwg/PwgHeader$MediaPosition;", "", "toPwgOrientation", "Lcom/hp/jipp/pdl/pwg/PwgHeader$Orientation;", "Lcom/hp/jipp/model/Orientation;", "toPwgPrintQuality", "Lcom/hp/jipp/pdl/pwg/PwgHeader$PrintQuality;", "Lcom/hp/jipp/model/PrintQuality;", "jipp-pdl"})
    public static final class Companion {
        private Companion() {
        }

        private final PwgHeader.Orientation toPwgOrientation(Orientation $this$toPwgOrientation) {
            Orientation orientation = $this$toPwgOrientation;
            return Intrinsics.areEqual((Object)orientation, (Object)Orientation.portrait) ? PwgHeader.Orientation.Portrait : (Intrinsics.areEqual((Object)orientation, (Object)Orientation.reversePortrait) ? PwgHeader.Orientation.ReversePortrait : (Intrinsics.areEqual((Object)orientation, (Object)Orientation.landscape) ? PwgHeader.Orientation.Landscape : (Intrinsics.areEqual((Object)orientation, (Object)Orientation.reverseLandscape) ? PwgHeader.Orientation.ReverseLandscape : PwgHeader.Orientation.Portrait)));
        }

        private final PwgHeader.MediaPosition toPwgMediaPosition(String $this$toPwgMediaPosition) {
            PwgHeader.MediaPosition mediaPosition;
            switch ($this$toPwgMediaPosition) {
                case "alternate": {
                    mediaPosition = PwgHeader.MediaPosition.Alternate;
                    break;
                }
                case "alternate-roll": {
                    mediaPosition = PwgHeader.MediaPosition.AlternateRoll;
                    break;
                }
                case "auto": {
                    mediaPosition = PwgHeader.MediaPosition.Auto;
                    break;
                }
                case "bottom": {
                    mediaPosition = PwgHeader.MediaPosition.Bottom;
                    break;
                }
                case "by-pass-tray": {
                    mediaPosition = PwgHeader.MediaPosition.ByPassTray;
                    break;
                }
                case "center": {
                    mediaPosition = PwgHeader.MediaPosition.Center;
                    break;
                }
                case "disc": {
                    mediaPosition = PwgHeader.MediaPosition.Disc;
                    break;
                }
                case "envelope": {
                    mediaPosition = PwgHeader.MediaPosition.Envelope;
                    break;
                }
                case "hagaki": {
                    mediaPosition = PwgHeader.MediaPosition.Hagaki;
                    break;
                }
                case "large-capacity": {
                    mediaPosition = PwgHeader.MediaPosition.LargeCapacity;
                    break;
                }
                case "left": {
                    mediaPosition = PwgHeader.MediaPosition.Left;
                    break;
                }
                case "main": {
                    mediaPosition = PwgHeader.MediaPosition.Main;
                    break;
                }
                case "main-roll": {
                    mediaPosition = PwgHeader.MediaPosition.MainRoll;
                    break;
                }
                case "manual": {
                    mediaPosition = PwgHeader.MediaPosition.Manual;
                    break;
                }
                case "middle": {
                    mediaPosition = PwgHeader.MediaPosition.Middle;
                    break;
                }
                case "photo": {
                    mediaPosition = PwgHeader.MediaPosition.Photo;
                    break;
                }
                case "rear": {
                    mediaPosition = PwgHeader.MediaPosition.Rear;
                    break;
                }
                case "right": {
                    mediaPosition = PwgHeader.MediaPosition.Right;
                    break;
                }
                case "roll-1": {
                    mediaPosition = PwgHeader.MediaPosition.Roll1;
                    break;
                }
                case "roll-10": {
                    mediaPosition = PwgHeader.MediaPosition.Roll10;
                    break;
                }
                case "roll-2": {
                    mediaPosition = PwgHeader.MediaPosition.Roll2;
                    break;
                }
                case "roll-3": {
                    mediaPosition = PwgHeader.MediaPosition.Roll3;
                    break;
                }
                case "roll-4": {
                    mediaPosition = PwgHeader.MediaPosition.Roll4;
                    break;
                }
                case "roll-5": {
                    mediaPosition = PwgHeader.MediaPosition.Roll5;
                    break;
                }
                case "roll-6": {
                    mediaPosition = PwgHeader.MediaPosition.Roll6;
                    break;
                }
                case "roll-7": {
                    mediaPosition = PwgHeader.MediaPosition.Roll7;
                    break;
                }
                case "roll-8": {
                    mediaPosition = PwgHeader.MediaPosition.Roll8;
                    break;
                }
                case "roll-9": {
                    mediaPosition = PwgHeader.MediaPosition.Roll9;
                    break;
                }
                case "side": {
                    mediaPosition = PwgHeader.MediaPosition.Side;
                    break;
                }
                case "top": {
                    mediaPosition = PwgHeader.MediaPosition.Top;
                    break;
                }
                case "tray-1": {
                    mediaPosition = PwgHeader.MediaPosition.Tray1;
                    break;
                }
                case "tray-10": {
                    mediaPosition = PwgHeader.MediaPosition.Tray10;
                    break;
                }
                case "tray-11": {
                    mediaPosition = PwgHeader.MediaPosition.Tray11;
                    break;
                }
                case "tray-12": {
                    mediaPosition = PwgHeader.MediaPosition.Tray12;
                    break;
                }
                case "tray-13": {
                    mediaPosition = PwgHeader.MediaPosition.Tray13;
                    break;
                }
                case "tray-14": {
                    mediaPosition = PwgHeader.MediaPosition.Tray14;
                    break;
                }
                case "tray-15": {
                    mediaPosition = PwgHeader.MediaPosition.Tray15;
                    break;
                }
                case "tray-16": {
                    mediaPosition = PwgHeader.MediaPosition.Tray16;
                    break;
                }
                case "tray-17": {
                    mediaPosition = PwgHeader.MediaPosition.Tray17;
                    break;
                }
                case "tray-18": {
                    mediaPosition = PwgHeader.MediaPosition.Tray18;
                    break;
                }
                case "tray-19": {
                    mediaPosition = PwgHeader.MediaPosition.Tray19;
                    break;
                }
                case "tray-2": {
                    mediaPosition = PwgHeader.MediaPosition.Tray2;
                    break;
                }
                case "tray-20": {
                    mediaPosition = PwgHeader.MediaPosition.Tray20;
                    break;
                }
                case "tray-3": {
                    mediaPosition = PwgHeader.MediaPosition.Tray3;
                    break;
                }
                case "tray-4": {
                    mediaPosition = PwgHeader.MediaPosition.Tray4;
                    break;
                }
                case "tray-5": {
                    mediaPosition = PwgHeader.MediaPosition.Tray5;
                    break;
                }
                case "tray-6": {
                    mediaPosition = PwgHeader.MediaPosition.Tray6;
                    break;
                }
                case "tray-7": {
                    mediaPosition = PwgHeader.MediaPosition.Tray7;
                    break;
                }
                case "tray-8": {
                    mediaPosition = PwgHeader.MediaPosition.Tray8;
                    break;
                }
                case "tray-9": {
                    mediaPosition = PwgHeader.MediaPosition.Tray9;
                    break;
                }
                default: {
                    throw new IllegalArgumentException($this$toPwgMediaPosition + " is not a recognized media source type");
                }
            }
            return mediaPosition;
        }

        private final PwgHeader.PrintQuality toPwgPrintQuality(PrintQuality $this$toPwgPrintQuality) {
            PrintQuality printQuality = $this$toPwgPrintQuality;
            return Intrinsics.areEqual((Object)printQuality, (Object)PrintQuality.draft) ? PwgHeader.PrintQuality.Draft : (Intrinsics.areEqual((Object)printQuality, (Object)PrintQuality.normal) ? PwgHeader.PrintQuality.Normal : (Intrinsics.areEqual((Object)printQuality, (Object)PrintQuality.high) ? PwgHeader.PrintQuality.High : null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/hp/jipp/pdl/pwg/PwgSettings$PwgFeedTransform;", "", "crossFeedTransform", "", "feedTransform", "(II)V", "getCrossFeedTransform", "()I", "getFeedTransform", "Companion", "jipp-pdl"})
    private static final class PwgFeedTransform {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int crossFeedTransform;
        private final int feedTransform;
        @NotNull
        private static final Map<Pair<String, String>, PwgFeedTransform> transforms;
        @NotNull
        private static final PwgFeedTransform default;

        public PwgFeedTransform(int crossFeedTransform, int feedTransform) {
            this.crossFeedTransform = crossFeedTransform;
            this.feedTransform = feedTransform;
        }

        public final int getCrossFeedTransform() {
            return this.crossFeedTransform;
        }

        public final int getFeedTransform() {
            return this.feedTransform;
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TuplesKt.to((Object)"two-sided-long-edge", (Object)"flipped"), (Object)new PwgFeedTransform(1, -1)), TuplesKt.to((Object)TuplesKt.to((Object)"two-sided-long-edge", (Object)"rotated"), (Object)new PwgFeedTransform(-1, -1)), TuplesKt.to((Object)TuplesKt.to((Object)"two-sided-short-edge", (Object)"flipped"), (Object)new PwgFeedTransform(-1, 1)), TuplesKt.to((Object)TuplesKt.to((Object)"two-sided-short-edge", (Object)"manual-tumble"), (Object)new PwgFeedTransform(-1, -1))};
            transforms = MapsKt.mapOf((Pair[])pairArray);
            default = new PwgFeedTransform(1, 1);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R&\u0010\u0007\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/hp/jipp/pdl/pwg/PwgSettings$PwgFeedTransform$Companion;", "", "()V", "default", "Lcom/hp/jipp/pdl/pwg/PwgSettings$PwgFeedTransform;", "getDefault", "()Lcom/hp/jipp/pdl/pwg/PwgSettings$PwgFeedTransform;", "transforms", "", "Lkotlin/Pair;", "", "lookup", "pageNumber", "", "sides", "sheetBack", "jipp-pdl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PwgFeedTransform getDefault() {
                return default;
            }

            @NotNull
            public final PwgFeedTransform lookup(int pageNumber, @NotNull String sides, @NotNull String sheetBack) {
                Intrinsics.checkNotNullParameter((Object)sides, (String)"sides");
                Intrinsics.checkNotNullParameter((Object)sheetBack, (String)"sheetBack");
                return PdlUtilKt.isEven(pageNumber) ? this.getDefault() : transforms.getOrDefault(TuplesKt.to((Object)sides, (Object)sheetBack), this.getDefault());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

