/*
 * Decompiled with CFR 0.152.
 */
package com.hp.jipp.pdl.pwg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0016\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/hp/jipp/pdl/pwg/PackBits;", "", "bitsPerPixel", "", "pixelsPerLine", "(II)V", "decode", "", "inputBytes", "Ljava/io/InputStream;", "outputPixels", "Ljava/io/OutputStream;", "lines", "decodeLine", "", "bytes", "encode", "inputPixels", "outputBytes", "Companion", "EncodeContext", "jipp-pdl"})
public final class PackBits {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int bitsPerPixel;
    private final int pixelsPerLine;
    private static final int MAX_GROUP = 128;
    private static final int MAX_LINE_REPEAT = 256;
    private static final int NON_REPEAT_SUBTRACT_FROM = 257;

    public PackBits(int bitsPerPixel, int pixelsPerLine) {
        this.bitsPerPixel = bitsPerPixel;
        this.pixelsPerLine = pixelsPerLine;
    }

    public final void encode(@NotNull InputStream inputPixels, @NotNull OutputStream outputBytes) {
        Intrinsics.checkNotNullParameter((Object)inputPixels, (String)"inputPixels");
        Intrinsics.checkNotNullParameter((Object)outputBytes, (String)"outputBytes");
        new EncodeContext(inputPixels, outputBytes, (int)Math.ceil((double)this.bitsPerPixel / (double)8), this.pixelsPerLine).encode();
    }

    public final void decode(@NotNull InputStream inputBytes, @NotNull OutputStream outputPixels, int lines) {
        Intrinsics.checkNotNullParameter((Object)inputBytes, (String)"inputBytes");
        Intrinsics.checkNotNullParameter((Object)outputPixels, (String)"outputPixels");
        int linesWritten = 0;
        while (linesWritten < lines) {
            int lineRepeat = inputBytes.read();
            if (lineRepeat == -1) {
                throw new IOException("Too few lines (read " + linesWritten + ", expected " + lines + ')');
            }
            byte[] line = this.decodeLine(inputBytes, this.pixelsPerLine);
            int n = lineRepeat + 1;
            for (int i = 0; i < n; ++i) {
                ++linesWritten;
                outputPixels.write(line);
            }
        }
        if (linesWritten > lines) {
            throw new IOException("Too many lines (read " + linesWritten + ", expected " + lines + ')');
        }
    }

    private final byte[] decodeLine(InputStream bytes, int pixelsPerLine) {
        ByteArrayOutputStream pixels = new ByteArrayOutputStream();
        byte[] pixel = new byte[(int)Math.ceil((double)this.bitsPerPixel / (double)8)];
        while ((double)pixels.size() < (double)pixelsPerLine * (double)this.bitsPerPixel / (double)8) {
            int i;
            int n;
            int control = bytes.read();
            if (control == -1) {
                throw new IOException("EOF before EOL");
            }
            if (control < 128) {
                bytes.read(pixel);
                n = control + 1;
                for (i = 0; i < n; ++i) {
                    pixels.write(pixel);
                }
                continue;
            }
            n = 257 - control;
            for (i = 0; i < n; ++i) {
                bytes.read(pixel);
                pixels.write(pixel);
            }
        }
        if ((double)pixels.size() > Math.ceil((double)pixelsPerLine * (double)this.bitsPerPixel / (double)8)) {
            throw new IOException("Line too long; " + pixels.size() + " with max " + pixelsPerLine / this.bitsPerPixel * 8);
        }
        byte[] byArray = pixels.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/hp/jipp/pdl/pwg/PackBits$Companion;", "", "()V", "MAX_GROUP", "", "MAX_LINE_REPEAT", "NON_REPEAT_SUBTRACT_FROM", "jipp-pdl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\b\u0010\u001b\u001a\u00020\u000fH\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002J,\u0010\u001e\u001a\u00020\u000f*\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0007H\u0002R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/hp/jipp/pdl/pwg/PackBits$EncodeContext;", "", "pixelsIn", "Ljava/io/InputStream;", "bytesOut", "Ljava/io/OutputStream;", "bytesPerPixel", "", "pixelsPerLine", "(Ljava/io/InputStream;Ljava/io/OutputStream;II)V", "bytePos", "bytesPerLine", "lineArray", "", "lineArrayValid", "", "lineRepeatCount", "nextLineArray", "nextLineArrayValid", "pixelCount", "encode", "", "encodeNonRepeatingPixelGroup", "encodePixelGroups", "encodeRepeatingPixelGroup", "readLine", "into", "readNextLine", "seekMatchingPixels", "seekNonMatchingPixel", "equals", "offset", "length", "other", "otherOffset", "jipp-pdl"})
    private static final class EncodeContext {
        @NotNull
        private final InputStream pixelsIn;
        @NotNull
        private final OutputStream bytesOut;
        private final int bytesPerPixel;
        private final int bytesPerLine;
        private boolean lineArrayValid;
        @NotNull
        private byte[] lineArray;
        private boolean nextLineArrayValid;
        @NotNull
        private byte[] nextLineArray;
        private int lineRepeatCount;
        private int bytePos;
        private int pixelCount;

        public EncodeContext(@NotNull InputStream pixelsIn, @NotNull OutputStream bytesOut, int bytesPerPixel, int pixelsPerLine) {
            Intrinsics.checkNotNullParameter((Object)pixelsIn, (String)"pixelsIn");
            Intrinsics.checkNotNullParameter((Object)bytesOut, (String)"bytesOut");
            this.pixelsIn = pixelsIn;
            this.bytesOut = bytesOut;
            this.bytesPerPixel = bytesPerPixel;
            this.bytesPerLine = this.bytesPerPixel * pixelsPerLine;
            this.lineArray = new byte[this.bytesPerLine];
            this.nextLineArray = new byte[this.bytesPerLine];
        }

        public final void encode() {
            while (this.readNextLine()) {
                this.bytesOut.write(this.lineRepeatCount - 1);
                this.encodePixelGroups();
            }
        }

        private final void encodePixelGroups() {
            this.bytePos = 0;
            while (this.bytePos < this.lineArray.length) {
                if (this.bytePos + this.bytesPerPixel == this.lineArray.length) {
                    this.pixelCount = 1;
                    this.encodeRepeatingPixelGroup();
                    continue;
                }
                if (this.equals(this.lineArray, this.bytePos, this.bytesPerPixel, this.lineArray, this.bytePos + this.bytesPerPixel)) {
                    this.pixelCount = 2;
                    this.seekNonMatchingPixel();
                    this.encodeRepeatingPixelGroup();
                    continue;
                }
                this.pixelCount = 2;
                this.seekMatchingPixels();
                if (this.pixelCount == 1) {
                    this.encodeRepeatingPixelGroup();
                    continue;
                }
                this.encodeNonRepeatingPixelGroup();
            }
        }

        private final void seekNonMatchingPixel() {
            for (int nextPixelIndex = this.bytePos + this.pixelCount * this.bytesPerPixel; this.pixelCount < 128 && nextPixelIndex < this.lineArray.length && this.equals(this.lineArray, this.bytePos, this.bytesPerPixel, this.lineArray, nextPixelIndex); nextPixelIndex += this.bytesPerPixel) {
                int n = this.pixelCount;
                this.pixelCount = n + 1;
            }
        }

        private final void seekMatchingPixels() {
            for (int nextPixelIndex = this.bytePos + this.pixelCount * this.bytesPerPixel; nextPixelIndex < this.lineArray.length && this.pixelCount < 128; nextPixelIndex += this.bytesPerPixel) {
                int n;
                if (this.equals(this.lineArray, nextPixelIndex - this.bytesPerPixel, this.bytesPerPixel, this.lineArray, nextPixelIndex)) {
                    n = this.pixelCount;
                    this.pixelCount = n + -1;
                    break;
                }
                n = this.pixelCount;
                this.pixelCount = n + 1;
            }
        }

        private final void encodeRepeatingPixelGroup() {
            this.bytesOut.write(this.pixelCount - 1);
            this.bytesOut.write(this.lineArray, this.bytePos, this.bytesPerPixel);
            this.bytePos += this.pixelCount * this.bytesPerPixel;
        }

        private final void encodeNonRepeatingPixelGroup() {
            this.bytesOut.write(257 - this.pixelCount);
            this.bytesOut.write(this.lineArray, this.bytePos, this.bytesPerPixel * this.pixelCount);
            this.bytePos += this.pixelCount * this.bytesPerPixel;
        }

        private final boolean equals(byte[] $this$equals, int offset, int length, byte[] other, int otherOffset) {
            for (int index = 0; index < length; ++index) {
                if ($this$equals[offset + index] == other[otherOffset + index]) continue;
                return false;
            }
            return true;
        }

        private final boolean readNextLine() {
            this.lineArrayValid = false;
            if (this.nextLineArrayValid) {
                byte[] swap = this.lineArray;
                this.lineArray = this.nextLineArray;
                this.nextLineArray = swap;
                this.nextLineArrayValid = false;
                this.lineArrayValid = true;
            }
            if (!this.lineArrayValid && !this.readLine(this.lineArray)) {
                return false;
            }
            this.lineRepeatCount = 1;
            while (this.lineRepeatCount <= 256) {
                if (this.readLine(this.nextLineArray)) {
                    if (Arrays.equals(this.lineArray, this.nextLineArray)) {
                        int n = this.lineRepeatCount;
                        this.lineRepeatCount = n + 1;
                        continue;
                    }
                    this.nextLineArrayValid = true;
                    break;
                }
                this.nextLineArrayValid = false;
                break;
            }
            return true;
        }

        private final boolean readLine(byte[] into) {
            boolean bl;
            int bytesRead = this.pixelsIn.read(into);
            if (bytesRead == -1) {
                bl = false;
            } else if (bytesRead == into.length) {
                bl = true;
            } else {
                throw new IOException("Could not read whole line (" + bytesRead + " bytes instead of " + this.lineArray.length);
            }
            return bl;
        }
    }
}

