/*
 * Decompiled with CFR 0.152.
 */
package com.hp.jipp.pdl.pclm;

import com.hp.jipp.pdl.PdlUtilKt;
import com.hp.jipp.pdl.RenderableDocument;
import com.hp.jipp.pdl.RenderablePage;
import com.hp.jipp.pdl.pclm.PclmSettings;
import com.hp.jipp.pdl.pclm.PclmWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\u0018\u0000 12\u00020\u0001:\u0003123B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0016J2\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0015H\u0002J+\u0010\u001e\u001a\u00020\t2\b\b\u0002\u0010\u001f\u001a\u00020\t2\u0017\u0010 \u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00110!\u00a2\u0006\u0002\b#H\u0002J\b\u0010$\u001a\u00020\u0011H\u0002J\u000e\u0010%\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\tH\u0016J\u0018\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J&\u0010,\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00190.2\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u0014\u0010/\u001a\u00020\u0017*\u00020\u00172\u0006\u00100\u001a\u00020\tH\u0002R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/hp/jipp/pdl/pclm/PclmWriter;", "Ljava/io/Writer;", "outputStream", "Ljava/io/OutputStream;", "settings", "Lcom/hp/jipp/pdl/pclm/PclmSettings;", "(Ljava/io/OutputStream;Lcom/hp/jipp/pdl/pclm/PclmSettings;)V", "crossReferences", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "pageObjectNumbers", "written", "calculateJobPagesPerSet", "document", "Lcom/hp/jipp/pdl/RenderableDocument;", "close", "", "endDoc", "flush", "getBytes", "", "page", "Lcom/hp/jipp/pdl/RenderablePage;", "swath", "Lcom/hp/jipp/pdl/pclm/PclmWriter$Swath;", "forceNonBlank", "", "widthPixels", "bytes", "pdObject", "objectNumber", "block", "Lkotlin/Function1;", "Lcom/hp/jipp/pdl/pclm/PclmWriter$InObject;", "Lkotlin/ExtensionFunctionType;", "startDoc", "write", "chars", "", "offset", "length", "writePage", "doc", "writeSwaths", "swaths", "", "transform", "number", "Companion", "InObject", "Swath", "jipp-pdl"})
@SourceDebugExtension(value={"SMAP\nPclmWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PclmWriter.kt\ncom/hp/jipp/pdl/pclm/PclmWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,336:1\n1855#2,2:337\n1549#2:339\n1620#2,2:340\n1622#2:343\n1#3:342\n1290#4,2:344\n*S KotlinDebug\n*F\n+ 1 PclmWriter.kt\ncom/hp/jipp/pdl/pclm/PclmWriter\n*L\n79#1:337,2\n115#1:339\n115#1:340,2\n115#1:343\n245#1:344,2\n*E\n"})
public final class PclmWriter
extends Writer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final OutputStream outputStream;
    @NotNull
    private final PclmSettings settings;
    private int written;
    @NotNull
    private final ArrayList<Integer> pageObjectNumbers;
    @NotNull
    private final ArrayList<Integer> crossReferences;
    private static final byte BLANK = -1;
    private static final int POINTS_PER_INCH = 72;
    private static final int CATALOG_OBJECT_NUMBER = 1;
    private static final int PAGE_TREE_OBJECT_NUMBER = 2;

    public PclmWriter(@NotNull OutputStream outputStream, @NotNull PclmSettings settings) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.outputStream = outputStream;
        this.settings = settings;
        this.pageObjectNumbers = new ArrayList();
        this.crossReferences = new ArrayList();
    }

    @Override
    public void flush() {
        this.outputStream.flush();
    }

    @Override
    public void close() {
        this.outputStream.close();
    }

    @Override
    public void write(@NotNull char[] chars, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        this.written += length;
        String string = new String(chars);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.outputStream.write(byArray, offset, length);
    }

    public final int calculateJobPagesPerSet(@NotNull RenderableDocument document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        int pageCount = CollectionsKt.count((Iterable)document);
        return !Intrinsics.areEqual((Object)this.settings.getOutput().getSides(), (Object)"one-sided") && PdlUtilKt.isOdd(pageCount) ? pageCount + 1 : pageCount;
    }

    public final void write(@NotNull RenderableDocument document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.crossReferences.add(-1);
        this.crossReferences.add(-1);
        this.crossReferences.add(-1);
        this.startDoc();
        Iterable $this$forEach$iv = document.mapPages((Function1<? super RenderableDocument, ? extends Iterable<? extends RenderablePage>>)((Function1)new Function1<RenderableDocument, Iterable<? extends RenderablePage>>(this){
            final /* synthetic */ PclmWriter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Iterable<RenderablePage> invoke(@NotNull RenderableDocument doc) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
                Iterable iterable = doc;
                PclmWriter pclmWriter = this.this$0;
                boolean $i$f$mapIndexed = false;
                void var5_5 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void pageNumber;
                    void page;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    RenderablePage renderablePage = (RenderablePage)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(PclmWriter.access$transform(pclmWriter, (RenderablePage)page, (int)pageNumber));
                }
                return (List)destination$iv$iv;
            }
        })).handleSides(this.settings.getOutput(), true);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RenderablePage page = (RenderablePage)element$iv;
            boolean bl = false;
            this.writePage(document, page);
        }
        this.endDoc();
        this.flush();
    }

    private final RenderablePage transform(RenderablePage $this$transform, int number) {
        return PdlUtilKt.isEven(number) ? $this$transform : (Intrinsics.areEqual((Object)this.settings.getOutput().getSides(), (Object)"two-sided-long-edge") && Intrinsics.areEqual((Object)this.settings.getBackSide(), (Object)"rotated") ? $this$transform.rotated() : (Intrinsics.areEqual((Object)this.settings.getOutput().getSides(), (Object)"two-sided-long-edge") && Intrinsics.areEqual((Object)this.settings.getBackSide(), (Object)"flipped") ? $this$transform.flipY() : (Intrinsics.areEqual((Object)this.settings.getOutput().getSides(), (Object)"two-sided-short-edge") && Intrinsics.areEqual((Object)this.settings.getBackSide(), (Object)"flipped") ? $this$transform.flipX() : $this$transform)));
    }

    private final void startDoc() {
        this.write("%PDF-1.7\n");
        this.write("%PCLm 1.0\n");
    }

    /*
     * WARNING - void declaration
     */
    private final void writePage(RenderableDocument doc, RenderablePage page) {
        void $this$mapTo$iv$iv;
        int stripCount = MathKt.roundToInt((double)Math.ceil((double)page.getHeightPixels() / (double)this.settings.getStripHeight()));
        int yOffset = 0;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)stripCount);
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int n;
            void index;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int height = index == stripCount - 1 ? page.getHeightPixels() - (stripCount - 1) * this.settings.getStripHeight() : this.settings.getStripHeight();
            int n3 = n = yOffset;
            int n4 = height;
            void var19_19 = index;
            int n5 = this.crossReferences.size() + 2 + index * 2;
            boolean bl2 = false;
            yOffset += height;
            Unit unit = Unit.INSTANCE;
            int n6 = n;
            int n7 = n4;
            void var26_26 = var19_19;
            int n8 = n5;
            collection.add(new Swath(n8, (int)var26_26, n7, n6));
        }
        List swaths = (List)destination$iv$iv;
        int pageObjectNumber2 = PclmWriter.pdObject$default(this, 0, (Function1)new Function1<InObject, Unit>(this, (List<Swath>)swaths, page, doc){
            final /* synthetic */ PclmWriter this$0;
            final /* synthetic */ List<Swath> $swaths;
            final /* synthetic */ RenderablePage $page;
            final /* synthetic */ RenderableDocument $doc;
            {
                this.this$0 = $receiver;
                this.$swaths = $swaths;
                this.$page = $page;
                this.$doc = $doc;
                super(1);
            }

            public final void invoke(@NotNull InObject $this$pdObject) {
                Intrinsics.checkNotNullParameter((Object)$this$pdObject, (String)"$this$pdObject");
                this.this$0.write("/Type /Page\n");
                this.this$0.write("/Parent 2 0 R\n");
                this.this$0.write("/Resources <<\n");
                this.this$0.write("/XObject <<\n");
                for (Swath swath : this.$swaths) {
                    this.this$0.write("/Image" + swath.getImageNumber() + ' ' + swath.getObjectNumber() + " 0 R\n");
                }
                this.this$0.write(">>\n");
                this.this$0.write(">>\n");
                int heightPoints = this.$page.getHeightPixels() * 72 / this.$doc.getDpi();
                int widthPoints = this.$page.getWidthPixels() * 72 / this.$doc.getDpi();
                this.this$0.write("/MediaBox [ 0 0 " + widthPoints + ' ' + heightPoints + " ]\n");
                this.this$0.write("/Contents [ " + ($this$pdObject.getObjectNumber() + 1) + " 0 R ]\n");
            }
        }, 1, null);
        object = pageObjectNumber2;
        ((Collection)this.pageObjectNumbers).add(object);
        PclmWriter.pdObject$default(this, 0, (Function1)new Function1<InObject, Unit>(doc, (List<Swath>)swaths, page, this){
            final /* synthetic */ RenderableDocument $doc;
            final /* synthetic */ List<Swath> $swaths;
            final /* synthetic */ RenderablePage $page;
            final /* synthetic */ PclmWriter this$0;
            {
                this.$doc = $doc;
                this.$swaths = $swaths;
                this.$page = $page;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull InObject $this$pdObject) {
                Intrinsics.checkNotNullParameter((Object)$this$pdObject, (String)"$this$pdObject");
                CharArrayWriter contentStream = new CharArrayWriter();
                contentStream.write((double)72 / (double)this.$doc.getDpi() + " 0 0 " + (double)72 / (double)this.$doc.getDpi() + " 0 0 cm\n");
                contentStream.write("/P <</MCID 0>> BDC q\n");
                for (Swath swath : this.$swaths) {
                    int pageYOffset = this.$page.getHeightPixels() - swath.getYOffset() - swath.getHeight();
                    contentStream.write(this.$page.getWidthPixels() + " 0 0 " + swath.getHeight() + " 0 " + pageYOffset + " cm\n");
                    contentStream.write("/Image" + swath.getImageNumber() + " Do Q\n");
                    contentStream.write("/P <</MCID 0>> BDC q\n");
                }
                $this$pdObject.setCharStream(contentStream.toCharArray());
                this.this$0.write("/Length " + contentStream.size() + '\n');
            }
        }, 1, null);
        this.writeSwaths(page, swaths, page.getWidthPixels());
    }

    private final void writeSwaths(RenderablePage page, List<Swath> swaths, int widthPixels) {
        Ref.BooleanRef first = new Ref.BooleanRef();
        first.element = true;
        for (Swath swath : swaths) {
            Ref.ObjectRef rawBytes = new Ref.ObjectRef();
            PclmWriter.pdObject$default(this, 0, (Function1)new Function1<InObject, Unit>(this, page, swath, first, widthPixels, (Ref.ObjectRef<byte[]>)rawBytes){
                final /* synthetic */ PclmWriter this$0;
                final /* synthetic */ RenderablePage $page;
                final /* synthetic */ Swath $swath;
                final /* synthetic */ Ref.BooleanRef $first;
                final /* synthetic */ int $widthPixels;
                final /* synthetic */ Ref.ObjectRef<byte[]> $rawBytes;
                {
                    this.this$0 = $receiver;
                    this.$page = $page;
                    this.$swath = $swath;
                    this.$first = $first;
                    this.$widthPixels = $widthPixels;
                    this.$rawBytes = $rawBytes;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull InObject $this$pdObject) {
                    byte[] byArray;
                    Intrinsics.checkNotNullParameter((Object)$this$pdObject, (String)"$this$pdObject");
                    byte[] curBytes = PclmWriter.access$getBytes(this.this$0, this.$page, this.$swath, this.$first.element, this.$widthPixels, (byte[])this.$rawBytes.element);
                    this.$rawBytes.element = curBytes;
                    InObject inObject = $this$pdObject;
                    if (!(curBytes.length == 0)) {
                        ByteArrayOutputStream encoded = new ByteArrayOutputStream();
                        Closeable closeable = new DeflaterOutputStream(encoded);
                        Ref.ObjectRef<byte[]> objectRef = this.$rawBytes;
                        InObject inObject2 = inObject;
                        Throwable throwable = null;
                        try {
                            DeflaterOutputStream it = (DeflaterOutputStream)closeable;
                            boolean bl = false;
                            it.write((byte[])objectRef.element);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        inObject = inObject2;
                        byArray = encoded.toByteArray();
                    } else {
                        byArray = (byte[])this.$rawBytes.element;
                    }
                    inObject.setByteStream(byArray);
                    this.this$0.write("/Width " + this.$widthPixels + '\n');
                    switch (writeSwaths.WhenMappings.$EnumSwitchMapping$0[PclmWriter.access$getSettings$p(this.this$0).getOutput().getColorSpace().ordinal()]) {
                        case 1: {
                            this.this$0.write("/ColorSpace /DeviceRGB\n");
                            break;
                        }
                        case 2: {
                            this.this$0.write("/ColorSpace /DeviceGray\n");
                            break;
                        }
                        default: {
                            throw new IOException((Object)((Object)PclmWriter.access$getSettings$p(this.this$0).getOutput().getColorSpace()) + " not supported");
                        }
                    }
                    this.this$0.write("/Height " + this.$swath.getHeight() + '\n');
                    this.this$0.write("/Filter /FlateDecode\n");
                    this.this$0.write("/Subtype /Image\n");
                    StringBuilder stringBuilder = new StringBuilder().append("/Length ");
                    byte[] byArray2 = $this$pdObject.getByteStream();
                    Intrinsics.checkNotNull((Object)byArray2);
                    this.this$0.write(stringBuilder.append(byArray2.length).append('\n').toString());
                    this.this$0.write("/Type /XObject\n");
                    this.this$0.write("/BitsPerComponent 8\n");
                    if (curBytes.length == 0 && !this.$first.element) {
                        this.this$0.write("/Name /WhiteStrip\n");
                    } else {
                        this.this$0.write("/Name /ColorStrip\n");
                    }
                }
            }, 1, null);
            PclmWriter.pdObject$default(this, 0, (Function1)new Function1<InObject, Unit>(this){
                final /* synthetic */ PclmWriter this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull InObject $this$pdObject) {
                    Intrinsics.checkNotNullParameter((Object)$this$pdObject, (String)"$this$pdObject");
                    String string = "q /Image Do Q\n";
                    byte[] byArray = string.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    $this$pdObject.setByteStream(byArray);
                    StringBuilder stringBuilder = new StringBuilder().append("/Length ");
                    byte[] byArray2 = $this$pdObject.getByteStream();
                    Intrinsics.checkNotNull((Object)byArray2);
                    this.this$0.write(stringBuilder.append(byArray2.length).append('\n').toString());
                }
            }, 1, null);
            this.flush();
            first.element = false;
        }
    }

    private final byte[] getBytes(RenderablePage page, Swath swath, boolean forceNonBlank, int widthPixels, byte[] bytes) {
        Byte by;
        byte[] renderBytes;
        block3: {
            renderBytes = bytes;
            int size = swath.getHeight() * widthPixels * this.settings.getOutput().getColorSpace().getBytesPerPixel();
            if (!(renderBytes != null ? renderBytes.length == size : false)) {
                renderBytes = new byte[size];
            }
            page.render(swath.getYOffset(), swath.getHeight(), this.settings.getOutput().getColorSpace(), renderBytes);
            if (forceNonBlank) {
                return renderBytes;
            }
            byte blank2 = -1;
            byte[] $this$firstOrNull$iv = renderBytes;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                byte element$iv;
                byte it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!(it != blank2)) continue;
                by = element$iv;
                break block3;
            }
            by = null;
        }
        return by == null ? new byte[]{} : renderBytes;
    }

    private final void endDoc() {
        this.pdObject(1, (Function1<? super InObject, Unit>)((Function1)new Function1<InObject, Unit>(this){
            final /* synthetic */ PclmWriter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull InObject $this$pdObject) {
                Intrinsics.checkNotNullParameter((Object)$this$pdObject, (String)"$this$pdObject");
                this.this$0.write("/Type /Catalog\n");
                this.this$0.write("/Pages " + ($this$pdObject.getObjectNumber() + 1) + " 0 R\n");
            }
        }));
        this.pdObject(2, (Function1<? super InObject, Unit>)((Function1)new Function1<InObject, Unit>(this){
            final /* synthetic */ PclmWriter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull InObject $this$pdObject) {
                Intrinsics.checkNotNullParameter((Object)$this$pdObject, (String)"$this$pdObject");
                this.this$0.write("/Count " + PclmWriter.access$getPageObjectNumbers$p(this.this$0).size() + '\n');
                this.this$0.write("/Kids [ ");
                int n = PclmWriter.access$getPageObjectNumbers$p(this.this$0).size();
                for (int i = 0; i < n; ++i) {
                    this.this$0.write(((Number)PclmWriter.access$getPageObjectNumbers$p(this.this$0).get(i)).intValue() + " 0 R ");
                }
                this.this$0.write("]\n");
                this.this$0.write("/Type /Pages\n");
            }
        }));
        int xrefOffset = this.written;
        this.write("xref\n");
        this.write("1 " + (this.crossReferences.size() - 1) + '\n');
        Iterator iterator = CollectionsKt.drop((Iterable)this.crossReferences, (int)1).iterator();
        while (iterator.hasNext()) {
            int offset = ((Number)iterator.next()).intValue();
            String string = "%010d 00000 n \n";
            Object[] objectArray = new Object[]{offset};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            this.write(string2);
        }
        this.write("trailer\n");
        this.write("<<\n");
        this.write("/Size " + (this.crossReferences.size() - 1) + '\n');
        this.write("/Root 1 0 R\n");
        this.write(">>\n");
        this.write("startxref\n");
        this.write("" + xrefOffset + '\n');
        this.write("%%EOF\n");
    }

    private final int pdObject(int objectNumber, Function1<? super InObject, Unit> block) {
        InObject context = new InObject(objectNumber);
        if (objectNumber < this.crossReferences.size()) {
            this.crossReferences.set(objectNumber, this.written);
        } else if (objectNumber == this.crossReferences.size()) {
            ((Collection)this.crossReferences).add(this.written);
        } else {
            throw new IOException("Cannot create object beyond last position");
        }
        this.write(context.getObjectNumber() + " 0 obj\n");
        this.write("<<\n");
        block.invoke((Object)context);
        this.write(">>\n");
        if (context.getByteStream() != null) {
            this.write("stream\n");
            this.flush();
            byte[] byArray = context.getByteStream();
            Intrinsics.checkNotNull((Object)byArray);
            this.outputStream.write(byArray);
            byte[] byArray2 = context.getByteStream();
            Intrinsics.checkNotNull((Object)byArray2);
            this.written += byArray2.length;
            this.write("\nendstream\n");
        } else if (context.getCharStream() != null) {
            this.write("stream\n");
            this.flush();
            char[] cArray = context.getCharStream();
            Intrinsics.checkNotNull((Object)cArray);
            this.write(cArray);
            this.write("\nendstream\n");
        }
        this.write("endobj\n");
        return objectNumber;
    }

    static /* synthetic */ int pdObject$default(PclmWriter pclmWriter, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = pclmWriter.crossReferences.size();
        }
        return pclmWriter.pdObject(n, (Function1<? super InObject, Unit>)function1);
    }

    public static final /* synthetic */ RenderablePage access$transform(PclmWriter $this, RenderablePage $receiver, int number) {
        return $this.transform($receiver, number);
    }

    public static final /* synthetic */ byte[] access$getBytes(PclmWriter $this, RenderablePage page, Swath swath, boolean forceNonBlank, int widthPixels, byte[] bytes) {
        return $this.getBytes(page, swath, forceNonBlank, widthPixels, bytes);
    }

    public static final /* synthetic */ PclmSettings access$getSettings$p(PclmWriter $this) {
        return $this.settings;
    }

    public static final /* synthetic */ ArrayList access$getPageObjectNumbers$p(PclmWriter $this) {
        return $this.pageObjectNumbers;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/hp/jipp/pdl/pclm/PclmWriter$Companion;", "", "()V", "BLANK", "", "CATALOG_OBJECT_NUMBER", "", "PAGE_TREE_OBJECT_NUMBER", "POINTS_PER_INCH", "jipp-pdl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/hp/jipp/pdl/pclm/PclmWriter$InObject;", "", "objectNumber", "", "(I)V", "byteStream", "", "getByteStream", "()[B", "setByteStream", "([B)V", "charStream", "", "getCharStream", "()[C", "setCharStream", "([C)V", "getObjectNumber", "()I", "jipp-pdl"})
    private static final class InObject {
        private final int objectNumber;
        @Nullable
        private byte[] byteStream;
        @Nullable
        private char[] charStream;

        public InObject(int objectNumber) {
            this.objectNumber = objectNumber;
        }

        public final int getObjectNumber() {
            return this.objectNumber;
        }

        @Nullable
        public final byte[] getByteStream() {
            return this.byteStream;
        }

        public final void setByteStream(@Nullable byte[] byArray) {
            this.byteStream = byArray;
        }

        @Nullable
        public final char[] getCharStream() {
            return this.charStream;
        }

        public final void setCharStream(@Nullable char[] cArray) {
            this.charStream = cArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/hp/jipp/pdl/pclm/PclmWriter$Swath;", "", "objectNumber", "", "imageNumber", "height", "yOffset", "(IIII)V", "getHeight", "()I", "getImageNumber", "getObjectNumber", "getYOffset", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "jipp-pdl"})
    private static final class Swath {
        private final int objectNumber;
        private final int imageNumber;
        private final int height;
        private final int yOffset;

        public Swath(int objectNumber, int imageNumber, int height, int yOffset) {
            this.objectNumber = objectNumber;
            this.imageNumber = imageNumber;
            this.height = height;
            this.yOffset = yOffset;
        }

        public final int getObjectNumber() {
            return this.objectNumber;
        }

        public final int getImageNumber() {
            return this.imageNumber;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int getYOffset() {
            return this.yOffset;
        }

        public final int component1() {
            return this.objectNumber;
        }

        public final int component2() {
            return this.imageNumber;
        }

        public final int component3() {
            return this.height;
        }

        public final int component4() {
            return this.yOffset;
        }

        @NotNull
        public final Swath copy(int objectNumber, int imageNumber, int height, int yOffset) {
            return new Swath(objectNumber, imageNumber, height, yOffset);
        }

        public static /* synthetic */ Swath copy$default(Swath swath, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = swath.objectNumber;
            }
            if ((n5 & 2) != 0) {
                n2 = swath.imageNumber;
            }
            if ((n5 & 4) != 0) {
                n3 = swath.height;
            }
            if ((n5 & 8) != 0) {
                n4 = swath.yOffset;
            }
            return swath.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Swath(objectNumber=" + this.objectNumber + ", imageNumber=" + this.imageNumber + ", height=" + this.height + ", yOffset=" + this.yOffset + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.objectNumber);
            result = result * 31 + Integer.hashCode(this.imageNumber);
            result = result * 31 + Integer.hashCode(this.height);
            result = result * 31 + Integer.hashCode(this.yOffset);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Swath)) {
                return false;
            }
            Swath swath = (Swath)other;
            if (this.objectNumber != swath.objectNumber) {
                return false;
            }
            if (this.imageNumber != swath.imageNumber) {
                return false;
            }
            if (this.height != swath.height) {
                return false;
            }
            return this.yOffset == swath.yOffset;
        }
    }
}

