/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.commons.annotation.Nonempty;
import com.helger.css.ECSSVersion;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.ParserCSS30TreeConstants;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ECSSNodeType {
    ROOT(2),
    CHARSET(15),
    UNKNOWNRULE(64),
    UNKNOWNRULEPARAMETERLIST(62),
    UNKNOWNRULEBODY(63),
    STYLERULE(39),
    IMPORTRULE(16),
    PAGERULE(50),
    MEDIARULE(46),
    FONTFACERULE(51),
    SELECTOR(34),
    STYLEDECLARATIONLIST(38),
    STYLEDECLARATION(37),
    NAMESPACEPREFIX(20),
    ELEMENTNAME(21),
    HASH(22),
    CLASS(23),
    PSEUDO(31),
    HOST(28),
    HOSTCONTEXT(29),
    SLOTTED(30),
    NEGATION(32),
    ATTRIB(26),
    ATTRIBOPERATOR(24),
    ATTRIBVALUE(25),
    SELECTORCOMBINATOR(33),
    NTH(27),
    PROPERTY(35),
    IMPORTANT(36),
    EXPR(14),
    EXPRTERM(12),
    EXPROPERATOR(13),
    URL(3),
    FUNCTION(4),
    CALC(9),
    CALCSUMOPERATOR(8),
    CALCPRODUCT(7),
    CALCPRODUCTOPERATOR(6),
    CALCUNIT(5),
    LINE_NAMES(11),
    LINE_NAME(10),
    MEDIALIST(45),
    MEDIUM(41),
    MEDIAQUERY(44),
    MEDIAMODIFIER(40),
    MEDIAEXPR(43),
    MEDIAFEATURE(42),
    PSEUDOPAGE(-1),
    PAGESELECTOR(47),
    PAGEMARGINSYMBOL(48),
    PAGERULEBLOCK(49),
    KEYFRAMESRULE(55),
    KEYFRAMESIDENTIFIER(52),
    KEYFRAMESSELECTOR(54),
    SINGLEKEYFRAMESELECTOR(53),
    VIEWPORTRULE(56),
    NAMESPACERULE(19),
    NAMESPACERULEPREFIX(17),
    NAMESPACERULEURL(18),
    SUPPORTSRULE(61),
    SUPPORTSCONDITION(60),
    SUPPORTSCONDITIONOPERATOR(59),
    SUPPORTSNEGATION(58),
    SUPPORTSCONDITIONINPARENS(57),
    ERROR_SKIPTO(1);

    private static final Logger LOGGER;
    private final int m_nParserType30;

    private ECSSNodeType(int n2) {
        this.m_nParserType30 = n2;
    }

    int getParserNodeType(@Nonnull ECSSVersion eCSSVersion) {
        switch (eCSSVersion) {
            case CSS30: {
                return this.m_nParserType30;
            }
        }
        throw new IllegalStateException("Illegal version provided: " + (Object)((Object)eCSSVersion));
    }

    public boolean isNode(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        return cSSNode.getNodeType() == this.getParserNodeType(eCSSVersion);
    }

    @Nonnull
    String getNodeName(@Nonnull ECSSVersion eCSSVersion) {
        switch (eCSSVersion) {
            case CSS30: {
                return ParserCSS30TreeConstants.jjtNodeName[this.m_nParserType30];
            }
        }
        throw new IllegalStateException("Illegal version provided: " + (Object)((Object)eCSSVersion));
    }

    @Nullable
    static ECSSNodeType getNodeType(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        for (ECSSNodeType eCSSNodeType : ECSSNodeType.values()) {
            if (!eCSSNodeType.isNode(cSSNode, eCSSVersion)) continue;
            return eCSSNodeType;
        }
        return null;
    }

    @Nullable
    static String getNodeName(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        ECSSNodeType eCSSNodeType = ECSSNodeType.getNodeType(cSSNode, eCSSVersion);
        if (eCSSNodeType != null) {
            return eCSSNodeType.getNodeName(eCSSVersion);
        }
        LOGGER.warn("Unsupported node type " + cSSNode.getNodeType() + " in version " + (Object)((Object)eCSSVersion));
        return null;
    }

    private static void _dumpRecursive(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion, @Nonnull StringBuilder stringBuilder, @Nonnull String string) {
        stringBuilder.append(string).append(ECSSNodeType.getNodeName(cSSNode, eCSSVersion));
        if (cSSNode.hasText()) {
            stringBuilder.append('[').append(cSSNode.getText()).append(']');
        }
        stringBuilder.append('\n');
        Iterator<CSSNode> iterator = cSSNode.iterator();
        while (iterator.hasNext()) {
            CSSNode cSSNode2 = iterator.next();
            ECSSNodeType._dumpRecursive(cSSNode2, eCSSVersion, stringBuilder, string + "  ");
        }
    }

    @Nonnull
    @Nonempty
    public static String getDump(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        StringBuilder stringBuilder = new StringBuilder();
        ECSSNodeType._dumpRecursive(cSSNode, eCSSVersion, stringBuilder, "");
        return stringBuilder.toString();
    }

    public static boolean isErrorNode(@Nonnull CSSNode cSSNode, @Nonnull ECSSVersion eCSSVersion) {
        return ERROR_SKIPTO.isNode(cSSNode, eCSSVersion);
    }

    static {
        LOGGER = LoggerFactory.getLogger(ECSSNodeType.class);
    }
}

