/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.util;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JCHashCodeCalculator {
    public static final int MULTIPLIER = 31;
    public static final int HASHCODE_NULL = 129;
    private static final JCHashCodeCalculator s_aInstance = new JCHashCodeCalculator();

    private JCHashCodeCalculator() {
    }

    public static int append(int n, boolean bl) {
        return JCHashCodeCalculator.append(n, bl ? 1231 : 1237);
    }

    public static int append(int n, byte by) {
        return JCHashCodeCalculator.append(n, (int)by);
    }

    public static int append(int n, char c) {
        return JCHashCodeCalculator.append(n, (int)c);
    }

    public static int append(int n, double d) {
        return JCHashCodeCalculator.append(n, d == 0.0 ? 0L : Double.doubleToLongBits(d));
    }

    public static int append(int n, float f) {
        return JCHashCodeCalculator.append(n, f == 0.0f ? 0 : Float.floatToIntBits(f));
    }

    public static int append(int n, int n2) {
        return n * 31 + n2;
    }

    public static int append(int n, long l) {
        int n2 = JCHashCodeCalculator.append(n, (int)(l >>> 32));
        return JCHashCodeCalculator.append(n2, (int)(l & 0xFFFFFFFFL));
    }

    public static int append(int n, short s) {
        return JCHashCodeCalculator.append(n, (int)s);
    }

    public static int append(int n, @Nullable Object object) {
        return JCHashCodeCalculator.append(n, object == null ? 129 : object.hashCode());
    }
}

