/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.meta;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JTypeWildcard;
import com.helger.jcodemodel.meta.CodeModelBuildingException;
import com.helger.jcodemodel.meta.DecidedErrorTypesModelsAdapter;
import com.helger.jcodemodel.meta.ErrorTypeFound;
import com.helger.jcodemodel.meta.ErrorTypePolicy;
import com.helger.jcodemodel.meta.RuntimeCodeModelBuildingException;
import com.helger.jcodemodel.meta.RuntimeErrorTypeFound;
import com.helger.jcodemodel.meta.TypeEnvironment;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor6;

class TypeMirrorToJTypeVisitor
extends AbstractTypeVisitor6<AbstractJType, Void> {
    private final ErrorTypePolicy _errorTypePolicy;
    private final TypeEnvironment _environment;
    private final JCodeModel _codeModel;
    private final DecidedErrorTypesModelsAdapter _modelsAdapter;

    public TypeMirrorToJTypeVisitor(JCodeModel jCodeModel, DecidedErrorTypesModelsAdapter decidedErrorTypesModelsAdapter, ErrorTypePolicy errorTypePolicy, TypeEnvironment typeEnvironment) {
        this._codeModel = jCodeModel;
        this._modelsAdapter = decidedErrorTypesModelsAdapter;
        this._errorTypePolicy = errorTypePolicy;
        this._environment = typeEnvironment;
    }

    @Override
    public AbstractJType visitPrimitive(PrimitiveType primitiveType, Void void_) {
        switch (primitiveType.getKind()) {
            case BOOLEAN: {
                return this._codeModel.BOOLEAN;
            }
            case BYTE: {
                return this._codeModel.BYTE;
            }
            case CHAR: {
                return this._codeModel.CHAR;
            }
            case INT: {
                return this._codeModel.INT;
            }
            case LONG: {
                return this._codeModel.LONG;
            }
            case FLOAT: {
                return this._codeModel.FLOAT;
            }
            case DOUBLE: {
                return this._codeModel.DOUBLE;
            }
            case SHORT: {
                return this._codeModel.SHORT;
            }
        }
        throw new IllegalArgumentException("Unrecognized primitive " + (Object)((Object)primitiveType.getKind()));
    }

    @Override
    public AbstractJType visitNull(NullType nullType, Void void_) {
        throw new IllegalArgumentException("null can't be JClass.");
    }

    @Override
    public AbstractJType visitArray(ArrayType arrayType, Void void_) {
        try {
            AbstractJType abstractJType = this._modelsAdapter.toJType(arrayType.getComponentType(), this._environment);
            return abstractJType.array();
        }
        catch (CodeModelBuildingException codeModelBuildingException) {
            throw new RuntimeCodeModelBuildingException(codeModelBuildingException);
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeErrorTypeFound(errorTypeFound);
        }
    }

    @Override
    public AbstractJType visitDeclared(DeclaredType declaredType, Void void_) {
        try {
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            AbstractJClass abstractJClass = this._modelsAdapter.ref(typeElement);
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                abstractJClass = abstractJClass.narrow(this._modelsAdapter.toJType(typeMirror, this._environment));
            }
            return abstractJClass;
        }
        catch (CodeModelBuildingException codeModelBuildingException) {
            throw new RuntimeCodeModelBuildingException(codeModelBuildingException);
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeErrorTypeFound(errorTypeFound);
        }
    }

    @Override
    public AbstractJType visitError(ErrorType errorType, Void void_) {
        String string = errorType.asElement().getSimpleName().toString();
        String string2 = this._environment.packageName() + "." + string;
        JDefinedClass jDefinedClass = this._codeModel._getClass(string2);
        if (jDefinedClass != null) {
            List<? extends TypeMirror> list = errorType.getTypeArguments();
            if (list.isEmpty()) {
                return jDefinedClass;
            }
            ArrayList<AbstractJClass> arrayList = new ArrayList<AbstractJClass>(list.size());
            for (TypeMirror typeMirror : list) {
                try {
                    arrayList.add((AbstractJClass)this._modelsAdapter.toJType(typeMirror, this._environment));
                }
                catch (CodeModelBuildingException codeModelBuildingException) {
                    throw new RuntimeCodeModelBuildingException(codeModelBuildingException);
                }
                catch (ErrorTypeFound errorTypeFound) {
                    throw new RuntimeErrorTypeFound(errorTypeFound);
                }
            }
            return jDefinedClass.narrow(arrayList);
        }
        if (this._errorTypePolicy.action() == ErrorTypePolicy.EAction.CREATE_ERROR_TYPE) {
            return this._codeModel.errorClass(string + " in annotated source code", string.equals("<any>") ? null : string);
        }
        try {
            throw new ErrorTypeFound(string + " in annotated source code");
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeErrorTypeFound(errorTypeFound);
        }
    }

    @Override
    public AbstractJType visitTypeVariable(TypeVariable typeVariable, Void void_) {
        String string = typeVariable.asElement().getSimpleName().toString();
        AbstractJType abstractJType = this._environment.get(string);
        if (abstractJType != null) {
            return abstractJType;
        }
        if (this._errorTypePolicy.action() == ErrorTypePolicy.EAction.CREATE_ERROR_TYPE) {
            return this._codeModel.errorClass("Missing type-variable " + string + " in annotated source code");
        }
        try {
            throw new ErrorTypeFound("Missing type-variable " + string + " in annotated source code");
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeErrorTypeFound(errorTypeFound);
        }
    }

    @Override
    public AbstractJType visitWildcard(WildcardType wildcardType, Void void_) {
        try {
            TypeMirror typeMirror = wildcardType.getExtendsBound();
            if (typeMirror != null) {
                AbstractJClass abstractJClass = (AbstractJClass)this._modelsAdapter.toJType(typeMirror, this._environment);
                return abstractJClass.wildcard(JTypeWildcard.EBoundMode.EXTENDS);
            }
            TypeMirror typeMirror2 = wildcardType.getSuperBound();
            if (typeMirror2 != null) {
                AbstractJClass abstractJClass = (AbstractJClass)this._modelsAdapter.toJType(typeMirror2, this._environment);
                return abstractJClass.wildcard(JTypeWildcard.EBoundMode.SUPER);
            }
            return this._codeModel.wildcard();
        }
        catch (CodeModelBuildingException codeModelBuildingException) {
            throw new RuntimeCodeModelBuildingException(codeModelBuildingException);
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeErrorTypeFound(errorTypeFound);
        }
    }

    @Override
    public AbstractJType visitExecutable(ExecutableType executableType, Void void_) {
        throw new IllegalArgumentException("executable can't be JClass.");
    }

    @Override
    public AbstractJType visitNoType(NoType noType, Void void_) {
        if (this._errorTypePolicy.action() == ErrorTypePolicy.EAction.CREATE_ERROR_TYPE) {
            return this._codeModel.errorClass("'no type' in annotated source code");
        }
        try {
            throw new ErrorTypeFound("'no type' in annotated source code");
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeErrorTypeFound(errorTypeFound);
        }
    }

    @Override
    public AbstractJType visitUnknown(TypeMirror typeMirror, Void void_) {
        if (this._errorTypePolicy.action() == ErrorTypePolicy.EAction.CREATE_ERROR_TYPE) {
            return this._codeModel.errorClass("'unknown type' in annotated source code");
        }
        try {
            throw new ErrorTypeFound("'unknown type' in annotated source code");
        }
        catch (ErrorTypeFound errorTypeFound) {
            throw new RuntimeErrorTypeFound(errorTypeFound);
        }
    }
}

