/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.meta;

import com.helger.jcodemodel.AbstractJType;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class TypeEnvironment {
    private final Map<String, AbstractJType> map = new TreeMap<String, AbstractJType>();
    private final TypeEnvironment _parent;
    private final String _packageName;

    TypeEnvironment(String string) {
        this._parent = null;
        this._packageName = string;
    }

    private TypeEnvironment(TypeEnvironment typeEnvironment) {
        this._packageName = null;
        this._parent = typeEnvironment;
    }

    @Nonnull
    public TypeEnvironment enclosed() {
        return new TypeEnvironment(this);
    }

    @Nullable
    public AbstractJType get(@Nonnull String string) {
        AbstractJType abstractJType = this.map.get(string);
        if (abstractJType != null || this._parent == null) {
            return abstractJType;
        }
        return this._parent.get(string);
    }

    public void put(@Nonnull String string, AbstractJType abstractJType) {
        this.map.put(string, abstractJType);
    }

    @Nullable
    String packageName() {
        return this._parent == null ? this._packageName : this._parent.packageName();
    }
}

