/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.meta;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.meta.ClassFiller;
import com.helger.jcodemodel.meta.CodeModelBuildingException;
import com.helger.jcodemodel.meta.ErrorTypeFound;
import com.helger.jcodemodel.meta.ErrorTypePolicy;
import com.helger.jcodemodel.meta.RuntimeCodeModelBuildingException;
import com.helger.jcodemodel.meta.RuntimeErrorTypeFound;
import com.helger.jcodemodel.meta.TypeEnvironment;
import com.helger.jcodemodel.meta.TypeMirrorToJTypeVisitor;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

class DecidedErrorTypesModelsAdapter {
    private static final Logger logger = Logger.getLogger(DecidedErrorTypesModelsAdapter.class.getName());
    private final Elements _elementUtils;
    private final ErrorTypePolicy _errorTypePolicy;
    private final JCodeModel _codeModel;

    static int toJMod(Collection<Modifier> collection) {
        int n = 0;
        block12: for (Modifier modifier : collection) {
            switch (modifier) {
                case ABSTRACT: {
                    n |= 0x20;
                    continue block12;
                }
                case FINAL: {
                    n |= 8;
                    continue block12;
                }
                case NATIVE: {
                    n |= 0x40;
                    continue block12;
                }
                case PRIVATE: {
                    n |= 4;
                    continue block12;
                }
                case PROTECTED: {
                    n |= 2;
                    continue block12;
                }
                case PUBLIC: {
                    n |= 1;
                    continue block12;
                }
                case STATIC: {
                    n |= 0x10;
                    continue block12;
                }
                case SYNCHRONIZED: {
                    n |= 0x80;
                    continue block12;
                }
                case TRANSIENT: {
                    n |= 0x100;
                    continue block12;
                }
                case VOLATILE: {
                    n |= 0x200;
                    continue block12;
                }
            }
            logger.log(Level.WARNING, "Skpping unsupported modifier: {0}", (Object)modifier);
        }
        return n;
    }

    private static EClassType toClassType(ElementKind elementKind) {
        switch (elementKind) {
            case CLASS: {
                return EClassType.CLASS;
            }
            case ENUM: {
                return EClassType.ENUM;
            }
            case INTERFACE: {
                return EClassType.INTERFACE;
            }
            case ANNOTATION_TYPE: {
                return EClassType.ANNOTATION_TYPE_DECL;
            }
        }
        throw new UnsupportedOperationException("Unsupported ElementKind: " + (Object)((Object)elementKind));
    }

    DecidedErrorTypesModelsAdapter(JCodeModel jCodeModel, Elements elements, ErrorTypePolicy errorTypePolicy) {
        this._elementUtils = elements;
        this._errorTypePolicy = errorTypePolicy;
        this._codeModel = jCodeModel;
    }

    public JDefinedClass getClass(TypeElement typeElement) throws CodeModelBuildingException, ErrorTypeFound {
        Element element = typeElement.getEnclosingElement();
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            JPackage jPackage = this._codeModel._package(packageElement.getQualifiedName().toString());
            JDefinedClass jDefinedClass = jPackage._getClass(typeElement.getSimpleName().toString());
            if (jDefinedClass != null) {
                return jDefinedClass;
            }
            JDefinedClass jDefinedClass2 = this.defineClass(typeElement);
            jDefinedClass2.hide();
            return jDefinedClass2;
        }
        if (element instanceof TypeElement) {
            JDefinedClass jDefinedClass = this.getClass((TypeElement)element);
            for (JDefinedClass jDefinedClass3 : jDefinedClass.classes()) {
                String string = jDefinedClass3.fullName();
                if (string == null || !string.equals(typeElement.getQualifiedName().toString())) continue;
                return jDefinedClass3;
            }
            throw new IllegalStateException(MessageFormat.format("Inner class should always be defined if outer class is defined: inner class {0}, enclosing class {1}", typeElement, jDefinedClass));
        }
        throw new IllegalStateException("Enclosing element should be package or class");
    }

    private JDefinedClass defineClass(TypeElement typeElement) throws CodeModelBuildingException, ErrorTypeFound {
        Element element = typeElement.getEnclosingElement();
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            return this.defineTopLevelClass(typeElement, new TypeEnvironment(packageElement.getQualifiedName().toString()));
        }
        return this.getClass(typeElement);
    }

    private JDefinedClass defineTopLevelClass(TypeElement typeElement, TypeEnvironment typeEnvironment) throws CodeModelBuildingException, ErrorTypeFound {
        JDefinedClass jDefinedClass;
        Element element;
        EClassType eClassType = DecidedErrorTypesModelsAdapter.toClassType(typeElement.getKind());
        int n = DecidedErrorTypesModelsAdapter.toJMod(typeElement.getModifiers());
        if (eClassType.equals((Object)EClassType.INTERFACE)) {
            n &= 0xFFFFFFDF;
            n &= 0xFFFFFFEF;
        }
        if (!((element = typeElement.getEnclosingElement()) instanceof PackageElement)) {
            throw new IllegalStateException("Expecting top level class");
        }
        PackageElement packageElement = (PackageElement)element;
        JPackage jPackage = this._codeModel._package(packageElement.getQualifiedName().toString());
        try {
            jDefinedClass = jPackage._class(n, typeElement.getSimpleName().toString(), eClassType);
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            throw new CodeModelBuildingException(jClassAlreadyExistsException);
        }
        this.declareInnerClasses(jDefinedClass, typeElement, typeEnvironment);
        ClassFiller classFiller = new ClassFiller(this._codeModel, this, jDefinedClass);
        classFiller.fillClass(typeElement, typeEnvironment);
        return jDefinedClass;
    }

    private void declareInnerClasses(JDefinedClass jDefinedClass, TypeElement typeElement, TypeEnvironment typeEnvironment) throws CodeModelBuildingException {
        for (Element element : typeElement.getEnclosedElements()) {
            JDefinedClass jDefinedClass2;
            if (!element.getKind().equals((Object)ElementKind.INTERFACE) && !element.getKind().equals((Object)ElementKind.CLASS)) continue;
            EClassType eClassType = DecidedErrorTypesModelsAdapter.toClassType(element.getKind());
            int n = DecidedErrorTypesModelsAdapter.toJMod(element.getModifiers());
            if (eClassType.equals((Object)EClassType.INTERFACE)) {
                n &= 0xFFFFFFDF;
                n &= 0xFFFFFFEF;
            }
            try {
                jDefinedClass2 = (JDefinedClass)jDefinedClass._class(n, element.getSimpleName().toString(), eClassType);
            }
            catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
                throw new CodeModelBuildingException(jClassAlreadyExistsException);
            }
            this.declareInnerClasses(jDefinedClass2, (TypeElement)element, typeEnvironment);
        }
    }

    void defineInnerClass(JDefinedClass jDefinedClass, TypeElement typeElement, TypeEnvironment typeEnvironment) throws CodeModelBuildingException, ErrorTypeFound {
        for (JDefinedClass jDefinedClass2 : jDefinedClass.classes()) {
            if (!jDefinedClass2.fullName().equals(typeElement.getQualifiedName().toString())) continue;
            ClassFiller classFiller = new ClassFiller(this._codeModel, this, jDefinedClass2);
            classFiller.fillClass(typeElement, typeEnvironment);
            return;
        }
        throw new IllegalStateException(MessageFormat.format("Inner class should always be defined if outer class is defined: inner class {0}, enclosing class {1}", typeElement, jDefinedClass));
    }

    AbstractJClass ref(TypeElement typeElement) throws CodeModelBuildingException, ErrorTypeFound {
        try {
            Class<?> clazz = Class.forName(typeElement.getQualifiedName().toString());
            AbstractJClass abstractJClass = this._codeModel.ref(clazz);
            return abstractJClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.getClass(typeElement);
        }
    }

    AbstractJType toJType(TypeMirror typeMirror, TypeEnvironment typeEnvironment) throws CodeModelBuildingException, ErrorTypeFound {
        try {
            return typeMirror.accept(new TypeMirrorToJTypeVisitor(this._codeModel, this, this._errorTypePolicy, typeEnvironment), null);
        }
        catch (RuntimeErrorTypeFound runtimeErrorTypeFound) {
            throw runtimeErrorTypeFound.getCause();
        }
        catch (RuntimeCodeModelBuildingException runtimeCodeModelBuildingException) {
            throw runtimeCodeModelBuildingException.getCause();
        }
    }

    Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror annotationMirror) {
        return this._elementUtils.getElementValuesWithDefaults(annotationMirror);
    }
}

