/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel.meta;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.JAnnotationArrayMember;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.meta.CodeModelBuildingException;
import com.helger.jcodemodel.meta.DecidedErrorTypesModelsAdapter;
import com.helger.jcodemodel.meta.ErrorTypeFound;
import com.helger.jcodemodel.meta.TypeEnvironment;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;

class Annotator {
    private final DecidedErrorTypesModelsAdapter _modelsAdapter;
    private final IJAnnotatable _annotatable;
    private final TypeEnvironment _typeEnvironment;

    public Annotator(DecidedErrorTypesModelsAdapter decidedErrorTypesModelsAdapter, IJAnnotatable iJAnnotatable, TypeEnvironment typeEnvironment) {
        this._modelsAdapter = decidedErrorTypesModelsAdapter;
        this._annotatable = iJAnnotatable;
        this._typeEnvironment = typeEnvironment;
    }

    void annotate(List<? extends AnnotationMirror> list) throws CodeModelBuildingException, IllegalStateException, ErrorTypeFound {
        for (AnnotationMirror annotationMirror : list) {
            this.annotate(annotationMirror);
        }
    }

    private void annotate(AnnotationMirror annotationMirror) throws CodeModelBuildingException, IllegalStateException, ErrorTypeFound {
        JAnnotationUse jAnnotationUse = this._annotatable.annotate((AbstractJClass)this._modelsAdapter.toJType(annotationMirror.getAnnotationType(), this._typeEnvironment));
        ArgumentAdder argumentAdder = new ArgumentAdder(jAnnotationUse);
        argumentAdder.addArguments(annotationMirror);
    }

    class ArgumentAdder {
        private final JAnnotationUse _annotationUse;

        public ArgumentAdder(JAnnotationUse jAnnotationUse) {
            this._annotationUse = jAnnotationUse;
        }

        void addArguments(AnnotationMirror annotationMirror) throws CodeModelBuildingException, IllegalStateException, ErrorTypeFound {
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = Annotator.this._modelsAdapter.getElementValuesWithDefaults(annotationMirror);
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                String string = entry.getKey().getSimpleName().toString();
                Object object = entry.getValue().getValue();
                this.addArgument(string, object);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addArgument(String string, Object object) throws IllegalStateException, CodeModelBuildingException, ErrorTypeFound {
            if (object instanceof String) {
                this._annotationUse.param(string, (String)object);
                return;
            } else if (object instanceof Integer) {
                this._annotationUse.param(string, (Integer)object);
                return;
            } else if (object instanceof Long) {
                this._annotationUse.param(string, (Long)object);
                return;
            } else if (object instanceof Short) {
                this._annotationUse.param(string, (Short)object);
                return;
            } else if (object instanceof Float) {
                this._annotationUse.param(string, ((Float)object).floatValue());
                return;
            } else if (object instanceof Double) {
                this._annotationUse.param(string, (Double)object);
                return;
            } else if (object instanceof Byte) {
                this._annotationUse.param(string, (Byte)object);
                return;
            } else if (object instanceof Character) {
                this._annotationUse.param(string, ((Character)object).charValue());
                return;
            } else if (object instanceof Boolean) {
                this._annotationUse.param(string, (Boolean)object);
                return;
            } else if (object instanceof Class) {
                this._annotationUse.param(string, (Class)object);
                return;
            } else if (object instanceof DeclaredType) {
                this._annotationUse.param(string, Annotator.this._modelsAdapter.toJType((DeclaredType)object, Annotator.this._typeEnvironment));
                return;
            } else if (object instanceof VariableElement) {
                try {
                    this._annotationUse.param(string, this.actualEnumConstantValue((VariableElement)object));
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(Annotator.class.getName()).log(Level.WARNING, "Not processing annotation argument: {0}: {1}", new Object[]{string, object});
                }
                return;
            } else if (object instanceof AnnotationMirror) {
                AnnotationMirror annotationMirror = (AnnotationMirror)object;
                AbstractJClass abstractJClass = (AbstractJClass)Annotator.this._modelsAdapter.toJType(annotationMirror.getAnnotationType(), Annotator.this._typeEnvironment);
                JAnnotationUse jAnnotationUse = this._annotationUse.annotationParam(string, abstractJClass);
                ArgumentAdder argumentAdder = new ArgumentAdder(jAnnotationUse);
                argumentAdder.addArguments(annotationMirror);
                return;
            } else {
                if (!(object instanceof List)) throw new IllegalStateException(MessageFormat.format("Unknown annotation argument: {0}: {1} ({2})", string, object, object.getClass()));
                List list = (List)object;
                Iterator iterator = list.iterator();
                if (!iterator.hasNext()) return;
                AnnotationValue annotationValue = (AnnotationValue)iterator.next();
                Object object2 = annotationValue.getValue();
                if (object2 instanceof String) {
                    String[] stringArray = new String[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue2 : list) {
                        stringArray[n] = (String)annotationValue2.getValue();
                        ++n;
                    }
                    this._annotationUse.paramArray(string, stringArray);
                    return;
                } else if (object2 instanceof Integer) {
                    int[] nArray = new int[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue3 : list) {
                        nArray[n] = (Integer)annotationValue3.getValue();
                        ++n;
                    }
                    this._annotationUse.paramArray(string, nArray);
                    return;
                } else if (object2 instanceof Long) {
                    long[] lArray = new long[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue4 : list) {
                        lArray[n] = (Long)annotationValue4.getValue();
                        ++n;
                    }
                    this._annotationUse.paramArray(string, lArray);
                    return;
                } else if (object2 instanceof Short) {
                    short[] sArray = new short[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue5 : list) {
                        sArray[n] = (Short)annotationValue5.getValue();
                        ++n;
                    }
                    this._annotationUse.paramArray(string, sArray);
                    return;
                } else if (object2 instanceof Float) {
                    float[] fArray = new float[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue6 : list) {
                        fArray[n] = ((Float)annotationValue6.getValue()).floatValue();
                        ++n;
                    }
                    this._annotationUse.paramArray(string, fArray);
                    return;
                } else if (object2 instanceof Double) {
                    double[] dArray = new double[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue7 : list) {
                        dArray[n] = (Double)annotationValue7.getValue();
                        ++n;
                    }
                    this._annotationUse.paramArray(string, dArray);
                    return;
                } else if (object2 instanceof Byte) {
                    byte[] byArray = new byte[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue8 : list) {
                        byArray[n] = (Byte)annotationValue8.getValue();
                        ++n;
                    }
                    this._annotationUse.paramArray(string, byArray);
                    return;
                } else if (object2 instanceof Character) {
                    char[] cArray = new char[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue9 : list) {
                        cArray[n] = ((Character)annotationValue9.getValue()).charValue();
                        ++n;
                    }
                    this._annotationUse.paramArray(string, cArray);
                    return;
                } else if (object2 instanceof Boolean) {
                    boolean[] blArray = new boolean[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue10 : list) {
                        blArray[n] = (Boolean)annotationValue10.getValue();
                        ++n;
                    }
                    this._annotationUse.paramArray(string, blArray);
                    return;
                } else if (object2 instanceof Class) {
                    Class[] classArray = new Class[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue11 : list) {
                        classArray[n] = (Class)annotationValue11.getValue();
                        ++n;
                    }
                    this._annotationUse.paramArray(string, classArray);
                    return;
                } else if (object2 instanceof DeclaredType) {
                    AbstractJType[] abstractJTypeArray = new AbstractJType[list.size()];
                    int n = 0;
                    for (AnnotationValue annotationValue12 : list) {
                        abstractJTypeArray[n] = Annotator.this._modelsAdapter.toJType((DeclaredType)annotationValue12.getValue(), Annotator.this._typeEnvironment);
                        ++n;
                    }
                    this._annotationUse.paramArray(string, abstractJTypeArray);
                    return;
                } else if (object2 instanceof VariableElement) {
                    try {
                        Enum[] enumArray = new Enum[list.size()];
                        int n = 0;
                        for (AnnotationValue annotationValue13 : list) {
                            enumArray[n] = this.actualEnumConstantValue((VariableElement)annotationValue13.getValue());
                            ++n;
                        }
                        this._annotationUse.paramArray(string, enumArray);
                        return;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Logger.getLogger(Annotator.class.getName()).log(Level.WARNING, "Not processing annotation argument: {0}: {1}", new Object[]{string, list});
                    }
                    return;
                } else {
                    if (!(object2 instanceof AnnotationMirror)) throw new IllegalStateException(MessageFormat.format("Unknown annotation array argument: {0}: {1} ({2})", string, object2, object2.getClass()));
                    JAnnotationArrayMember jAnnotationArrayMember = this._annotationUse.paramArray(string);
                    for (AnnotationValue annotationValue14 : list) {
                        AnnotationMirror annotationMirror = (AnnotationMirror)annotationValue14.getValue();
                        AbstractJClass abstractJClass = (AbstractJClass)Annotator.this._modelsAdapter.toJType(annotationMirror.getAnnotationType(), Annotator.this._typeEnvironment);
                        JAnnotationUse jAnnotationUse = jAnnotationArrayMember.annotate(abstractJClass);
                        ArgumentAdder argumentAdder = new ArgumentAdder(jAnnotationUse);
                        argumentAdder.addArguments(annotationMirror);
                    }
                }
            }
        }

        private Enum<?> actualEnumConstantValue(VariableElement variableElement) throws ClassNotFoundException {
            Enum enum_;
            Field field;
            TypeElement typeElement = (TypeElement)variableElement.getEnclosingElement();
            Class<?> clazz = Class.forName(typeElement.getQualifiedName().toString());
            try {
                field = clazz.getField(variableElement.getSimpleName().toString());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalStateException(MessageFormat.format("Unable to load enum constant: {0}.{1}", typeElement.getQualifiedName().toString(), variableElement.getSimpleName().toString()), noSuchFieldException);
            }
            catch (SecurityException securityException) {
                throw new IllegalStateException(MessageFormat.format("Unable to load enum constant: {0}.{1}", typeElement.getQualifiedName().toString(), variableElement.getSimpleName().toString()), securityException);
            }
            try {
                enum_ = (Enum)field.get(null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(MessageFormat.format("Unable to load enum constant actual value: {0}.{1}", typeElement.getQualifiedName().toString(), variableElement.getSimpleName().toString()), illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(MessageFormat.format("Unable to load enum constant actual value: {0}.{1}", typeElement.getQualifiedName().toString(), variableElement.getSimpleName().toString()), illegalAccessException);
            }
            return enum_;
        }
    }
}

