/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJAnnotationWriter;
import com.helger.jcodemodel.JAnnotationArrayMember;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.util.JCSecureLoader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class TypedAnnotationWriter<A extends Annotation, W extends IJAnnotationWriter<A>>
implements InvocationHandler,
IJAnnotationWriter<A> {
    private final JAnnotationUse _use;
    private final Class<A> _annotation;
    private final Class<W> _writerType;
    private Map<String, JAnnotationArrayMember> _arrays;

    protected TypedAnnotationWriter(Class<A> clazz, Class<W> clazz2, JAnnotationUse jAnnotationUse) {
        this._annotation = clazz;
        this._writerType = clazz2;
        this._use = jAnnotationUse;
    }

    @Override
    public JAnnotationUse getAnnotationUse() {
        return this._use;
    }

    @Override
    public Class<A> getAnnotationType() {
        return this._annotation;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Method method2;
        Class<?> clazz;
        if (method.getDeclaringClass() == IJAnnotationWriter.class) {
            try {
                return method.invoke((Object)this, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
        String string = method.getName();
        Object object2 = null;
        if (objectArray != null && objectArray.length > 0) {
            object2 = objectArray[0];
        }
        if ((clazz = (method2 = this._annotation.getDeclaredMethod(string, new Class[0])).getReturnType()).isArray()) {
            return this._addArrayValue(object, string, clazz.getComponentType(), method.getReturnType(), object2);
        }
        if (Annotation.class.isAssignableFrom(clazz)) {
            Class<?> clazz2 = clazz;
            return super._createProxy();
        }
        if (object2 instanceof AbstractJType) {
            AbstractJType abstractJType = (AbstractJType)object2;
            this._checkType(Class.class, clazz);
            if (method2.getDefaultValue() != null && abstractJType.equals(abstractJType.owner().ref((Class)method2.getDefaultValue()))) {
                return object;
            }
            this._use.param(string, abstractJType);
            return object;
        }
        this._checkType(object2.getClass(), clazz);
        if (method2.getDefaultValue() != null && method2.getDefaultValue().equals(object2)) {
            return object;
        }
        if (object2 instanceof String) {
            this._use.param(string, (String)object2);
            return object;
        }
        if (object2 instanceof Boolean) {
            this._use.param(string, (Boolean)object2);
            return object;
        }
        if (object2 instanceof Integer) {
            this._use.param(string, (Integer)object2);
            return object;
        }
        if (object2 instanceof Class) {
            this._use.param(string, (Class)object2);
            return object;
        }
        if (object2 instanceof Enum) {
            this._use.param(string, (Enum)object2);
            return object;
        }
        throw new IllegalArgumentException("Unable to handle this method call " + method.toString());
    }

    private Object _addArrayValue(Object object, String string, Class<?> clazz, Class<?> clazz2, Object object2) {
        JAnnotationArrayMember jAnnotationArrayMember;
        if (this._arrays == null) {
            this._arrays = new HashMap<String, JAnnotationArrayMember>();
        }
        if ((jAnnotationArrayMember = this._arrays.get(string)) == null) {
            jAnnotationArrayMember = this._use.paramArray(string);
            this._arrays.put(string, jAnnotationArrayMember);
        }
        if (Annotation.class.isAssignableFrom(clazz)) {
            Class<?> clazz3 = clazz;
            if (!IJAnnotationWriter.class.isAssignableFrom(clazz2)) {
                throw new IllegalArgumentException("Unexpected return type " + clazz2);
            }
            return super._createProxy();
        }
        if (object2 instanceof AbstractJType) {
            this._checkType(Class.class, clazz);
            jAnnotationArrayMember.param((AbstractJType)object2);
            return object;
        }
        this._checkType(object2.getClass(), clazz);
        if (object2 instanceof String) {
            jAnnotationArrayMember.param((String)object2);
            return object;
        }
        if (object2 instanceof Boolean) {
            jAnnotationArrayMember.param((Boolean)object2);
            return object;
        }
        if (object2 instanceof Integer) {
            jAnnotationArrayMember.param((Integer)object2);
            return object;
        }
        if (object2 instanceof Class) {
            jAnnotationArrayMember.param((Class)object2);
            return object;
        }
        throw new IllegalArgumentException("Unable to handle this method call ");
    }

    private void _checkType(Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == clazz || clazz2.isAssignableFrom(clazz)) {
            return;
        }
        if (clazz2 == JCodeModel.boxToPrimitive.get(clazz)) {
            return;
        }
        throw new IllegalArgumentException("Expected " + clazz2 + " but found " + clazz);
    }

    private W _createProxy() {
        return (W)((IJAnnotationWriter)Proxy.newProxyInstance(JCSecureLoader.getClassClassLoader(this._writerType), new Class[]{this._writerType}, (InvocationHandler)this));
    }

    @Nonnull
    static <W extends IJAnnotationWriter<?>> W create(@Nonnull Class<W> clazz, @Nonnull IJAnnotatable iJAnnotatable) {
        Class<Annotation> clazz2 = TypedAnnotationWriter._findAnnotationType(clazz);
        return super._createProxy();
    }

    private static Class<? extends Annotation> _findAnnotationType(@Nonnull Class<?> clazz) {
        for (Type type : clazz.getGenericInterfaces()) {
            Type type2;
            if (type instanceof ParameterizedType && (type2 = (ParameterizedType)type).getRawType() == IJAnnotationWriter.class) {
                return (Class)type2.getActualTypeArguments()[0];
            }
            if (!(type instanceof Class) || (type2 = TypedAnnotationWriter._findAnnotationType((Class)type)) == null) continue;
            return type2;
        }
        return null;
    }
}

