/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJDeclaration;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JTypeVar
extends AbstractJClass
implements IJDeclaration {
    private final String m_sName;
    private final List<AbstractJClass> m_aBounds = new ArrayList<AbstractJClass>();

    protected JTypeVar(@Nonnull JCodeModel jCodeModel, @Nonnull String string) {
        super(jCodeModel);
        this.m_sName = JCValueEnforcer.notEmpty(string, "Name");
    }

    @Override
    @Nonnull
    public String name() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public String fullName() {
        return this.m_sName;
    }

    @Override
    @Nullable
    public JPackage _package() {
        return null;
    }

    @Nonnull
    public JTypeVar bound(@Nonnull AbstractJClass abstractJClass) {
        JCValueEnforcer.notNull(abstractJClass, "Bound");
        this.m_aBounds.add(abstractJClass);
        return this;
    }

    @Nonnull
    public JTypeVar boundLike(@Nonnull JTypeVar jTypeVar) {
        JCValueEnforcer.notNull(jTypeVar, "sourceTypeParameter");
        AbstractJClass abstractJClass = jTypeVar._extends();
        this.bound(abstractJClass);
        Iterator<AbstractJClass> iterator = jTypeVar._implements();
        while (iterator.hasNext()) {
            this.bound(iterator.next());
        }
        return this;
    }

    @Override
    @Nonnull
    public AbstractJClass _extends() {
        if (this.m_aBounds.isEmpty() || this.m_aBounds.get(0).isInterface()) {
            return this.owner().ref(Object.class);
        }
        return this.m_aBounds.get(0);
    }

    @Override
    @Nonnull
    public Iterator<AbstractJClass> _implements() {
        if (this.m_aBounds.isEmpty() || this.m_aBounds.get(0).isInterface()) {
            return this.m_aBounds.iterator();
        }
        return this.m_aBounds.subList(1, this.m_aBounds.size()).iterator();
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    @Nonnull
    protected AbstractJClass substituteParams(@Nonnull JTypeVar[] jTypeVarArray, @Nonnull List<? extends AbstractJClass> list) {
        for (int i = 0; i < jTypeVarArray.length; ++i) {
            if (jTypeVarArray[i] != this) continue;
            return list.get(i);
        }
        return this;
    }

    @Override
    public void declare(@Nonnull JFormatter jFormatter) {
        jFormatter.id(this.name());
        if (!this.m_aBounds.isEmpty()) {
            jFormatter.print("extends").generable(this.m_aBounds.get(0));
            for (AbstractJClass abstractJClass : this.m_aBounds.subList(1, this.m_aBounds.size())) {
                jFormatter.print("& ").generable(abstractJClass);
            }
        }
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        jFormatter.id(this.m_sName);
    }
}

