/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCatchBlock;
import com.helger.jcodemodel.JFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class JTryBlock
implements IJStatement {
    private final JBlock _body = new JBlock();
    private final List<JCatchBlock> _catches = new ArrayList<JCatchBlock>();
    private JBlock _finally;

    protected JTryBlock() {
    }

    @Nonnull
    public JBlock body() {
        return this._body;
    }

    @Nonnull
    public JCatchBlock _catch(@Nonnull AbstractJClass abstractJClass) {
        JCatchBlock jCatchBlock = new JCatchBlock(abstractJClass);
        this._catches.add(jCatchBlock);
        return jCatchBlock;
    }

    @Nonnull
    public List<JCatchBlock> catches() {
        return Collections.unmodifiableList(this._catches);
    }

    @Nonnull
    public JBlock _finally() {
        if (this._finally == null) {
            this._finally = new JBlock();
        }
        return this._finally;
    }

    @Override
    public void state(@Nonnull JFormatter jFormatter) {
        jFormatter.print("try").generable(this._body);
        for (JCatchBlock jCatchBlock : this._catches) {
            jFormatter.generable(jCatchBlock);
        }
        if (this._finally != null) {
            jFormatter.print("finally").generable(this._finally);
        }
        jFormatter.newline();
    }
}

