/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JCase;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JOp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class JSwitch
implements IJStatement {
    private final IJExpression m_aTestExpr;
    private final List<JCase> m_aCases = new ArrayList<JCase>();
    private JCase m_aDefaultCase;

    protected JSwitch(@Nonnull IJExpression iJExpression) {
        this.m_aTestExpr = iJExpression;
    }

    @Nonnull
    public IJExpression test() {
        return this.m_aTestExpr;
    }

    @Nonnull
    public Iterator<JCase> cases() {
        return this.m_aCases.iterator();
    }

    @Nonnull
    public JCase _case(@Nonnull IJExpression iJExpression) {
        JCase jCase = new JCase(iJExpression);
        this.m_aCases.add(jCase);
        return jCase;
    }

    @Nonnull
    public JCase _default() {
        if (this.m_aDefaultCase == null) {
            this.m_aDefaultCase = new JCase(null, true);
        }
        return this.m_aDefaultCase;
    }

    @Override
    public void state(@Nonnull JFormatter jFormatter) {
        if (JOp.hasTopOp(this.m_aTestExpr)) {
            jFormatter.print("switch ").generable(this.m_aTestExpr).print(" {").newline();
        } else {
            jFormatter.print("switch (").generable(this.m_aTestExpr).print(')').print(" {").newline();
        }
        for (JCase jCase : this.m_aCases) {
            jFormatter.statement(jCase);
        }
        if (this.m_aDefaultCase != null) {
            jFormatter.statement(this.m_aDefaultCase);
        }
        jFormatter.print('}').newline();
    }
}

