/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.JTypeVar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JNarrowedClass
extends AbstractJClass {
    private final AbstractJClass _basis;
    private final List<? extends AbstractJClass> _args;

    public JNarrowedClass(@Nonnull AbstractJClass abstractJClass, @Nonnull AbstractJClass abstractJClass2) {
        this(abstractJClass, Collections.singletonList(abstractJClass2));
    }

    public JNarrowedClass(@Nonnull AbstractJClass abstractJClass, @Nonnull List<? extends AbstractJClass> list) {
        super(abstractJClass.owner());
        if (abstractJClass instanceof JNarrowedClass) {
            throw new IllegalArgumentException("basis may not be a narrowed class: " + abstractJClass);
        }
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Arguments are missing");
        }
        this._basis = abstractJClass;
        this._args = list;
    }

    @Nonnull
    public AbstractJClass basis() {
        return this._basis;
    }

    @Override
    public JNarrowedClass narrow(@Nonnull AbstractJClass abstractJClass) {
        if (abstractJClass == null) {
            throw new IllegalArgumentException("Narrowing class is missing");
        }
        ArrayList<? extends AbstractJClass> arrayList = new ArrayList<AbstractJClass>(this._args);
        arrayList.add(abstractJClass);
        return new JNarrowedClass(this._basis, arrayList);
    }

    @Override
    public JNarrowedClass narrow(AbstractJClass ... abstractJClassArray) {
        if (abstractJClassArray == null || abstractJClassArray.length == 0) {
            throw new IllegalArgumentException("Narrowing classes are missing");
        }
        ArrayList<? extends AbstractJClass> arrayList = new ArrayList<AbstractJClass>(this._args);
        for (AbstractJClass abstractJClass : abstractJClassArray) {
            arrayList.add(abstractJClass);
        }
        return new JNarrowedClass(this._basis, arrayList);
    }

    @Override
    public String name() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._basis.name()).append('<');
        boolean bl = true;
        for (AbstractJClass abstractJClass : this._args) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(abstractJClass.name());
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public String fullName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._basis.fullName());
        stringBuilder.append('<');
        boolean bl = true;
        for (AbstractJClass abstractJClass : this._args) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(abstractJClass.fullName());
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    @Override
    public String binaryName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._basis.binaryName());
        stringBuilder.append('<');
        boolean bl = true;
        for (AbstractJClass abstractJClass : this._args) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(abstractJClass.binaryName());
        }
        stringBuilder.append('>');
        return stringBuilder.toString();
    }

    @Override
    public void generate(JFormatter jFormatter) {
        jFormatter.type(this._basis).print('<').generable(this._args).print('\uffff');
    }

    @Override
    void printLink(JFormatter jFormatter) {
        this._basis.printLink(jFormatter);
        jFormatter.print("{@code <}");
        boolean bl = true;
        for (AbstractJClass abstractJClass : this._args) {
            if (bl) {
                bl = false;
            } else {
                jFormatter.print(',');
            }
            abstractJClass.printLink(jFormatter);
        }
        jFormatter.print("{@code >}");
    }

    @Override
    @Nonnull
    public JPackage _package() {
        return this._basis._package();
    }

    @Override
    @Nullable
    public AbstractJClass _extends() {
        AbstractJClass abstractJClass = this._basis._extends();
        if (abstractJClass == null) {
            return abstractJClass;
        }
        return abstractJClass.substituteParams(this._basis.typeParams(), this._args);
    }

    @Override
    @Nonnull
    public Iterator<AbstractJClass> _implements() {
        return new Iterator<AbstractJClass>(){
            private final Iterator<AbstractJClass> core;
            {
                this.core = JNarrowedClass.this._basis._implements();
            }

            @Override
            public void remove() {
                this.core.remove();
            }

            @Override
            public AbstractJClass next() {
                return this.core.next().substituteParams(JNarrowedClass.this._basis.typeParams(), JNarrowedClass.this._args);
            }

            @Override
            public boolean hasNext() {
                return this.core.hasNext();
            }
        };
    }

    @Override
    @Nonnull
    public AbstractJClass erasure() {
        return this._basis;
    }

    @Override
    public boolean isInterface() {
        return this._basis.isInterface();
    }

    @Override
    public boolean isAbstract() {
        return this._basis.isAbstract();
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isError() {
        if (this._basis.isError()) {
            return true;
        }
        for (AbstractJClass abstractJClass : this._args) {
            if (!abstractJClass.isError()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<? extends AbstractJClass> getTypeParameters() {
        return this._args;
    }

    @Override
    protected AbstractJClass substituteParams(JTypeVar[] jTypeVarArray, List<? extends AbstractJClass> list) {
        AbstractJClass abstractJClass = this._basis.substituteParams(jTypeVarArray, list);
        boolean bl = abstractJClass != this._basis;
        ArrayList<AbstractJClass> arrayList = new ArrayList<AbstractJClass>(this._args.size());
        for (AbstractJClass abstractJClass2 : this._args) {
            AbstractJClass abstractJClass3 = abstractJClass2.substituteParams(jTypeVarArray, list);
            arrayList.add(abstractJClass3);
            bl |= abstractJClass3 != abstractJClass2;
        }
        if (bl) {
            return new JNarrowedClass(abstractJClass, arrayList);
        }
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JNarrowedClass jNarrowedClass = (JNarrowedClass)object;
        return this._basis.equals(jNarrowedClass._basis) && this._args.equals(jNarrowedClass._args);
    }

    public int hashCode() {
        return this._basis.hashCode() * 37 + this._args.hashCode();
    }
}

