/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJExpressionImpl;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JLambdaBlock;
import com.helger.jcodemodel.JLambdaParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JLambda
extends AbstractJExpressionImpl {
    private final List<JLambdaParam> m_aParams = new ArrayList<JLambdaParam>();
    private final JLambdaBlock m_aBodyStatement = new JLambdaBlock();

    @Nonnull
    public JLambdaParam addParam(@Nonnull String string) {
        JLambdaParam jLambdaParam = new JLambdaParam(null, string);
        this.m_aParams.add(jLambdaParam);
        return jLambdaParam;
    }

    @Nonnull
    public JLambdaParam addParam(@Nullable AbstractJType abstractJType, @Nonnull String string) {
        JLambdaParam jLambdaParam = new JLambdaParam(abstractJType, string);
        this.m_aParams.add(jLambdaParam);
        return jLambdaParam;
    }

    @Nonnull
    public List<JLambdaParam> params() {
        return Collections.unmodifiableList(this.m_aParams);
    }

    @Nonnegative
    public int paramCount() {
        return this.m_aParams.size();
    }

    @Nonnull
    public JLambdaBlock body() {
        return this.m_aBodyStatement;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        int n;
        int n2 = this.m_aParams.size();
        if (n2 == 0) {
            throw new IllegalStateException("Lambda expression needs at least one parameter!");
        }
        JLambdaParam jLambdaParam = this.m_aParams.get(0);
        for (n = 1; n < n2; ++n) {
            if (this.m_aParams.get(n).hasType() == jLambdaParam.hasType()) continue;
            throw new IllegalStateException("Lambda expression parameters must all have types or none may have a type!");
        }
        if (this.m_aBodyStatement.isEmpty()) {
            throw new IllegalStateException("Lambda expression is empty!");
        }
        if (n2 == 1 && !jLambdaParam.hasType()) {
            this.m_aParams.get(0).declare(jFormatter);
        } else {
            jFormatter.print('(');
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    jFormatter.print(',');
                }
                this.m_aParams.get(n).declare(jFormatter);
            }
            jFormatter.print(')');
        }
        jFormatter.print(" -> ");
        this.m_aBodyStatement.bracesRequired(this.m_aBodyStatement.size() != 1 || !(this.m_aBodyStatement.getContents().get(0) instanceof IJExpression));
        jFormatter.statement(this.m_aBodyStatement);
    }
}

