/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJDeclaration;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnonymousClass;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JNarrowedClass;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.JVar;
import com.helger.jcodemodel.SourcePrintWriter;
import com.helger.jcodemodel.util.ClassNameComparator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import com.helger.jcodemodel.util.NullWriter;
import java.io.Closeable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JFormatter
implements Closeable {
    public static final String DEFAULT_INDENT_SPACE = "    ";
    static final char CLOSE_TYPE_ARGS = '\uffff';
    private final Map<String, NameUsage> m_aCollectedReferences = new HashMap<String, NameUsage>();
    private final ImportedClasses m_aImportedClasses = new ImportedClasses();
    private EMode m_eMode = EMode.PRINTING;
    private int m_nIndentLevel;
    private final String m_sIndentSpace;
    private final SourcePrintWriter m_aPW;
    private char m_cLastChar = '\u0000';
    private boolean m_bAtBeginningOfLine = true;
    private JPackage m_aPckJavaLang;
    private boolean m_bContainsErrorTypes;
    private final boolean m_bImportDebug = false;

    public JFormatter(@Nonnull SourcePrintWriter sourcePrintWriter) {
        this(sourcePrintWriter, DEFAULT_INDENT_SPACE);
    }

    public JFormatter(@Nonnull SourcePrintWriter sourcePrintWriter, @Nonnull String string) {
        JCValueEnforcer.notNull(sourcePrintWriter, "PrintWriter");
        JCValueEnforcer.notNull(string, "IndentSpace");
        this.m_aPW = sourcePrintWriter;
        this.m_sIndentSpace = string;
    }

    public JFormatter(@Nonnull Writer writer) {
        this(writer, DEFAULT_INDENT_SPACE);
    }

    public JFormatter(@Nonnull Writer writer, @Nonnull String string) {
        this(writer, string, System.getProperty("line.separator"));
    }

    public JFormatter(@Nonnull Writer writer, @Nonnull String string, @Nonnull String string2) {
        this(writer instanceof SourcePrintWriter ? (SourcePrintWriter)writer : new SourcePrintWriter(writer, string2), string);
    }

    @Override
    public void close() {
        this.m_aPW.close();
    }

    public boolean isPrinting() {
        return this.m_eMode == EMode.PRINTING;
    }

    @Nonnull
    public JFormatter outdent() {
        --this.m_nIndentLevel;
        return this;
    }

    @Nonnull
    public JFormatter indent() {
        ++this.m_nIndentLevel;
        return this;
    }

    private static boolean _needSpace(char c, char c2) {
        if (c == ']' && c2 == '{') {
            return true;
        }
        if (c == ';') {
            return true;
        }
        if (c == '\uffff') {
            return c2 != '(';
        }
        if (c == ')' && c2 == '{') {
            return true;
        }
        if (c == ',' || c == '=') {
            return true;
        }
        if (c2 == '=') {
            return true;
        }
        if (Character.isDigit(c)) {
            return c2 != '(' && c2 != ')' && c2 != ';' && c2 != ',';
        }
        if (Character.isJavaIdentifierPart(c)) {
            switch (c2) {
                case '+': 
                case '-': 
                case '>': 
                case '@': 
                case '{': 
                case '}': {
                    return true;
                }
            }
            return Character.isJavaIdentifierStart(c2);
        }
        if (Character.isJavaIdentifierStart(c2)) {
            switch (c) {
                case ')': 
                case '+': 
                case ']': 
                case '}': {
                    return true;
                }
            }
            return false;
        }
        if (Character.isDigit(c2)) {
            return c != '(';
        }
        return false;
    }

    private void _spaceIfNeeded(char c) {
        if (this.m_bAtBeginningOfLine) {
            for (int i = 0; i < this.m_nIndentLevel; ++i) {
                this.m_aPW.print(this.m_sIndentSpace);
            }
            this.m_bAtBeginningOfLine = false;
        } else if (this.m_cLastChar != '\u0000' && JFormatter._needSpace(this.m_cLastChar, c)) {
            this.m_aPW.print(' ');
        }
    }

    @Nonnull
    public JFormatter print(char c) {
        if (this.m_eMode == EMode.PRINTING) {
            if (c == '\uffff') {
                this.m_aPW.print('>');
            } else {
                this._spaceIfNeeded(c);
                this.m_aPW.print(c);
            }
            this.m_cLastChar = c;
        }
        return this;
    }

    @Nonnull
    public JFormatter print(@Nonnull String string) {
        if (this.m_eMode == EMode.PRINTING && string.length() > 0) {
            this._spaceIfNeeded(string.charAt(0));
            this.m_aPW.print(string);
            this.m_cLastChar = string.charAt(string.length() - 1);
        }
        return this;
    }

    @Nonnull
    public JFormatter type(@Nonnull AbstractJType abstractJType) {
        if (abstractJType.isReference()) {
            return this.type((AbstractJClass)abstractJType);
        }
        return this.generable(abstractJType);
    }

    @Nonnull
    public JFormatter type(@Nonnull AbstractJClass abstractJClass) {
        switch (this.m_eMode) {
            case COLLECTING: {
                if (abstractJClass.isError()) break;
                String string = abstractJClass.name();
                NameUsage nameUsage = this.m_aCollectedReferences.get(string);
                if (nameUsage == null) {
                    nameUsage = new NameUsage(string);
                    this.m_aCollectedReferences.put(string, nameUsage);
                }
                nameUsage.addReferencedType(abstractJClass);
                break;
            }
            case PRINTING: {
                if (abstractJClass.isError()) {
                    this.print("Object");
                    break;
                }
                if (this.m_aImportedClasses.contains(abstractJClass) || abstractJClass._package() == this.m_aPckJavaLang) {
                    this.print(abstractJClass.name());
                    break;
                }
                AbstractJClass abstractJClass2 = abstractJClass.outer();
                if (abstractJClass2 != null) {
                    this.type(abstractJClass2).print('.').print(abstractJClass.name());
                    break;
                }
                this.print(abstractJClass.fullName());
                break;
            }
            case FIND_ERROR_TYPES: {
                if (!abstractJClass.isError()) break;
                this.m_bContainsErrorTypes = true;
            }
        }
        return this;
    }

    @Nonnull
    public JFormatter id(@Nonnull String string) {
        switch (this.m_eMode) {
            case COLLECTING: {
                NameUsage nameUsage = this.m_aCollectedReferences.get(string);
                if (nameUsage == null) {
                    nameUsage = new NameUsage(string);
                    this.m_aCollectedReferences.put(string, nameUsage);
                }
                nameUsage.setVariableName();
                break;
            }
            case PRINTING: {
                this.print(string);
            }
        }
        return this;
    }

    @Nonnull
    public JFormatter newline() {
        if (this.m_eMode == EMode.PRINTING) {
            this.m_aPW.println();
            this.m_cLastChar = '\u0000';
            this.m_bAtBeginningOfLine = true;
        }
        return this;
    }

    @Nonnull
    public JFormatter generable(@Nonnull IJGenerable iJGenerable) {
        iJGenerable.generate(this);
        return this;
    }

    @Nonnull
    public JFormatter generable(@Nonnull Collection<? extends IJGenerable> collection) {
        if (!collection.isEmpty()) {
            boolean bl = true;
            for (IJGenerable iJGenerable : collection) {
                if (!bl) {
                    this.print(',');
                }
                this.generable(iJGenerable);
                bl = false;
            }
        }
        return this;
    }

    @Nonnull
    public JFormatter declaration(@Nonnull IJDeclaration iJDeclaration) {
        iJDeclaration.declare(this);
        return this;
    }

    @Nonnull
    public JFormatter statement(@Nonnull IJStatement iJStatement) {
        iJStatement.state(this);
        return this;
    }

    @Nonnull
    public JFormatter var(@Nonnull JVar jVar) {
        jVar.bind(this);
        return this;
    }

    private boolean _collectCausesNoAmbiguities(@Nonnull AbstractJClass abstractJClass, @Nonnull JDefinedClass jDefinedClass) {
        NameUsage nameUsage = this.m_aCollectedReferences.get(abstractJClass.name());
        if (nameUsage == null) {
            return true;
        }
        return !nameUsage.isAmbiguousIn(jDefinedClass) && nameUsage.containsReferencedType(abstractJClass);
    }

    private boolean _collectShouldBeImported(@Nonnull AbstractJClass abstractJClass, @Nonnull JDefinedClass jDefinedClass) {
        AbstractJClass abstractJClass2;
        AbstractJClass abstractJClass3 = abstractJClass;
        if (abstractJClass3 instanceof JAnonymousClass) {
            abstractJClass3 = ((JAnonymousClass)abstractJClass3).base();
        }
        if (abstractJClass3 instanceof JNarrowedClass) {
            abstractJClass3 = abstractJClass3.erasure();
        }
        if ((abstractJClass2 = abstractJClass3.outer()) != null) {
            return abstractJClass3.name().contains(abstractJClass2.name()) && this._collectShouldBeImported(abstractJClass2, jDefinedClass);
        }
        return true;
    }

    private void _collectImportOuterClassIfCausesNoAmbiguities(@Nonnull AbstractJClass abstractJClass, @Nonnull JDefinedClass jDefinedClass) {
        AbstractJClass abstractJClass2 = abstractJClass.outer();
        if (abstractJClass2 != null) {
            if (this._collectCausesNoAmbiguities(abstractJClass2, jDefinedClass) && this._collectShouldBeImported(abstractJClass2, jDefinedClass)) {
                this.m_aImportedClasses.add(abstractJClass2);
            } else {
                this._collectImportOuterClassIfCausesNoAmbiguities(abstractJClass2, jDefinedClass);
            }
        }
    }

    private boolean _printIsImplicitlyImported(@Nonnull AbstractJClass abstractJClass, @Nonnull AbstractJClass abstractJClass2) {
        JPackage jPackage;
        AbstractJClass abstractJClass3 = abstractJClass;
        if (abstractJClass3 instanceof JAnonymousClass) {
            abstractJClass3 = ((JAnonymousClass)abstractJClass3).base();
        }
        if (abstractJClass3 instanceof JNarrowedClass) {
            abstractJClass3 = abstractJClass3.erasure();
        }
        if ((jPackage = abstractJClass3._package()) == null) {
            return true;
        }
        if (jPackage.isUnnamed()) {
            return true;
        }
        if (jPackage == this.m_aPckJavaLang) {
            return true;
        }
        if (jPackage == abstractJClass2._package()) {
            AbstractJClass abstractJClass4 = abstractJClass3.outer();
            if (abstractJClass4 == null) {
                return true;
            }
            AbstractJClass abstractJClass5 = abstractJClass4;
            abstractJClass4 = abstractJClass5.outer();
            while (abstractJClass4 != null) {
                abstractJClass5 = abstractJClass4;
                abstractJClass4 = abstractJClass5.outer();
            }
            return abstractJClass5 == abstractJClass2;
        }
        return false;
    }

    void write(@Nonnull JDefinedClass jDefinedClass) {
        this.m_aPckJavaLang = jDefinedClass.owner()._package("java.lang");
        this.m_eMode = EMode.COLLECTING;
        this.m_aCollectedReferences.clear();
        this.m_aImportedClasses.clear();
        this.declaration(jDefinedClass);
        this.m_aImportedClasses.add(jDefinedClass);
        for (NameUsage nameUsage : this.m_aCollectedReferences.values()) {
            if (!nameUsage.isAmbiguousIn(jDefinedClass) && !nameUsage.isVariableName()) {
                AbstractJClass abstractJClass = nameUsage.getSingleReferencedType();
                if (this._collectShouldBeImported(abstractJClass, jDefinedClass)) {
                    this.m_aImportedClasses.add(abstractJClass);
                    continue;
                }
                this._collectImportOuterClassIfCausesNoAmbiguities(abstractJClass, jDefinedClass);
                continue;
            }
            if (!nameUsage.isTypeName()) continue;
            for (AbstractJClass abstractJClass : nameUsage.getReferencedTypes()) {
                this._collectImportOuterClassIfCausesNoAmbiguities(abstractJClass, jDefinedClass);
            }
        }
        this.m_eMode = EMode.PRINTING;
        assert (jDefinedClass.parentContainer().isPackage()) : "this method is only for a pacakge-level class";
        JPackage jPackage = (JPackage)jDefinedClass.parentContainer();
        if (!jPackage.isUnnamed()) {
            this.newline().declaration(jPackage);
            this.newline();
        }
        boolean bl = false;
        for (AbstractJClass abstractJClass : this.m_aImportedClasses.getAllSorted()) {
            if (this._printIsImplicitlyImported(abstractJClass, jDefinedClass)) continue;
            this.print("import").print(abstractJClass.fullName()).print(';').newline();
            bl = true;
        }
        if (bl) {
            this.newline();
        }
        this.declaration(jDefinedClass);
    }

    public static boolean containsErrorTypes(@Nonnull JDefinedClass jDefinedClass) {
        JFormatter jFormatter = new JFormatter(NullWriter.getInstance());
        jFormatter.m_eMode = EMode.FIND_ERROR_TYPES;
        jFormatter.m_bContainsErrorTypes = false;
        jFormatter.declaration(jDefinedClass);
        return jFormatter.m_bContainsErrorTypes;
    }

    private final class ImportedClasses {
        private final Set<AbstractJClass> m_aClasses = new HashSet<AbstractJClass>();
        private final Set<String> m_aNames = new HashSet<String>();

        @Nonnull
        private AbstractJClass _getClassForImport(@Nonnull AbstractJClass abstractJClass) {
            AbstractJClass abstractJClass2 = abstractJClass;
            if (abstractJClass2 instanceof JAnonymousClass) {
                abstractJClass2 = ((JAnonymousClass)abstractJClass2).base();
            }
            if (abstractJClass2 instanceof JNarrowedClass) {
                abstractJClass2 = abstractJClass2.erasure();
            }
            return abstractJClass2;
        }

        public boolean add(@Nonnull AbstractJClass abstractJClass) {
            AbstractJClass abstractJClass2 = this._getClassForImport(abstractJClass);
            if (!this.m_aNames.add(abstractJClass2.name())) {
                return false;
            }
            return this.m_aClasses.add(abstractJClass2);
        }

        public boolean contains(@Nullable AbstractJClass abstractJClass) {
            AbstractJClass abstractJClass2 = this._getClassForImport(abstractJClass);
            return this.m_aClasses.contains(abstractJClass2);
        }

        public void clear() {
            this.m_aClasses.clear();
            this.m_aNames.clear();
        }

        @Nonnull
        public List<AbstractJClass> getAllSorted() {
            ArrayList<AbstractJClass> arrayList = new ArrayList<AbstractJClass>(this.m_aClasses);
            Collections.sort(arrayList, ClassNameComparator.getInstance());
            return arrayList;
        }
    }

    private static enum EMode {
        COLLECTING,
        PRINTING,
        FIND_ERROR_TYPES;

    }

    private final class NameUsage {
        private final String m_sName;
        private final List<AbstractJClass> m_aReferencedClasses = new ArrayList<AbstractJClass>();
        private boolean m_bIsVariableName;

        public NameUsage(String string) {
            this.m_sName = string;
        }

        public boolean isAmbiguousIn(JDefinedClass jDefinedClass) {
            if (this.m_aReferencedClasses.size() > 1) {
                return true;
            }
            if (this.m_bIsVariableName && !this.m_aReferencedClasses.isEmpty()) {
                return true;
            }
            if (this.m_aReferencedClasses.isEmpty()) {
                return false;
            }
            AbstractJClass abstractJClass = this.m_aReferencedClasses.get(0);
            if (abstractJClass instanceof JAnonymousClass) {
                abstractJClass = ((JAnonymousClass)abstractJClass).base();
            }
            if (abstractJClass._package() == JFormatter.this.m_aPckJavaLang) {
                for (JDefinedClass jDefinedClass2 : jDefinedClass._package().classes()) {
                    if (!jDefinedClass2.name().equals(abstractJClass.name())) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean addReferencedType(@Nonnull AbstractJClass abstractJClass) {
            if (this.m_aReferencedClasses.contains(abstractJClass)) {
                return false;
            }
            return this.m_aReferencedClasses.add(abstractJClass);
        }

        public boolean containsReferencedType(@Nullable AbstractJClass abstractJClass) {
            return this.m_aReferencedClasses.contains(abstractJClass);
        }

        @Nonnull
        public AbstractJClass getSingleReferencedType() {
            assert (this.m_aReferencedClasses.size() == 1);
            return this.m_aReferencedClasses.get(0);
        }

        @Nonnull
        public List<AbstractJClass> getReferencedTypes() {
            return this.m_aReferencedClasses;
        }

        public void setVariableName() {
            for (AbstractJClass abstractJClass : this.m_aReferencedClasses) {
                if (abstractJClass.outer() == null) continue;
                this.m_bIsVariableName = false;
                return;
            }
            this.m_bIsVariableName = true;
        }

        public boolean isVariableName() {
            return this.m_bIsVariableName;
        }

        public boolean isTypeName() {
            return !this.m_aReferencedClasses.isEmpty();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Usages[").append(this.m_sName).append("]");
            stringBuilder.append("; isVarName=").append(this.m_bIsVariableName);
            stringBuilder.append("; refedClasses=").append(this.m_aReferencedClasses);
            return stringBuilder.toString();
        }
    }
}

