/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJExpressionImpl;
import com.helger.jcodemodel.IJAnnotatable;
import com.helger.jcodemodel.IJAnnotationWriter;
import com.helger.jcodemodel.IJDeclaration;
import com.helger.jcodemodel.IJDocCommentable;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JDocComment;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.TypedAnnotationWriter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class JEnumConstant
extends AbstractJExpressionImpl
implements IJDeclaration,
IJAnnotatable,
IJDocCommentable {
    private final AbstractJClass m_aType;
    private final String m_sName;
    private JDocComment m_aJavaDoc;
    private List<JAnnotationUse> m_aAnnotations;
    private List<IJExpression> m_aArgs;

    protected JEnumConstant(@Nonnull AbstractJClass abstractJClass, @Nonnull String string) {
        this.m_aType = JCValueEnforcer.notNull(abstractJClass, "Type");
        this.m_sName = JCValueEnforcer.notNull(string, "Name");
    }

    @Nonnull
    public AbstractJClass type() {
        return this.m_aType;
    }

    @Nonnull
    public String name() {
        return this.m_sName;
    }

    @Nonnull
    public JEnumConstant arg(@Nonnull IJExpression iJExpression) {
        JCValueEnforcer.notNull(iJExpression, "Arg");
        if (this.m_aArgs == null) {
            this.m_aArgs = new ArrayList<IJExpression>();
        }
        this.m_aArgs.add(iJExpression);
        return this;
    }

    @Nonnull
    public List<IJExpression> args() {
        if (this.m_aArgs == null) {
            this.m_aArgs = new ArrayList<IJExpression>();
        }
        return Collections.unmodifiableList(this.m_aArgs);
    }

    public boolean hasArgs() {
        return this.m_aArgs != null && !this.m_aArgs.isEmpty();
    }

    @Nonnull
    public String getName() {
        return this.m_aType.fullName() + '.' + this.m_sName;
    }

    @Override
    @Nonnull
    public JDocComment javadoc() {
        if (this.m_aJavaDoc == null) {
            this.m_aJavaDoc = new JDocComment(this.m_aType.owner());
        }
        return this.m_aJavaDoc;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull AbstractJClass abstractJClass) {
        if (this.m_aAnnotations == null) {
            this.m_aAnnotations = new ArrayList<JAnnotationUse>();
        }
        JAnnotationUse jAnnotationUse = new JAnnotationUse(abstractJClass);
        this.m_aAnnotations.add(jAnnotationUse);
        return jAnnotationUse;
    }

    @Override
    @Nonnull
    public JAnnotationUse annotate(@Nonnull Class<? extends Annotation> clazz) {
        return this.annotate(this.m_aType.owner().ref(clazz));
    }

    @Override
    @Nonnull
    public <W extends IJAnnotationWriter<?>> W annotate2(@Nonnull Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    @Nonnull
    public Collection<JAnnotationUse> annotations() {
        if (this.m_aAnnotations == null) {
            this.m_aAnnotations = new ArrayList<JAnnotationUse>();
        }
        return Collections.unmodifiableList(this.m_aAnnotations);
    }

    @Override
    public void declare(@Nonnull JFormatter jFormatter) {
        if (this.m_aJavaDoc != null) {
            jFormatter.newline().generable(this.m_aJavaDoc);
        }
        if (this.m_aAnnotations != null) {
            for (JAnnotationUse jAnnotationUse : this.m_aAnnotations) {
                jFormatter.generable(jAnnotationUse).newline();
            }
        }
        jFormatter.id(this.m_sName);
        if (this.m_aArgs != null) {
            jFormatter.print('(').generable(this.m_aArgs).print(')');
        }
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        jFormatter.type(this.m_aType).print('.').print(this.m_sName);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JEnumConstant jEnumConstant = (JEnumConstant)object;
        return JCEqualsHelper.isEqual(this.m_aType.fullName(), jEnumConstant.m_aType.fullName()) && JCEqualsHelper.isEqual(this.m_sName, jEnumConstant.m_sName);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, this.m_aType.fullName(), this.m_sName);
    }
}

