/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.IJGenerable;
import com.helger.jcodemodel.IJOwned;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JCommentPart;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JVar;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JDocComment
extends JCommentPart
implements IJGenerable,
IJOwned {
    private static final String INDENT = " *     ";
    private static final long serialVersionUID = 1L;
    private final JCodeModel m_aOwner;
    private final Map<String, JCommentPart> m_aAtParams = new LinkedHashMap<String, JCommentPart>();
    private final Map<String, Map<String, String>> m_aAtXdoclets = new LinkedHashMap<String, Map<String, String>>();
    private final Map<AbstractJClass, JCommentPart> m_aAtThrows = new LinkedHashMap<AbstractJClass, JCommentPart>();
    private JCommentPart m_aAtReturn;
    private JCommentPart m_aAtAuthor;
    private JCommentPart m_aAtDeprecated;

    protected JDocComment(@Nonnull JCodeModel jCodeModel) {
        this.m_aOwner = JCValueEnforcer.notNull(jCodeModel, "Owner");
    }

    @Override
    @Nonnull
    public JCodeModel owner() {
        return this.m_aOwner;
    }

    @Override
    public JDocComment append(@Nullable Object object) {
        this.add(object);
        return this;
    }

    @Nonnull
    public JCommentPart addParam(String string) {
        JCommentPart jCommentPart = this.m_aAtParams.get(string);
        if (jCommentPart == null) {
            jCommentPart = new JCommentPart();
            this.m_aAtParams.put(string, jCommentPart);
        }
        return jCommentPart;
    }

    public JCommentPart addParam(@Nonnull JVar jVar) {
        return this.addParam(jVar.name());
    }

    @Nullable
    public JCommentPart removeParam(String string) {
        return this.m_aAtParams.remove(string);
    }

    @Nullable
    public JCommentPart removeParam(@Nonnull JVar jVar) {
        return this.removeParam(jVar.name());
    }

    public void removeAllParams() {
        this.m_aAtParams.clear();
    }

    @Nullable
    public JCommentPart getParam(@Nullable String string) {
        return this.m_aAtParams.get(string);
    }

    @Nullable
    public JCommentPart getParam(@Nonnull JVar jVar) {
        return this.getParam(jVar.name());
    }

    public JCommentPart addThrows(@Nonnull Class<? extends Throwable> clazz) {
        return this.addThrows(this.m_aOwner.ref(clazz));
    }

    public JCommentPart addThrows(AbstractJClass abstractJClass) {
        JCommentPart jCommentPart = this.m_aAtThrows.get(abstractJClass);
        if (jCommentPart == null) {
            jCommentPart = new JCommentPart();
            this.m_aAtThrows.put(abstractJClass, jCommentPart);
        }
        return jCommentPart;
    }

    @Nullable
    public JCommentPart removeThrows(@Nonnull Class<? extends Throwable> clazz) {
        return this.removeThrows(this.m_aOwner.ref(clazz));
    }

    @Nullable
    public JCommentPart removeThrows(AbstractJClass abstractJClass) {
        return this.m_aAtThrows.remove(abstractJClass);
    }

    public void removeAllThrows() {
        this.m_aAtThrows.clear();
    }

    @Nullable
    public JCommentPart getThrows(@Nonnull Class<? extends Throwable> clazz) {
        return this.getThrows(this.m_aOwner.ref(clazz));
    }

    @Nullable
    public JCommentPart getThrows(AbstractJClass abstractJClass) {
        return this.m_aAtThrows.get(abstractJClass);
    }

    @Nonnull
    public JCommentPart addReturn() {
        if (this.m_aAtReturn == null) {
            this.m_aAtReturn = new JCommentPart();
        }
        return this.m_aAtReturn;
    }

    public void removeReturn() {
        this.m_aAtReturn = null;
    }

    @Nonnull
    public JCommentPart addAuthor() {
        if (this.m_aAtAuthor == null) {
            this.m_aAtAuthor = new JCommentPart();
        }
        return this.m_aAtAuthor;
    }

    public void removeAuthor() {
        this.m_aAtAuthor = null;
    }

    @Nonnull
    public JCommentPart addDeprecated() {
        if (this.m_aAtDeprecated == null) {
            this.m_aAtDeprecated = new JCommentPart();
        }
        return this.m_aAtDeprecated;
    }

    public void removeDeprecated() {
        this.m_aAtDeprecated = null;
    }

    @Nonnull
    public Map<String, String> addXdoclet(String string) {
        Map<String, String> map = this.m_aAtXdoclets.get(string);
        if (map == null) {
            map = new LinkedHashMap<String, String>();
            this.m_aAtXdoclets.put(string, map);
        }
        return map;
    }

    @Nonnull
    public Map<String, String> addXdoclet(String string, Map<String, String> map) {
        Map<String, String> map2 = this.addXdoclet(string);
        map2.putAll(map);
        return map2;
    }

    @Nonnull
    public Map<String, String> addXdoclet(String string, String string2, String string3) {
        Map<String, String> map = this.addXdoclet(string);
        map.put(string2, string3);
        return map;
    }

    @Nullable
    public Map<String, String> removeXdoclet(String string) {
        return this.m_aAtXdoclets.remove(string);
    }

    public void removeAllXdoclets() {
        this.m_aAtXdoclets.clear();
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        jFormatter.print("/**").newline();
        this.format(jFormatter, " * ");
        jFormatter.print(" * ").newline();
        for (Map.Entry<String, JCommentPart> entry : this.m_aAtParams.entrySet()) {
            jFormatter.print(" * @param ").print(entry.getKey()).newline();
            entry.getValue().format(jFormatter, INDENT);
        }
        if (this.m_aAtReturn != null) {
            jFormatter.print(" * @return").newline();
            this.m_aAtReturn.format(jFormatter, INDENT);
        }
        if (this.m_aAtAuthor != null) {
            jFormatter.print(" * @author").newline();
            this.m_aAtAuthor.format(jFormatter, INDENT);
        }
        for (Map.Entry<Object, JCommentPart> entry : this.m_aAtThrows.entrySet()) {
            jFormatter.print(" * @throws ").type((AbstractJClass)entry.getKey()).newline();
            entry.getValue().format(jFormatter, INDENT);
        }
        if (this.m_aAtDeprecated != null) {
            jFormatter.print(" * @deprecated").newline();
            this.m_aAtDeprecated.format(jFormatter, INDENT);
        }
        for (Map.Entry<Object, Object> entry : this.m_aAtXdoclets.entrySet()) {
            jFormatter.print(" * @").print((String)entry.getKey());
            if (entry.getValue() != null) {
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    jFormatter.print(" ").print((String)entry2.getKey()).print("= \"").print((String)entry2.getValue()).print("\"");
                }
            }
            jFormatter.newline();
        }
        jFormatter.print(" */").newline();
    }
}

