/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJExpressionImpl;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.util.JCEqualsHelper;
import com.helger.jcodemodel.util.JCHashCodeGenerator;
import javax.annotation.Nonnull;

public class JAtomFloat
extends AbstractJExpressionImpl {
    public static final String JAVA_LANG_FLOAT_NEGATIVE_INFINITY = "java.lang.Float.NEGATIVE_INFINITY";
    public static final String JAVA_LANG_FLOAT_POSITIVE_INFINITY = "java.lang.Float.POSITIVE_INFINITY";
    public static final String JAVA_LANG_FLOAT_NAN = "java.lang.Float.NaN";
    public static final String SUFFIX_FLOAT = "F";
    private final float _what;

    protected JAtomFloat(float f) {
        this._what = f;
    }

    public float what() {
        return this._what;
    }

    @Override
    public void generate(@Nonnull JFormatter jFormatter) {
        if (this._what == Float.NEGATIVE_INFINITY) {
            jFormatter.print(JAVA_LANG_FLOAT_NEGATIVE_INFINITY);
        } else if (this._what == Float.POSITIVE_INFINITY) {
            jFormatter.print(JAVA_LANG_FLOAT_POSITIVE_INFINITY);
        } else if (Float.isNaN(this._what)) {
            jFormatter.print(JAVA_LANG_FLOAT_NAN);
        } else {
            jFormatter.print(Float.toString(this._what) + SUFFIX_FLOAT);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JAtomFloat jAtomFloat = (JAtomFloat)object;
        return JCEqualsHelper.isEqual(this._what, jAtomFloat._what);
    }

    public int hashCode() {
        return JCHashCodeGenerator.getHashCode(this, Float.valueOf(this._what));
    }
}

