/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jcodemodel;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JFormatter;
import com.helger.jcodemodel.JPackage;
import com.helger.jcodemodel.JTypeVar;
import com.helger.jcodemodel.util.JCValueEnforcer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class JArrayClass
extends AbstractJClass {
    private final AbstractJType m_aComponentType;

    protected JArrayClass(@Nonnull JCodeModel jCodeModel, @Nonnull AbstractJType abstractJType) {
        super(jCodeModel);
        this.m_aComponentType = JCValueEnforcer.notNull(abstractJType, "ComponentType");
    }

    @Override
    @Nonnull
    public String name() {
        return this.m_aComponentType.name() + "[]";
    }

    @Override
    @Nonnull
    public String fullName() {
        return this.m_aComponentType.fullName() + "[]";
    }

    @Override
    @Nonnull
    public String binaryName() {
        return this.m_aComponentType.binaryName() + "[]";
    }

    @Override
    public void generate(JFormatter jFormatter) {
        jFormatter.generable(this.m_aComponentType).print("[]");
    }

    @Override
    @Nonnull
    public JPackage _package() {
        return this.owner().rootPackage();
    }

    @Override
    public AbstractJClass _extends() {
        return this.owner().ref(Object.class);
    }

    @Override
    public Iterator<AbstractJClass> _implements() {
        return Collections.emptyList().iterator();
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public AbstractJType elementType() {
        return this.m_aComponentType;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JArrayClass jArrayClass = (JArrayClass)object;
        return this.m_aComponentType.equals(jArrayClass.m_aComponentType);
    }

    public int hashCode() {
        return this.m_aComponentType.hashCode();
    }

    @Override
    @Nonnull
    protected AbstractJClass substituteParams(JTypeVar[] jTypeVarArray, List<? extends AbstractJClass> list) {
        if (this.m_aComponentType.isPrimitive()) {
            return this;
        }
        AbstractJClass abstractJClass = ((AbstractJClass)this.m_aComponentType).substituteParams(jTypeVarArray, list);
        if (abstractJClass == this.m_aComponentType) {
            return this;
        }
        return new JArrayClass(this.owner(), abstractJClass);
    }
}

