/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.jsfr.json.path;

import com.hazelcast.org.jsfr.json.exception.JsonPathCompilerException;
import com.hazelcast.org.jsfr.json.filter.JsonPathFilter;
import com.hazelcast.org.jsfr.json.path.ArrayIndex;
import com.hazelcast.org.jsfr.json.path.ArrayIndexes;
import com.hazelcast.org.jsfr.json.path.ArrayWildcard;
import com.hazelcast.org.jsfr.json.path.ChildNode;
import com.hazelcast.org.jsfr.json.path.ChildrenNode;
import com.hazelcast.org.jsfr.json.path.DeepScan;
import com.hazelcast.org.jsfr.json.path.FilterRoot;
import com.hazelcast.org.jsfr.json.path.PathOperator;
import com.hazelcast.org.jsfr.json.path.Root;
import com.hazelcast.org.jsfr.json.path.SyntaxMode;
import com.hazelcast.org.jsfr.json.path.Wildcard;
import com.hazelcast.org.jsfr.json.resolver.DocumentResolver;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

public class JsonPath
implements Iterable<PathOperator> {
    private static final int JSON_PATH_INITIAL_CAPACITY = 20;
    protected PathOperator[] operators = new PathOperator[20];
    protected int size;
    private boolean definite = true;

    protected JsonPath() {
        this(false);
    }

    protected JsonPath(boolean filterPath) {
        this.operators[0] = filterPath ? FilterRoot.instance() : Root.instance();
        this.size = 1;
    }

    @Override
    public Iterator<PathOperator> iterator() {
        return new JsonPathIterator();
    }

    public Object resolve(Object document, DocumentResolver resolver) {
        if (!this.isDefinite()) {
            throw new IllegalArgumentException("Indefinite JsonPath is not supported.");
        }
        Object current = document;
        for (PathOperator pathOperator : this) {
            if (current == null) {
                return null;
            }
            current = pathOperator.resolve(current, resolver);
        }
        return current;
    }

    public boolean match(JsonPath jsonPath) {
        int p2;
        int p1 = this.size - 1;
        for (p2 = jsonPath.size - 1; p1 >= 0 && p2 >= 0; --p1, --p2) {
            if (this.get(p1).match(jsonPath.get(p2))) continue;
            return false;
        }
        return p1 == -1 && p2 == -1;
    }

    public boolean matchWithDeepScan(JsonPath jsonPath) {
        int pointer1 = this.size - 1;
        int pointer2 = jsonPath.size - 1;
        if (!this.get(pointer1).match(jsonPath.get(pointer2))) {
            return false;
        }
        --pointer1;
        --pointer2;
        while (pointer1 >= 0) {
            if (pointer2 < 0) {
                return false;
            }
            PathOperator o1 = this.get(pointer1--);
            PathOperator o2 = jsonPath.get(pointer2--);
            if (o1.getType() == PathOperator.Type.DEEP_SCAN) {
                int offset2;
                int blockHead = this.indexOfPreviousDeepScanOrRoot(this, pointer1);
                int blockSize = pointer1 - blockHead;
                for (offset2 = pointer2 - blockSize + 2; offset2 > 0 && !this.matchPathBlock(this, blockHead + 1, jsonPath, offset2, blockSize); --offset2) {
                }
                pointer1 = blockHead;
                pointer2 = offset2 - 1;
                continue;
            }
            if (o1.match(o2)) continue;
            return false;
        }
        return pointer2 < 0;
    }

    private boolean matchPathBlock(JsonPath path1, int offset1, JsonPath path2, int offset2, int blockSize) {
        for (int i = 0; i < blockSize; ++i) {
            if (path1.get(offset1 + i).match(path2.get(offset2 + i))) continue;
            return false;
        }
        return true;
    }

    private int indexOfPreviousDeepScanOrRoot(JsonPath path, int from) {
        int pointer;
        for (pointer = from - 1; pointer > 0; --pointer) {
            if (path.get(pointer).getType() != PathOperator.Type.DEEP_SCAN) continue;
            return pointer;
        }
        return pointer;
    }

    public boolean matchFilterPath(JsonPath jsonPath) {
        int pointer2;
        int pointer1 = this.size - 1;
        for (pointer2 = jsonPath.size - 1; pointer1 >= 0 && pointer2 >= 0; --pointer1, --pointer2) {
            PathOperator o1 = this.get(pointer1);
            PathOperator o2 = jsonPath.get(pointer2);
            if (o1.getType() == PathOperator.Type.FILTER_ROOT) {
                return true;
            }
            if (o1.match(o2)) continue;
            return false;
        }
        return pointer2 < 0;
    }

    public JsonPath derivePath(int depth) {
        JsonPath newPath = new JsonPath();
        newPath.size = depth;
        newPath.operators = this.operators;
        return newPath;
    }

    public PathOperator get(int i) {
        return this.operators[i];
    }

    public PathOperator peek() {
        return this.operators[this.size - 1];
    }

    protected void push(PathOperator operator) {
        this.ensureCapacity(this.size + 1);
        this.operators[this.size++] = operator;
    }

    private void ensureCapacity(int capacity) {
        if (this.operators.length < capacity) {
            PathOperator[] newOperators = new PathOperator[this.operators.length * 2];
            System.arraycopy(this.operators, 0, newOperators, 0, this.operators.length);
            this.operators = newOperators;
        }
    }

    protected void pop() {
        --this.size;
    }

    public int pathDepth() {
        return this.size;
    }

    public void clear() {
        this.operators = null;
    }

    public static int minimumPathDepth(JsonPath path) {
        if (path.definite) {
            return path.pathDepth();
        }
        int minimumDepth = 0;
        for (PathOperator operator : path) {
            if (operator.getType() == PathOperator.Type.DEEP_SCAN) continue;
            ++minimumDepth;
        }
        return minimumDepth;
    }

    public boolean isDefinite() {
        return this.definite;
    }

    public boolean checkDefinite() {
        for (PathOperator operator : this) {
            if (operator.getType() != PathOperator.Type.DEEP_SCAN) continue;
            this.definite = false;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (PathOperator operator : this) {
            sb.append(operator);
        }
        return sb.toString();
    }

    public static class Builder {
        private JsonPath jsonPath;

        public static Builder start(SyntaxMode mode) {
            if (mode == SyntaxMode.STRICT) {
                throw new JsonPathCompilerException("Strict SQL/JSON path mode not supported");
            }
            Builder builder = new Builder();
            builder.jsonPath = new JsonPath();
            return builder;
        }

        public static Builder startFilterPath() {
            Builder builder = new Builder();
            builder.jsonPath = new JsonPath(true);
            return builder;
        }

        public Builder child(String key) {
            this.jsonPath.push(new ChildNode(key));
            return this;
        }

        public Builder children(String ... children) {
            this.jsonPath.push(new ChildrenNode(new HashSet<String>(Arrays.asList(children))));
            return this;
        }

        public Builder anyChild() {
            this.jsonPath.push(Wildcard.SINGLETON);
            return this;
        }

        public Builder array(String key, JsonPathFilter jsonPathFilter, int index) {
            this.jsonPath.push(new ArrayIndex(key, jsonPathFilter, index));
            return this;
        }

        public Builder array(String key, JsonPathFilter jsonPathFilter, Set<Integer> indexes, TreeMap<Integer, Integer> ranges) {
            this.jsonPath.push(new ArrayIndexes(key, jsonPathFilter, indexes, ranges));
            return this;
        }

        public Builder arrayWildcard(String key, JsonPathFilter jsonPathFilter) {
            this.jsonPath.push(new ArrayWildcard(key, jsonPathFilter));
            return this;
        }

        public Builder scan() {
            this.jsonPath.definite = false;
            if (this.jsonPath.peek().getType() != PathOperator.Type.DEEP_SCAN) {
                this.jsonPath.push(DeepScan.SINGLETON);
            }
            return this;
        }

        public Builder any() {
            this.jsonPath.push(Wildcard.SINGLETON);
            return this;
        }

        public JsonPath build() {
            if (this.jsonPath.peek().getType() == PathOperator.Type.DEEP_SCAN) {
                throw new IllegalStateException("deep-scan shouldn't be the last operator.");
            }
            return this.jsonPath;
        }
    }

    private class JsonPathIterator
    implements Iterator<PathOperator> {
        private int current;

        private JsonPathIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < JsonPath.this.size;
        }

        @Override
        public PathOperator next() {
            if (this.current >= JsonPath.this.size) {
                throw new NoSuchElementException();
            }
            return JsonPath.this.operators[this.current++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("unsupported");
        }
    }
}

