/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.jsfr.json;

import com.hazelcast.org.jsfr.json.BufferedListener;
import com.hazelcast.org.jsfr.json.JsonPathListener;
import com.hazelcast.org.jsfr.json.JsonPosition;
import com.hazelcast.org.jsfr.json.JsonSaxHandler;
import com.hazelcast.org.jsfr.json.PrimitiveHolder;
import com.hazelcast.org.jsfr.json.SurfingConfiguration;
import com.hazelcast.org.jsfr.json.filter.JsonPathFilter;
import java.util.ArrayList;
import java.util.Collection;

public class JsonFilterVerifier
implements JsonSaxHandler {
    private final SurfingConfiguration config;
    private final JsonPathFilter jsonPathFilter;
    private final Collection<BufferedListener> bufferedListeners;
    private final JsonFilterVerifier dependency;
    private final JsonPosition currentPosition;
    private boolean verified;
    private int stackDepth;

    public JsonFilterVerifier(JsonPosition currentPosition, SurfingConfiguration config, JsonPathFilter jsonPathFilter, JsonFilterVerifier dependency) {
        this.currentPosition = currentPosition;
        this.config = config;
        this.jsonPathFilter = jsonPathFilter;
        this.dependency = dependency;
        this.bufferedListeners = new ArrayList<BufferedListener>();
    }

    public JsonPathListener addListener(JsonPathListener listener) {
        BufferedListener newListener = new BufferedListener(this.config, listener);
        this.bufferedListeners.add(newListener);
        return newListener;
    }

    private void invokeBuffer() {
        if (this.dependency != null) {
            this.dependency.bufferedListeners.addAll(this.bufferedListeners);
        } else {
            for (BufferedListener buffer : this.bufferedListeners) {
                buffer.invokeBufferedValue();
            }
        }
    }

    @Override
    public boolean startJSON() {
        return true;
    }

    @Override
    public boolean endJSON() {
        return false;
    }

    @Override
    public boolean startObject() {
        ++this.stackDepth;
        return true;
    }

    @Override
    public boolean startObjectEntry(String key) {
        if (!this.verified && this.jsonPathFilter.apply(this.currentPosition, null, this.config.getJsonProvider())) {
            this.verified = true;
        }
        return true;
    }

    @Override
    public boolean endObject() {
        return this.endObjectOrArray();
    }

    @Override
    public boolean startArray() {
        ++this.stackDepth;
        return true;
    }

    @Override
    public boolean endArray() {
        return this.endObjectOrArray();
    }

    private boolean endObjectOrArray() {
        --this.stackDepth;
        if (this.stackDepth == 0) {
            if (this.verified) {
                this.invokeBuffer();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean primitive(PrimitiveHolder primitiveHolder) {
        if (!this.verified && this.jsonPathFilter.apply(this.currentPosition, primitiveHolder, this.config.getJsonProvider())) {
            this.verified = true;
        }
        if (this.currentPosition.isInsideArray()) {
            if (this.verified) {
                this.invokeBuffer();
            }
            return false;
        }
        return true;
    }
}

