/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.validate.implicit;

import com.hazelcast.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlInsert;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.org.apache.calcite.sql.SqlUpdate;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.SqlWith;
import com.hazelcast.org.apache.calcite.sql.fun.SqlCase;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandMetadata;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.sql.validate.SqlNonNullableAccessors;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.sql.validate.implicit.AbstractTypeCoercion;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TypeCoercionImpl
extends AbstractTypeCoercion {
    public TypeCoercionImpl(RelDataTypeFactory typeFactory, SqlValidator validator) {
        super(typeFactory, validator);
    }

    @Override
    public boolean rowTypeCoercion(@Nullable SqlValidatorScope scope, SqlNode query, int columnIndex, RelDataType targetType) {
        SqlKind kind = query.getKind();
        switch (kind) {
            case SELECT: {
                SqlSelect selectNode = (SqlSelect)query;
                SqlValidatorScope scope1 = this.validator.getSelectScope(selectNode);
                if (!this.coerceColumnType(scope1, SqlNonNullableAccessors.getSelectList(selectNode), columnIndex, targetType)) {
                    return false;
                }
                this.updateInferredColumnType(scope1, query, columnIndex, targetType);
                return true;
            }
            case VALUES: {
                for (SqlNode rowConstructor : ((SqlCall)query).getOperandList()) {
                    if (this.coerceOperandType(scope, (SqlCall)rowConstructor, columnIndex, targetType)) continue;
                    return false;
                }
                this.updateInferredColumnType(Objects.requireNonNull(scope, "scope"), query, columnIndex, targetType);
                return true;
            }
            case WITH: {
                SqlNode body = ((SqlWith)query).body;
                return this.rowTypeCoercion(this.validator.getOverScope(query), body, columnIndex, targetType);
            }
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                boolean coerced;
                SqlCall operand0 = (SqlCall)((SqlCall)query).operand(0);
                SqlCall operand1 = (SqlCall)((SqlCall)query).operand(1);
                boolean bl = coerced = this.rowTypeCoercion(scope, operand0, columnIndex, targetType) && this.rowTypeCoercion(scope, operand1, columnIndex, targetType);
                if (coerced) {
                    this.updateInferredColumnType(Objects.requireNonNull(scope, "scope"), query, columnIndex, targetType);
                }
                return coerced;
            }
        }
        return false;
    }

    @Override
    public boolean binaryArithmeticCoercion(SqlCallBinding binding) {
        SqlOperator operator = binding.getOperator();
        SqlKind kind = operator.getKind();
        boolean coerced = false;
        if (binding.getOperandCount() == 2) {
            RelDataType type1 = binding.getOperandType(0);
            RelDataType type2 = binding.getOperandType(1);
            if ((kind == SqlKind.PLUS || kind == SqlKind.MINUS) && (SqlTypeUtil.isInterval(type1) || SqlTypeUtil.isInterval(type2))) {
                return false;
            }
            if (kind.belongsTo(SqlKind.BINARY_ARITHMETIC)) {
                coerced = this.binaryArithmeticWithStrings(binding, type1, type2);
            }
        }
        return coerced;
    }

    protected boolean binaryArithmeticWithStrings(SqlCallBinding binding, RelDataType left, RelDataType right) {
        if (SqlTypeUtil.isString(left) && SqlTypeUtil.isNumeric(right)) {
            if (SqlTypeUtil.isDecimal(right)) {
                right = SqlTypeUtil.getMaxPrecisionScaleDecimal(this.factory);
            }
            return this.coerceOperandType(binding.getScope(), binding.getCall(), 0, right);
        }
        if (SqlTypeUtil.isNumeric(left) && SqlTypeUtil.isString(right)) {
            if (SqlTypeUtil.isDecimal(left)) {
                left = SqlTypeUtil.getMaxPrecisionScaleDecimal(this.factory);
            }
            return this.coerceOperandType(binding.getScope(), binding.getCall(), 1, left);
        }
        return false;
    }

    @Override
    public boolean binaryComparisonCoercion(SqlCallBinding binding) {
        SqlOperator operator = binding.getOperator();
        SqlKind kind = operator.getKind();
        int operandCnt = binding.getOperandCount();
        boolean coerced = false;
        if (operandCnt == 2) {
            RelDataType commonType;
            RelDataType type1 = binding.getOperandType(0);
            RelDataType type2 = binding.getOperandType(1);
            if (kind.belongsTo(SqlKind.BINARY_EQUALITY)) {
                coerced = this.dateTimeStringEquality(binding, type1, type2) || coerced;
                boolean bl = coerced = this.booleanEquality(binding, type1, type2) || coerced;
            }
            if (kind.belongsTo(SqlKind.BINARY_COMPARISON) && null != (commonType = this.commonTypeForBinaryComparison(type1, type2))) {
                coerced = this.coerceOperandsType(binding.getScope(), binding.getCall(), commonType);
            }
        }
        if (kind == SqlKind.BETWEEN) {
            List<RelDataType> operandTypes = Util.range(operandCnt).stream().map(binding::getOperandType).collect(Collectors.toList());
            RelDataType commonType = this.commonTypeForComparison(operandTypes);
            if (null != commonType) {
                coerced = this.coerceOperandsType(binding.getScope(), binding.getCall(), commonType);
            }
        }
        return coerced;
    }

    protected @Nullable RelDataType commonTypeForComparison(List<RelDataType> dataTypes) {
        assert (dataTypes.size() > 2);
        RelDataType type1 = dataTypes.get(0);
        RelDataType type2 = dataTypes.get(1);
        boolean allWithSameName = SqlTypeUtil.sameNamedType(type1, type2);
        for (int i = 2; i < dataTypes.size() && allWithSameName; ++i) {
            allWithSameName = SqlTypeUtil.sameNamedType(dataTypes.get(i - 1), dataTypes.get(i));
        }
        if (allWithSameName) {
            return null;
        }
        RelDataType commonType = SqlTypeUtil.sameNamedType(type1, type2) ? this.factory.leastRestrictive(Arrays.asList(type1, type2)) : this.commonTypeForBinaryComparison(type1, type2);
        for (int i = 2; i < dataTypes.size() && commonType != null; ++i) {
            commonType = SqlTypeUtil.sameNamedType(commonType, dataTypes.get(i)) ? this.factory.leastRestrictive(Arrays.asList(commonType, dataTypes.get(i))) : this.commonTypeForBinaryComparison(commonType, dataTypes.get(i));
        }
        return commonType;
    }

    protected boolean dateTimeStringEquality(SqlCallBinding binding, RelDataType left, RelDataType right) {
        if (SqlTypeUtil.isCharacter(left) && SqlTypeUtil.isDatetime(right)) {
            return this.coerceOperandType(binding.getScope(), binding.getCall(), 0, right);
        }
        if (SqlTypeUtil.isCharacter(right) && SqlTypeUtil.isDatetime(left)) {
            return this.coerceOperandType(binding.getScope(), binding.getCall(), 1, left);
        }
        return false;
    }

    protected boolean booleanEquality(SqlCallBinding binding, RelDataType left, RelDataType right) {
        SqlNode lNode = binding.operand(0);
        SqlNode rNode = binding.operand(1);
        if (SqlTypeUtil.isNumeric(left) && !SqlUtil.isNullLiteral(lNode, false) && SqlTypeUtil.isBoolean(right)) {
            if (lNode.getKind() == SqlKind.LITERAL) {
                BigDecimal val = ((SqlLiteral)lNode).getValueAs(BigDecimal.class);
                if (val.compareTo(BigDecimal.ONE) == 0) {
                    SqlLiteral lNode1 = SqlLiteral.createBoolean(true, SqlParserPos.ZERO);
                    binding.getCall().setOperand(0, lNode1);
                    return true;
                }
                SqlLiteral lNode1 = SqlLiteral.createBoolean(false, SqlParserPos.ZERO);
                binding.getCall().setOperand(0, lNode1);
                return true;
            }
            return this.coerceOperandType(binding.getScope(), binding.getCall(), 1, left);
        }
        if (SqlTypeUtil.isNumeric(right) && !SqlUtil.isNullLiteral(rNode, false) && SqlTypeUtil.isBoolean(left)) {
            if (rNode.getKind() == SqlKind.LITERAL) {
                BigDecimal val = ((SqlLiteral)rNode).getValueAs(BigDecimal.class);
                if (val.compareTo(BigDecimal.ONE) == 0) {
                    SqlLiteral rNode1 = SqlLiteral.createBoolean(true, SqlParserPos.ZERO);
                    binding.getCall().setOperand(1, rNode1);
                    return true;
                }
                SqlLiteral rNode1 = SqlLiteral.createBoolean(false, SqlParserPos.ZERO);
                binding.getCall().setOperand(1, rNode1);
                return true;
            }
            return this.coerceOperandType(binding.getScope(), binding.getCall(), 0, right);
        }
        return false;
    }

    @Override
    public boolean caseWhenCoercion(SqlCallBinding callBinding) {
        SqlCase caseCall = (SqlCase)callBinding.getCall();
        SqlNodeList thenList = caseCall.getThenOperands();
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        SqlValidatorScope scope = SqlNonNullableAccessors.getScope(callBinding);
        for (SqlNode node : thenList) {
            argTypes.add(this.validator.deriveType(scope, node));
        }
        SqlNode elseOp = Objects.requireNonNull(caseCall.getElseOperand(), () -> "getElseOperand() is null for " + caseCall);
        RelDataType elseOpType = this.validator.deriveType(scope, elseOp);
        argTypes.add(elseOpType);
        RelDataType widerType = this.getWiderTypeFor(argTypes, true);
        if (null != widerType) {
            boolean coerced = false;
            for (int i = 0; i < thenList.size(); ++i) {
                coerced = this.coerceColumnType(scope, thenList, i, widerType) || coerced;
            }
            if (this.needToCast(scope, elseOp, widerType)) {
                coerced = this.coerceOperandType(scope, caseCall, 3, widerType) || coerced;
            }
            return coerced;
        }
        return false;
    }

    @Override
    public boolean inOperationCoercion(SqlCallBinding binding) {
        SqlOperator operator = binding.getOperator();
        if (operator.getKind() == SqlKind.IN || operator.getKind() == SqlKind.NOT_IN) {
            int i;
            assert (binding.getOperandCount() == 2);
            RelDataType type1 = binding.getOperandType(0);
            RelDataType type2 = binding.getOperandType(1);
            SqlNode node1 = binding.operand(0);
            SqlNode node2 = binding.operand(1);
            SqlValidatorScope scope = binding.getScope();
            if (type1.isStruct() && type2.isStruct() && type1.getFieldCount() != type2.getFieldCount()) {
                return false;
            }
            int colCount = type1.isStruct() ? type1.getFieldCount() : 1;
            final RelDataType[] argTypes = new RelDataType[]{type1, type2};
            boolean coerced = false;
            ArrayList<RelDataType> widenTypes = new ArrayList<RelDataType>();
            for (i = 0; i < colCount; ++i) {
                final int i2 = i;
                AbstractList<RelDataType> columnIthTypes = new AbstractList<RelDataType>(){

                    @Override
                    public RelDataType get(int index) {
                        return argTypes[index].isStruct() ? argTypes[index].getFieldList().get(i2).getType() : argTypes[index];
                    }

                    @Override
                    public int size() {
                        return argTypes.length;
                    }
                };
                RelDataType widenType = this.commonTypeForBinaryComparison((RelDataType)columnIthTypes.get(0), (RelDataType)columnIthTypes.get(1));
                if (widenType == null) {
                    widenType = this.getTightestCommonType((RelDataType)columnIthTypes.get(0), (RelDataType)columnIthTypes.get(1));
                }
                if (widenType == null) {
                    return false;
                }
                widenTypes.add(widenType);
            }
            assert (widenTypes.size() == colCount);
            for (i = 0; i < widenTypes.size(); ++i) {
                RelDataType desired = (RelDataType)widenTypes.get(i);
                if (node1.getKind() == SqlKind.ROW) {
                    assert (node1 instanceof SqlCall);
                    if (this.coerceOperandType(scope, (SqlCall)node1, i, desired)) {
                        this.updateInferredColumnType(Objects.requireNonNull(scope, "scope"), node1, i, (RelDataType)widenTypes.get(i));
                        coerced = true;
                    }
                } else {
                    boolean bl = coerced = this.coerceOperandType(scope, binding.getCall(), 0, desired) || coerced;
                }
                if (node2 instanceof SqlNodeList) {
                    SqlNodeList node3 = (SqlNodeList)node2;
                    boolean listCoerced = false;
                    if (type2.isStruct()) {
                        for (SqlNode node : (SqlNodeList)node2) {
                            assert (node instanceof SqlCall);
                            listCoerced = this.coerceOperandType(scope, (SqlCall)node, i, desired) || listCoerced;
                        }
                        if (listCoerced) {
                            this.updateInferredColumnType(Objects.requireNonNull(scope, "scope"), node2, i, desired);
                        }
                    } else {
                        for (int j = 0; j < ((SqlNodeList)node2).size(); ++j) {
                            listCoerced = this.coerceColumnType(scope, node3, j, desired) || listCoerced;
                        }
                        if (listCoerced) {
                            this.updateInferredType(node2, desired);
                        }
                    }
                    coerced = coerced || listCoerced;
                    continue;
                }
                SqlValidatorScope scope1 = node2 instanceof SqlSelect ? this.validator.getSelectScope((SqlSelect)node2) : scope;
                coerced = this.rowTypeCoercion(scope1, node2, i, desired) || coerced;
            }
            return coerced;
        }
        return false;
    }

    @Override
    public boolean builtinFunctionCoercion(SqlCallBinding binding, List<RelDataType> operandTypes, List<SqlTypeFamily> expectedFamilies) {
        assert (binding.getOperandCount() == operandTypes.size());
        if (!this.canImplicitTypeCast(operandTypes, expectedFamilies)) {
            return false;
        }
        boolean coerced = false;
        for (int i = 0; i < operandTypes.size(); ++i) {
            RelDataType implicitType = this.implicitCast(operandTypes.get(i), expectedFamilies.get(i));
            coerced = null != implicitType && operandTypes.get(i) != implicitType && this.coerceOperandType(binding.getScope(), binding.getCall(), i, implicitType) || coerced;
        }
        return coerced;
    }

    @Override
    public boolean userDefinedFunctionCoercion(SqlValidatorScope scope, SqlCall call, SqlFunction function) {
        SqlOperandMetadata operandMetadata = Objects.requireNonNull((SqlOperandMetadata)function.getOperandTypeChecker(), () -> "getOperandTypeChecker is not defined for " + function);
        List<RelDataType> paramTypes = operandMetadata.paramTypes(scope.getValidator().getTypeFactory());
        boolean coerced = false;
        for (int i = 0; i < call.operandCount(); ++i) {
            Object operand = call.operand(i);
            if (((SqlNode)operand).getKind() == SqlKind.ARGUMENT_ASSIGNMENT) {
                List<SqlNode> operandList = ((SqlCall)operand).getOperandList();
                String name = ((SqlIdentifier)operandList.get(1)).getSimple();
                List<String> paramNames = operandMetadata.paramNames();
                int formalIndex = paramNames.indexOf(name);
                if (formalIndex < 0) {
                    return false;
                }
                coerced = this.coerceOperandType(scope, (SqlCall)operand, 0, paramTypes.get(formalIndex)) || coerced;
                continue;
            }
            coerced = this.coerceOperandType(scope, call, i, paramTypes.get(i)) || coerced;
        }
        return coerced;
    }

    @Override
    public boolean querySourceCoercion(@Nullable SqlValidatorScope scope, RelDataType sourceRowType, RelDataType targetRowType, SqlNode query) {
        RelDataType targetType;
        List<RelDataTypeField> sourceFields = sourceRowType.getFieldList();
        List<RelDataTypeField> targetFields = targetRowType.getFieldList();
        int sourceCount = sourceFields.size();
        for (int i = 0; i < sourceCount; ++i) {
            RelDataType sourceType = sourceFields.get(i).getType();
            targetType = targetFields.get(i).getType();
            if (SqlTypeUtil.equalSansNullability(this.validator.getTypeFactory(), sourceType, targetType) || SqlTypeUtil.canCastFrom(targetType, sourceType, true)) continue;
            return false;
        }
        boolean coerced = false;
        for (int i = 0; i < sourceFields.size(); ++i) {
            targetType = targetFields.get(i).getType();
            coerced = this.coerceSourceRowType(scope, query, i, targetType) || coerced;
        }
        return coerced;
    }

    private boolean coerceSourceRowType(@Nullable SqlValidatorScope sourceScope, SqlNode query, int columnIndex, RelDataType targetType) {
        switch (query.getKind()) {
            case INSERT: {
                SqlInsert insert = (SqlInsert)query;
                return this.coerceSourceRowType(sourceScope, insert.getSource(), columnIndex, targetType);
            }
            case UPDATE: {
                SqlUpdate update = (SqlUpdate)query;
                SqlNodeList sourceExpressionList = update.getSourceExpressionList();
                if (sourceExpressionList != null) {
                    return this.coerceColumnType(sourceScope, sourceExpressionList, columnIndex, targetType);
                }
                return this.coerceSourceRowType(sourceScope, Nullness.castNonNull(update.getSourceSelect()), columnIndex, targetType);
            }
        }
        return this.rowTypeCoercion(sourceScope, query, columnIndex, targetType);
    }
}

