/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.util;

import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorTable;
import com.hazelcast.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.org.apache.calcite.sql.validate.SqlNameMatcher;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.List;

public class ListSqlOperatorTable
implements SqlOperatorTable {
    private final List<SqlOperator> operatorList;

    public ListSqlOperatorTable() {
        this(new ArrayList<SqlOperator>());
    }

    public ListSqlOperatorTable(List<SqlOperator> operatorList) {
        this.operatorList = operatorList;
    }

    public void add(SqlOperator op) {
        this.operatorList.add(op);
    }

    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, @Nullable SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        for (SqlOperator operator : this.operatorList) {
            if (operator.getSyntax().family != syntax || !opName.isSimple() || !nameMatcher.matches(operator.getName(), opName.getSimple()) || category != null && category != ListSqlOperatorTable.category(operator) && !category.isUserDefinedNotSpecificFunction()) continue;
            operatorList.add(operator);
        }
    }

    protected static SqlFunctionCategory category(SqlOperator operator) {
        if (operator instanceof SqlFunction) {
            return ((SqlFunction)operator).getFunctionType();
        }
        return SqlFunctionCategory.SYSTEM;
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return this.operatorList;
    }
}

