/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.type;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFamily;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import com.hazelcast.org.apache.calcite.sql.type.AbstractSqlType;
import com.hazelcast.org.apache.calcite.sql.type.NonNullableAccessors;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import java.util.Objects;

public class ArraySqlType
extends AbstractSqlType {
    private final RelDataType elementType;

    public ArraySqlType(RelDataType elementType, boolean isNullable) {
        super(SqlTypeName.ARRAY, isNullable, null);
        this.elementType = Objects.requireNonNull(elementType, "elementType");
        this.computeDigest();
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        if (withDetail) {
            sb.append(this.elementType.getFullTypeString());
        } else {
            sb.append(this.elementType.toString());
        }
        sb.append(" ARRAY");
    }

    @Override
    public RelDataType getComponentType() {
        return this.elementType;
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this;
    }

    @Override
    public RelDataTypePrecedenceList getPrecedenceList() {
        return new RelDataTypePrecedenceList(){

            @Override
            public boolean containsType(RelDataType type) {
                if (type.getSqlTypeName() != ArraySqlType.this.getSqlTypeName()) {
                    return false;
                }
                RelDataType otherComponentType = type.getComponentType();
                return otherComponentType != null && ArraySqlType.this.getComponentType().getPrecedenceList().containsType(otherComponentType);
            }

            @Override
            public int compareTypePrecedence(RelDataType type1, RelDataType type2) {
                if (!this.containsType(type1)) {
                    throw new IllegalArgumentException("must contain type: " + type1);
                }
                if (!this.containsType(type2)) {
                    throw new IllegalArgumentException("must contain type: " + type2);
                }
                return ArraySqlType.this.getComponentType().getPrecedenceList().compareTypePrecedence(NonNullableAccessors.getComponentTypeOrThrow(type1), NonNullableAccessors.getComponentTypeOrThrow(type2));
            }
        };
    }
}

