/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.dialect;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.avatica.util.TimeUnitRange;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeSystem;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import com.hazelcast.org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlDataTypeSpec;
import com.hazelcast.org.apache.calcite.sql.SqlDateLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlTimeLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlTimestampLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.fun.SqlFloorFunction;
import com.hazelcast.org.apache.calcite.sql.fun.SqlLibraryOperators;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class OracleSqlDialect
extends SqlDialect {
    private static final RelDataTypeSystem ORACLE_TYPE_SYSTEM = new RelDataTypeSystemImpl(){

        @Override
        public int getMaxPrecision(SqlTypeName typeName) {
            switch (typeName) {
                case VARCHAR: {
                    return 4000;
                }
            }
            return super.getMaxPrecision(typeName);
        }
    };
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.ORACLE).withIdentifierQuoteString("\"").withDataTypeSystem(ORACLE_TYPE_SYSTEM);
    public static final SqlDialect DEFAULT = new OracleSqlDialect(DEFAULT_CONTEXT);

    public OracleSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public boolean supportsDataType(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case BOOLEAN: {
                return false;
            }
        }
        return super.supportsDataType(type);
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type) {
        String castSpec;
        switch (type.getSqlTypeName()) {
            case SMALLINT: {
                castSpec = "NUMBER(5)";
                break;
            }
            case INTEGER: {
                castSpec = "NUMBER(10)";
                break;
            }
            case BIGINT: {
                castSpec = "NUMBER(19)";
                break;
            }
            case DOUBLE: {
                castSpec = "DOUBLE PRECISION";
                break;
            }
            default: {
                return super.getCastSpec(type);
            }
        }
        return new SqlDataTypeSpec(new SqlAlienSystemTypeNameSpec(castSpec, type.getSqlTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO);
    }

    @Override
    protected boolean allowsAs() {
        return false;
    }

    @Override
    public boolean supportsAliasedValues() {
        return false;
    }

    @Override
    public void unparseDateTimeLiteral(SqlWriter writer, SqlAbstractDateTimeLiteral literal, int leftPrec, int rightPrec) {
        if (literal instanceof SqlTimestampLiteral) {
            writer.literal("TO_TIMESTAMP('" + literal.toFormattedString() + "', 'YYYY-MM-DD HH24:MI:SS.FF')");
        } else if (literal instanceof SqlDateLiteral) {
            writer.literal("TO_DATE('" + literal.toFormattedString() + "', 'YYYY-MM-DD')");
        } else if (literal instanceof SqlTimeLiteral) {
            writer.literal("TO_TIME('" + literal.toFormattedString() + "', 'HH24:MI:SS.FF')");
        } else {
            super.unparseDateTimeLiteral(writer, literal, leftPrec, rightPrec);
        }
    }

    @Override
    public List<String> getSingleRowTableName() {
        return ImmutableList.of("DUAL");
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.getOperator() == SqlStdOperatorTable.SUBSTRING) {
            SqlUtil.unparseFunctionSyntax(SqlLibraryOperators.SUBSTR_ORACLE, writer, call, false);
        } else {
            switch (call.getKind()) {
                case FLOOR: {
                    if (call.operandCount() != 2) {
                        super.unparseCall(writer, call, leftPrec, rightPrec);
                        return;
                    }
                    SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
                    TimeUnitRange timeUnit = timeUnitNode.getValueAs(TimeUnitRange.class);
                    SqlCall call2 = SqlFloorFunction.replaceTimeUnitOperand(call, timeUnit.name(), timeUnitNode.getParserPosition());
                    SqlFloorFunction.unparseDatetimeFunction(writer, call2, "TRUNC", true);
                    break;
                }
                default: {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                }
            }
        }
    }
}

