/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWindowTableFunction;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;

public class SqlSessionTableFunction
extends SqlWindowTableFunction {
    public SqlSessionTableFunction() {
        super(SqlKind.SESSION.name(), new OperandMetadataImpl());
    }

    private static class OperandMetadataImpl
    extends SqlWindowTableFunction.AbstractOperandMetadata {
        OperandMetadataImpl() {
            super(ImmutableList.of("DATA", "TIMECOL", "KEY", "SIZE"), 3);
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            RelDataType type3;
            if (!this.checkTableAndDescriptorOperands(callBinding, 1)) {
                return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
            }
            if (!this.checkTimeColumnDescriptorOperand(callBinding, 1)) {
                return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
            }
            SqlValidator validator = callBinding.getValidator();
            SqlNode operand2 = callBinding.operand(2);
            RelDataType type2 = validator.getValidatedNodeType(operand2);
            if (operand2.getKind() == SqlKind.DESCRIPTOR) {
                SqlNode operand0 = callBinding.operand(0);
                RelDataType type = validator.getValidatedNodeType(operand0);
                this.validateColumnNames(validator, type.getFieldNames(), ((SqlCall)operand2).getOperandList());
            } else if (!SqlTypeUtil.isInterval(type2)) {
                return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
            }
            if (callBinding.getOperandCount() > 3 && !SqlTypeUtil.isInterval(type3 = validator.getValidatedNodeType(callBinding.operand(3)))) {
                return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
            }
            return true;
        }

        @Override
        public String getAllowedSignatures(SqlOperator op, String opName) {
            return opName + "(TABLE table_name, DESCRIPTOR(timecol), DESCRIPTOR(key) optional, datetime interval)";
        }
    }
}

