/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.util.ImmutableNullableList;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SqlBasicCall
extends SqlCall {
    private SqlOperator operator;
    @Deprecated
    public final @Nullable SqlNode[] operands;
    private final List<@Nullable SqlNode> operandList;
    private final @Nullable SqlLiteral functionQuantifier;
    private final boolean expanded;

    public SqlBasicCall(SqlOperator operator, @Nullable SqlNode[] operands, SqlParserPos pos) {
        this(operator, operands, pos, null, false);
    }

    @Deprecated
    public SqlBasicCall(SqlOperator operator, @Nullable SqlNode[] operands, SqlParserPos pos, boolean expanded, @Nullable SqlLiteral functionQualifier) {
        this(operator, operands, pos, functionQualifier, expanded);
    }

    public SqlBasicCall(SqlOperator operator, @Nullable SqlNode[] operands, SqlParserPos pos, @Nullable SqlLiteral functionQualifier) {
        this(operator, operands, pos, functionQualifier, false);
    }

    private SqlBasicCall(SqlOperator operator, @Nullable SqlNode[] operands, SqlParserPos pos, @Nullable SqlLiteral functionQualifier, boolean expanded) {
        super(pos);
        this.operator = Objects.requireNonNull(operator, "operator");
        this.operands = operands;
        this.operandList = Arrays.asList(operands);
        this.expanded = expanded;
        this.functionQuantifier = functionQualifier;
    }

    @Override
    public SqlKind getKind() {
        return this.operator.getKind();
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    public SqlCall withExpanded(boolean expanded) {
        return expanded == this.expanded ? this : new SqlBasicCall(this.operator, this.operandList.toArray(new SqlNode[0]), this.pos, this.functionQuantifier, expanded);
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        this.operandList.set(i, operand);
    }

    public void setOperator(SqlOperator operator) {
        this.operator = Objects.requireNonNull(operator, "operator");
    }

    @Override
    public SqlOperator getOperator() {
        return this.operator;
    }

    @Deprecated
    public @Nullable SqlNode[] getOperands() {
        return this.operands;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.copyOf(this.operandList);
    }

    @Override
    public <S extends SqlNode> S operand(int i) {
        return (S)Nullness.castNonNull(this.operandList.get(i));
    }

    @Override
    public int operandCount() {
        return this.operandList.size();
    }

    @Override
    public @Nullable SqlLiteral getFunctionQuantifier() {
        return this.functionQuantifier;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return this.getOperator().createCall(this.getFunctionQuantifier(), pos, this.operandList);
    }
}

