/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.schema.impl;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.adapter.enumerable.AggImplementor;
import com.hazelcast.org.apache.calcite.adapter.enumerable.RexImpTable;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.schema.AggregateFunction;
import com.hazelcast.org.apache.calcite.schema.FunctionParameter;
import com.hazelcast.org.apache.calcite.schema.ImplementableAggFunction;
import com.hazelcast.org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import com.hazelcast.org.apache.calcite.util.ReflectUtil;
import com.hazelcast.org.apache.calcite.util.Static;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;

public class AggregateFunctionImpl
implements AggregateFunction,
ImplementableAggFunction {
    public final boolean isStatic;
    public final Method initMethod;
    public final Method addMethod;
    public final @Nullable Method mergeMethod;
    public final @Nullable Method resultMethod;
    public final ImmutableList<Class<?>> valueTypes;
    private final List<FunctionParameter> parameters;
    public final Class<?> accumulatorType;
    public final Class<?> resultType;
    public final Class<?> declaringClass;

    private AggregateFunctionImpl(Class<?> declaringClass, List<FunctionParameter> params, List<Class<?>> valueTypes, Class<?> accumulatorType, Class<?> resultType, Method initMethod, Method addMethod, @Nullable Method mergeMethod, @Nullable Method resultMethod) {
        this.declaringClass = declaringClass;
        this.valueTypes = ImmutableList.copyOf(valueTypes);
        this.parameters = params;
        this.accumulatorType = accumulatorType;
        this.resultType = resultType;
        this.initMethod = Objects.requireNonNull(initMethod, "initMethod");
        this.addMethod = Objects.requireNonNull(addMethod, "addMethod");
        this.mergeMethod = mergeMethod;
        this.resultMethod = resultMethod;
        this.isStatic = Modifier.isStatic(initMethod.getModifiers());
        assert (resultMethod != null || accumulatorType == resultType);
    }

    public static @Nullable AggregateFunctionImpl create(Class<?> clazz) {
        Method initMethod = ReflectiveFunctionBase.findMethod(clazz, "init");
        Method addMethod = ReflectiveFunctionBase.findMethod(clazz, "add");
        Method mergeMethod = null;
        Method resultMethod = ReflectiveFunctionBase.findMethod(clazz, "result");
        if (initMethod != null && addMethod != null) {
            Class<?> accumulatorType = initMethod.getReturnType();
            Class<?> resultType = resultMethod != null ? resultMethod.getReturnType() : accumulatorType;
            ImmutableList<Class<?>> addParamTypes = ImmutableList.copyOf(addMethod.getParameterTypes());
            if (addParamTypes.isEmpty() || addParamTypes.get(0) != accumulatorType) {
                throw Static.RESOURCE.firstParameterOfAdd(clazz.getName()).ex();
            }
            ReflectiveFunctionBase.ParameterListBuilder params = ReflectiveFunctionBase.builder();
            ImmutableList.Builder valueTypes = ImmutableList.builder();
            for (int i = 1; i < addParamTypes.size(); ++i) {
                Class type = (Class)addParamTypes.get(i);
                String name = ReflectUtil.getParameterName(addMethod, i);
                boolean optional = ReflectUtil.isParameterOptional(addMethod, i);
                params.add(type, name, optional);
                valueTypes.add(type);
            }
            return new AggregateFunctionImpl(clazz, (List<FunctionParameter>)params.build(), (List<Class<?>>)((Object)valueTypes.build()), accumulatorType, resultType, initMethod, addMethod, mergeMethod, resultMethod);
        }
        return null;
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return typeFactory.createJavaType(this.resultType);
    }

    @Override
    public AggImplementor getImplementor(boolean windowContext) {
        return new RexImpTable.UserDefinedAggReflectiveImplementor(this);
    }
}

