/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.runtime;

import com.hazelcast.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.org.checkerframework.checker.initialization.qual.UnderInitialization;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.org.checkerframework.checker.nullness.qual.PolyNull;
import com.hazelcast.org.checkerframework.checker.nullness.qual.RequiresNonNull;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class Resources {
    private static final ThreadLocal<@Nullable Locale> MAP_THREAD_TO_LOCALE = new ThreadLocal();

    private Resources() {
    }

    protected static Locale getThreadOrDefaultLocale() {
        Locale locale = Resources.getThreadLocale();
        if (locale == null) {
            return Locale.getDefault();
        }
        return locale;
    }

    public static void setThreadLocale(Locale locale) {
        MAP_THREAD_TO_LOCALE.set(locale);
    }

    public static @Nullable Locale getThreadLocale() {
        return MAP_THREAD_TO_LOCALE.get();
    }

    public static <T> T create(Class<T> clazz) {
        return Resources.create(clazz.getCanonicalName(), clazz);
    }

    public static <T> T create(@Nullable String base, Class<T> clazz) {
        return Resources.create(base, EmptyPropertyAccessor.INSTANCE, clazz);
    }

    public static <T> T create(PropertyAccessor accessor, Class<T> clazz) {
        return Resources.create(null, accessor, clazz);
    }

    public static <T> T create(Properties properties, Class<T> clazz) {
        return Resources.create(null, new PropertiesAccessor(properties), clazz);
    }

    private static <T> T create(final @Nullable String base, final PropertyAccessor accessor, Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){
            final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();

            @Override
            public Object invoke(Object proxy, Method method, @Nullable Object @Nullable [] args) throws Throwable {
                if (args == null || args.length == 0) {
                    Object o = this.cache.get(method.getName());
                    if (o == null) {
                        o = this.create(method, args);
                        this.cache.put(method.getName(), o);
                    }
                    return o;
                }
                return this.create(method, args);
            }

            private Object create(Method method, @Nullable Object @Nullable [] args) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
                if (method.equals(BuiltinMethod.OBJECT_TO_STRING.method)) {
                    return this.toString();
                }
                Class<?> returnType = method.getReturnType();
                try {
                    if (Inst.class.isAssignableFrom(returnType)) {
                        Constructor<?> constructor = returnType.getConstructor(String.class, Locale.class, Method.class, Object[].class);
                        Locale locale = Resources.getThreadOrDefaultLocale();
                        return constructor.newInstance(base, locale, method, args != null ? args : new Object[]{});
                    }
                    Constructor<?> constructor = returnType.getConstructor(PropertyAccessor.class, Method.class);
                    return constructor.newInstance(accessor, method);
                }
                catch (InvocationTargetException e) {
                    Throwable e2 = e.getTargetException();
                    if (e2 instanceof RuntimeException) {
                        throw (RuntimeException)e2;
                    }
                    if (e2 instanceof Error) {
                        throw (Error)e2;
                    }
                    throw e;
                }
            }
        });
    }

    public static void validate(Object o) {
        Resources.validate(o, EnumSet.allOf(Validation.class));
    }

    public static void validate(Object o, EnumSet<Validation> validations) {
        int count = 0;
        for (Method method : o.getClass().getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !Inst.class.isAssignableFrom(method.getReturnType())) continue;
            ++count;
            Class<?>[] parameterTypes = method.getParameterTypes();
            @Nullable Object[] args = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                args[i] = Resources.zero(parameterTypes[i]);
            }
            try {
                Inst inst = (Inst)method.invoke(o, args);
                assert (inst != null) : "got null from " + method;
                inst.validate(validations);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("in " + method, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("in " + method, e.getCause());
            }
        }
        if (count == 0 && validations.contains((Object)Validation.AT_LEAST_ONE)) {
            throw new AssertionError((Object)("resource object " + o + " contains no resources"));
        }
    }

    private static @Nullable Object zero(Class<?> clazz) {
        return clazz == String.class ? "" : (clazz == Byte.TYPE ? Byte.valueOf((byte)0) : (clazz == Character.TYPE ? Character.valueOf('\u0000') : (clazz == Short.TYPE ? Short.valueOf((short)0) : (clazz == Integer.TYPE ? Integer.valueOf(0) : (clazz == Long.TYPE ? Long.valueOf(0L) : (clazz == Float.TYPE ? Float.valueOf(0.0f) : (clazz == Double.TYPE ? (Constable)Double.valueOf(0.0) : (Constable)(clazz == Boolean.TYPE ? Boolean.valueOf(false) : null))))))));
    }

    private static boolean equal(@Nullable Object o0, @Nullable Object o1) {
        return o0 == o1 || o0 != null && o0.equals(o1);
    }

    private static class PropertiesAccessor
    implements PropertyAccessor {
        private final Properties properties;

        PropertiesAccessor(Properties properties) {
            this.properties = properties;
        }

        @Override
        public boolean isSet(Prop p) {
            return this.properties.containsKey(p.key);
        }

        @Override
        public int intValue(IntProp p) {
            String s2 = this.properties.getProperty(p.key);
            if (s2 != null) {
                return Integer.parseInt(s2, 10);
            }
            p.checkDefault2();
            return p.defaultValue;
        }

        @Override
        public int intValue(IntProp p, int defaultValue) {
            String s2 = this.properties.getProperty(p.key);
            return s2 == null ? defaultValue : Integer.parseInt(s2, 10);
        }

        @Override
        public @Nullable String stringValue(StringProp p) {
            String s2 = this.properties.getProperty(p.key);
            if (s2 != null) {
                return s2;
            }
            p.checkDefault2();
            return p.defaultValue;
        }

        @Override
        public @PolyNull String stringValue(StringProp p, @PolyNull String defaultValue) {
            String s2 = this.properties.getProperty(p.key);
            return s2 == null ? defaultValue : s2;
        }

        @Override
        public boolean booleanValue(BooleanProp p) {
            String s2 = this.properties.getProperty(p.key);
            if (s2 != null) {
                return Boolean.parseBoolean(s2);
            }
            p.checkDefault2();
            return p.defaultValue;
        }

        @Override
        public boolean booleanValue(BooleanProp p, boolean defaultValue) {
            String s2 = this.properties.getProperty(p.key);
            return s2 == null ? defaultValue : Boolean.parseBoolean(s2);
        }

        @Override
        public double doubleValue(DoubleProp p) {
            String s2 = this.properties.getProperty(p.key);
            if (s2 != null) {
                return Double.parseDouble(s2);
            }
            p.checkDefault2();
            return p.defaultValue;
        }

        @Override
        public double doubleValue(DoubleProp p, double defaultValue) {
            String s2 = this.properties.getProperty(p.key);
            return s2 == null ? defaultValue : Double.parseDouble(s2);
        }
    }

    static enum BuiltinMethod {
        OBJECT_TO_STRING(Object.class, "toString", new Class[0]);

        public final Method method;

        private BuiltinMethod(Class clazz, String methodName, Class ... argumentTypes) {
            this.method = BuiltinMethod.lookupMethod(clazz, methodName, argumentTypes);
        }

        public static Method lookupMethod(Class clazz, String methodName, Class ... argumentTypes) {
            try {
                return clazz.getMethod(methodName, argumentTypes);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("while resolving method '" + methodName + Arrays.toString(argumentTypes) + "' in class " + clazz, e);
            }
        }
    }

    static class MyPropertyResourceBundle
    extends PropertyResourceBundle {
        public MyPropertyResourceBundle(InputStream stream) throws IOException {
            super(stream);
        }

        void setParentTrojan(ResourceBundle parent) {
            super.setParent(parent);
        }
    }

    public static abstract class ShadowResourceBundle
    extends ResourceBundle {
        private final PropertyResourceBundle bundle;

        protected ShadowResourceBundle() throws IOException {
            Class<?> clazz = this.getClass();
            InputStream stream = ShadowResourceBundle.openPropertiesFile(clazz);
            if (stream == null) {
                throw new IOException("could not open properties file for " + this.getClass());
            }
            MyPropertyResourceBundle previousBundle = new MyPropertyResourceBundle(stream);
            this.bundle = previousBundle;
            stream.close();
            while ((clazz = clazz.getSuperclass()) != null && clazz != ShadowResourceBundle.class && ResourceBundle.class.isAssignableFrom(clazz)) {
                stream = ShadowResourceBundle.openPropertiesFile(clazz);
                if (stream == null) continue;
                MyPropertyResourceBundle newBundle = new MyPropertyResourceBundle(stream);
                stream.close();
                previousBundle.setParentTrojan(newBundle);
                previousBundle = newBundle;
            }
        }

        private static @Nullable InputStream openPropertiesFile(Class clazz) {
            ClassLoader loader = clazz.getClassLoader();
            String resName = clazz.getName().replace('.', '/') + ".properties";
            return AccessController.doPrivileged(() -> {
                if (loader != null) {
                    return loader.getResourceAsStream(resName);
                }
                return ClassLoader.getSystemResourceAsStream(resName);
            });
        }

        @Override
        public Enumeration<String> getKeys() {
            return this.bundle.getKeys();
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.bundle.getObject(key);
        }

        protected static ShadowResourceBundle instance(String baseName, Locale locale, ResourceBundle bundle) {
            if (bundle instanceof PropertyResourceBundle) {
                throw new ClassCastException("ShadowResourceBundle.instance('" + baseName + "','" + locale + "') found " + baseName + "_" + locale + ".properties but not " + baseName + "_" + locale + ".class");
            }
            return (ShadowResourceBundle)bundle;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Default {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Property {
        public String name();

        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Resource {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface BaseMessage {
        public String value();
    }

    public static enum Validation {
        BUNDLE_HAS_RESOURCE,
        AT_LEAST_ONE,
        MESSAGE_SPECIFIED,
        EVEN_QUOTES,
        MESSAGE_MATCH,
        CREATE_EXCEPTION,
        ARGUMENT_MATCH;

    }

    static enum EmptyPropertyAccessor implements PropertyAccessor
    {
        INSTANCE;


        @Override
        public boolean isSet(Prop p) {
            return false;
        }

        @Override
        public int intValue(IntProp p) {
            return p.defaultValue();
        }

        @Override
        public int intValue(IntProp p, int defaultValue) {
            return defaultValue;
        }

        @Override
        public @Nullable String stringValue(StringProp p) {
            return p.defaultValue();
        }

        @Override
        public @PolyNull String stringValue(StringProp p, @PolyNull String defaultValue) {
            return defaultValue;
        }

        @Override
        public boolean booleanValue(BooleanProp p) {
            return p.defaultValue();
        }

        @Override
        public boolean booleanValue(BooleanProp p, boolean defaultValue) {
            return defaultValue;
        }

        @Override
        public double doubleValue(DoubleProp p) {
            return p.defaultValue();
        }

        @Override
        public double doubleValue(DoubleProp p, double defaultValue) {
            return defaultValue;
        }
    }

    public static interface PropertyAccessor {
        public boolean isSet(Prop var1);

        public int intValue(IntProp var1);

        public int intValue(IntProp var1, int var2);

        public @Nullable String stringValue(StringProp var1);

        public @PolyNull String stringValue(StringProp var1, @PolyNull String var2);

        public boolean booleanValue(BooleanProp var1);

        public boolean booleanValue(BooleanProp var1, boolean var2);

        public double doubleValue(DoubleProp var1);

        public double doubleValue(DoubleProp var1, double var2);
    }

    public static class NoDefaultValueException
    extends RuntimeException {
        NoDefaultValueException(String message) {
            super(message);
        }
    }

    public static class StringProp
    extends Prop {
        private final @Nullable String defaultValue;

        public StringProp(PropertyAccessor accessor, Method method) {
            super(accessor, method);
            Default resource = this.getDefault();
            this.defaultValue = resource != null ? resource.value() : null;
        }

        public @Nullable String get() {
            return this.accessor.stringValue(this);
        }

        public @PolyNull String get(@PolyNull String defaultValue) {
            return this.accessor.stringValue(this, defaultValue);
        }

        public @Nullable String defaultValue() {
            this.checkDefault();
            return this.defaultValue;
        }
    }

    public static class DoubleProp
    extends Prop {
        private final double defaultValue;

        public DoubleProp(PropertyAccessor accessor, Method method) {
            super(accessor, method);
            Default resource = this.getDefault();
            this.defaultValue = resource != null ? Double.parseDouble(resource.value()) : 0.0;
        }

        public double get() {
            return this.accessor.doubleValue(this);
        }

        public double get(double defaultValue) {
            return this.accessor.doubleValue(this, defaultValue);
        }

        public double defaultValue() {
            this.checkDefault();
            return this.defaultValue;
        }
    }

    public static class BooleanProp
    extends Prop {
        private final boolean defaultValue;

        public BooleanProp(PropertyAccessor accessor, Method method) {
            super(accessor, method);
            Default resource = this.getDefault();
            this.defaultValue = resource != null ? Boolean.parseBoolean(resource.value()) : false;
        }

        public boolean get() {
            return this.accessor.booleanValue(this);
        }

        public boolean get(boolean defaultValue) {
            return this.accessor.booleanValue(this, defaultValue);
        }

        public boolean defaultValue() {
            this.checkDefault();
            return this.defaultValue;
        }
    }

    public static class IntProp
    extends Prop {
        private final int defaultValue;

        public IntProp(PropertyAccessor accessor, Method method) {
            super(accessor, method);
            Default resource = this.getDefault();
            this.defaultValue = resource != null ? Integer.parseInt(resource.value(), 10) : 0;
        }

        public int get() {
            return this.accessor.intValue(this);
        }

        public int get(int defaultValue) {
            return this.accessor.intValue(this, defaultValue);
        }

        public int defaultValue() {
            this.checkDefault();
            return this.defaultValue;
        }
    }

    public static abstract class Prop
    extends Element {
        protected final PropertyAccessor accessor;
        protected final boolean hasDefault;

        protected Prop(PropertyAccessor accessor, Method method) {
            super(method);
            this.accessor = accessor;
            Default resource = method.getAnnotation(Default.class);
            this.hasDefault = resource != null;
        }

        @RequiresNonNull(value={"method"})
        protected final @Nullable Default getDefault(@UnderInitialization Prop this) {
            if (this.hasDefault) {
                return Nullness.castNonNull(this.method.getAnnotation(Default.class));
            }
            return null;
        }

        public boolean isSet() {
            return this.accessor.isSet(this);
        }

        public boolean hasDefault() {
            return this.hasDefault;
        }

        void checkDefault() {
            if (!this.hasDefault) {
                throw new NoDefaultValueException("Property " + this.key + " has no default value");
            }
        }

        void checkDefault2() {
            if (!this.hasDefault) {
                throw new NoDefaultValueException("Property " + this.key + " is not set and has no default value");
            }
        }
    }

    public static class ExInst<T extends Exception>
    extends ExInstWithCause<T> {
        public ExInst(String base, Locale locale, Method method, Object ... args) {
            super(base, locale, method, args);
        }

        public T ex() {
            return this.ex(null);
        }

        @Override
        public void validate(EnumSet<Validation> validations) {
            super.validate(validations);
            if (validations.contains((Object)Validation.CREATE_EXCEPTION)) {
                this.validateException(this::ex);
            }
        }
    }

    public static class ExInstWithCause<T extends Exception>
    extends Inst {
        public ExInstWithCause(String base, Locale locale, Method method, Object ... args) {
            super(base, locale, method, args);
        }

        @Override
        public Inst localize(Locale locale) {
            return new ExInstWithCause<T>(this.base, locale, this.method, this.args);
        }

        public T ex(@Nullable Throwable cause) {
            try {
                Constructor constructor;
                Class exceptionClass = ExInstWithCause.getExceptionClass(this.method.getGenericReturnType());
                String str = this.str();
                boolean causeInConstructor = false;
                try {
                    constructor = exceptionClass.getConstructor(String.class, Throwable.class);
                    causeInConstructor = true;
                }
                catch (NoSuchMethodException nsmStringThrowable) {
                    try {
                        constructor = exceptionClass.getConstructor(String.class);
                    }
                    catch (NoSuchMethodException nsmString) {
                        throw nsmStringThrowable;
                    }
                }
                if (causeInConstructor) {
                    return (T)((Exception)constructor.newInstance(str, cause));
                }
                Exception ex = (Exception)constructor.newInstance(str);
                if (cause != null) {
                    try {
                        ex.initCause(cause);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                return (T)ex;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }

        public static Class getExceptionClass(Type type) {
            Type type0 = type;
            while (true) {
                if (type instanceof ParameterizedType) {
                    Type[] types = ((ParameterizedType)type).getActualTypeArguments();
                    if (types.length >= 1 && types[0] instanceof Class && Throwable.class.isAssignableFrom((Class)types[0])) {
                        return (Class)types[0];
                    }
                    throw new IllegalStateException("Unable to find superclass ExInstWithCause for " + type);
                }
                if (!(type instanceof Class)) continue;
                Type superclass = ((Class)type).getGenericSuperclass();
                if (superclass == null) {
                    throw new IllegalStateException("Unable to find superclass ExInstWithCause for " + type0);
                }
                type = superclass;
            }
        }

        protected void validateException(Callable<? extends @Nullable Exception> exSupplier) {
            Object cause = null;
            try {
                Exception ex = exSupplier.call();
                if (ex == null) {
                    cause = new NullPointerException();
                }
            }
            catch (AssertionError | Exception e) {
                cause = e;
            }
            if (cause != null) {
                throw new AssertionError("error instantiating exception for resource '" + this.method.getName() + "'", (Throwable)cause);
            }
        }

        @Override
        public void validate(EnumSet<Validation> validations) {
            super.validate(validations);
            if (validations.contains((Object)Validation.CREATE_EXCEPTION)) {
                this.validateException(() -> this.ex(new NullPointerException("test")));
            }
        }
    }

    public static class Inst
    extends Element {
        private final Locale locale;
        protected final String base;
        protected final @Nullable Object[] args;

        public Inst(String base, Locale locale, Method method, Object ... args) {
            super(method);
            this.base = base;
            this.locale = locale;
            this.args = args;
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj != null && obj.getClass() == this.getClass() && this.locale == ((Inst)obj).locale && this.method == ((Inst)obj).method && Arrays.equals(this.args, ((Inst)obj).args);
        }

        public int hashCode() {
            return Arrays.asList(this.locale, this.method, Arrays.asList(this.args)).hashCode();
        }

        public ResourceBundle bundle() {
            return ResourceBundle.getBundle(this.base, this.locale);
        }

        public Inst localize(Locale locale) {
            return new Inst(this.base, locale, this.method, this.args);
        }

        public void validate(EnumSet<Validation> validations) {
            ResourceBundle bundle = this.bundle();
            block7: for (Validation validation : validations) {
                switch (validation) {
                    case BUNDLE_HAS_RESOURCE: {
                        if (bundle.containsKey(this.key)) break;
                        String suggested = null;
                        BaseMessage annotation = this.method.getAnnotation(BaseMessage.class);
                        if (annotation != null) {
                            String message = annotation.value();
                            suggested = "; add the following line to " + bundle.getBaseBundleName() + ".properties:\n" + this.key + '=' + message + "\n";
                        }
                        throw new AssertionError((Object)("key '" + this.key + "' not found for resource '" + this.method.getName() + "' in bundle '" + bundle + "'" + (suggested == null ? "" : suggested)));
                    }
                    case MESSAGE_SPECIFIED: {
                        BaseMessage annotation1 = this.method.getAnnotation(BaseMessage.class);
                        if (annotation1 == null) {
                            throw new AssertionError((Object)("resource '" + this.method.getName() + "' must specify BaseMessage"));
                        }
                        break;
                    }
                    case EVEN_QUOTES: {
                        String message = Objects.requireNonNull(this.method.getAnnotation(BaseMessage.class), () -> "@BaseMessage is missing for resource '" + this.method.getName() + "'").value();
                        if (Inst.countQuotesIn(message) % 2 == 1) {
                            throw new AssertionError((Object)("resource '" + this.method.getName() + "' should have even number of quotes"));
                        }
                        break;
                    }
                    case MESSAGE_MATCH: {
                        String value2;
                        BaseMessage annotation2 = this.method.getAnnotation(BaseMessage.class);
                        if (annotation2 == null) break;
                        String value = annotation2.value();
                        if (!Resources.equal(value, value2 = bundle.containsKey(this.key) ? bundle.getString(this.key) : null)) {
                            throw new AssertionError((Object)("message for resource '" + this.method.getName() + "' is different between class and resource file"));
                        }
                        continue block7;
                    }
                    case ARGUMENT_MATCH: {
                        String raw = this.raw();
                        MessageFormat format = new MessageFormat(raw);
                        Format[] formats = format.getFormatsByArgumentIndex();
                        ArrayList<Class<Date>> types = new ArrayList<Class<Date>>();
                        Class<?>[] parameterTypes = this.method.getParameterTypes();
                        for (int i = 0; i < formats.length; ++i) {
                            Format format1 = formats[i];
                            Class<?> parameterType = parameterTypes[i];
                            Class e = format1 instanceof NumberFormat ? (parameterType == Short.TYPE || parameterType == Integer.TYPE || parameterType == Long.TYPE || parameterType == Float.TYPE || parameterType == Double.TYPE || Number.class.isAssignableFrom(parameterType) ? parameterType : Number.class) : (format1 instanceof DateFormat ? Date.class : String.class);
                            types.add(e);
                        }
                        List<Class<?>> parameterTypeList = Arrays.asList(parameterTypes);
                        if (!types.equals(parameterTypeList)) {
                            throw new AssertionError((Object)("type mismatch in method '" + this.method.getName() + "' between message format elements " + types + " and method parameters " + parameterTypeList));
                        }
                        break;
                    }
                }
            }
        }

        private static int countQuotesIn(String message) {
            int count = 0;
            int n = message.length();
            for (int i = 0; i < n; ++i) {
                if (message.charAt(i) != '\'') continue;
                ++count;
            }
            return count;
        }

        public String str() {
            String message = this.raw();
            MessageFormat format = new MessageFormat(message);
            format.setLocale(this.locale);
            return format.format(this.args);
        }

        public String raw() {
            try {
                return this.bundle().getString(this.key);
            }
            catch (MissingResourceException e) {
                return Objects.requireNonNull(this.method.getAnnotation(BaseMessage.class), () -> "@BaseMessage is missing for resource '" + this.method.getName() + "'").value();
            }
        }

        public Map<String, String> getProperties() {
            Property property = this.method.getAnnotation(Property.class);
            if (property == null) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(property.name(), property.value());
        }
    }

    public static class Element {
        protected final Method method;
        protected final String key;

        public Element(Method method) {
            this.method = method;
            this.key = this.deriveKey();
        }

        protected String deriveKey() {
            Resource resource = this.method.getAnnotation(Resource.class);
            if (resource != null) {
                return resource.value();
            }
            String name = this.method.getName();
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
    }
}

