/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.core.Calc;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalCalc;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalProject;
import com.hazelcast.org.apache.calcite.rel.rules.ImmutableProjectCalcMergeRule;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexOver;
import com.hazelcast.org.apache.calcite.rex.RexProgram;
import com.hazelcast.org.apache.calcite.rex.RexProgramBuilder;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.org.apache.calcite.util.Pair;
import org.immutables.value.Value;

@Value.Enclosing
public class ProjectCalcMergeRule
extends RelRule<Config>
implements TransformationRule {
    protected ProjectCalcMergeRule(Config config) {
        super(config);
    }

    @Deprecated
    public ProjectCalcMergeRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        Calc calc = (Calc)call.rel(1);
        RelOptCluster cluster = project.getCluster();
        RexProgram program = RexProgram.create(calc.getRowType(), project.getProjects(), null, project.getRowType(), cluster.getRexBuilder());
        if (RexOver.containsOver(program)) {
            LogicalCalc projectAsCalc = LogicalCalc.create(calc, program);
            call.transformTo(projectAsCalc);
            return;
        }
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexProgramBuilder progBuilder = new RexProgramBuilder(calc.getRowType(), rexBuilder);
        for (Pair<RexNode, String> field : project.getNamedProjects()) {
            progBuilder.addProject((RexNode)field.left, (String)field.right);
        }
        RexProgram topProgram = progBuilder.getProgram();
        RexProgram bottomProgram = calc.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        LogicalCalc newCalc = LogicalCalc.create(calc.getInput(), mergedProgram);
        call.transformTo(newCalc);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableProjectCalcMergeRule.Config.of().withOperandFor(LogicalProject.class, LogicalCalc.class);

        @Override
        default public ProjectCalcMergeRule toRule() {
            return new ProjectCalcMergeRule(this);
        }

        default public Config withOperandFor(Class<? extends Project> projectClass, Class<? extends Calc> calcClass) {
            return this.withOperandSupplier(b0 -> b0.operand(projectClass).oneInput(b1 -> b1.operand(calcClass).anyInputs())).as(Config.class);
        }
    }
}

