/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.metadata;

import com.hazelcast.com.google.common.collect.ImmutableCollection;
import com.hazelcast.com.google.common.collect.ImmutableMultimap;
import com.hazelcast.com.google.common.collect.ImmutableSet;
import com.hazelcast.com.google.common.collect.Maps;
import com.hazelcast.org.apache.calcite.linq4j.Linq4j;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.SingleRel;
import com.hazelcast.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.org.apache.calcite.rel.core.Calc;
import com.hazelcast.org.apache.calcite.rel.core.Correlate;
import com.hazelcast.org.apache.calcite.rel.core.Filter;
import com.hazelcast.org.apache.calcite.rel.core.Intersect;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.JoinInfo;
import com.hazelcast.org.apache.calcite.rel.core.Minus;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.core.Sort;
import com.hazelcast.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rel.core.Union;
import com.hazelcast.org.apache.calcite.rel.metadata.BuiltInMetadata;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataDef;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataHandler;
import com.hazelcast.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexProgram;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RelMdUniqueKeys
implements MetadataHandler<BuiltInMetadata.UniqueKeys> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(new RelMdUniqueKeys(), BuiltInMetadata.UniqueKeys.Handler.class);

    private RelMdUniqueKeys() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.UniqueKeys> getDef() {
        return BuiltInMetadata.UniqueKeys.DEF;
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(Filter rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return mq.getUniqueKeys(rel.getInput(), ignoreNulls);
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(Sort rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return mq.getUniqueKeys(rel.getInput(), ignoreNulls);
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(Correlate rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return mq.getUniqueKeys(rel.getLeft(), ignoreNulls);
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(TableModify rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return mq.getUniqueKeys(rel.getInput(), ignoreNulls);
    }

    public Set<ImmutableBitSet> getUniqueKeys(Project rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return RelMdUniqueKeys.getProjectUniqueKeys(rel, mq, ignoreNulls, rel.getProjects());
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(Calc rel, RelMetadataQuery mq, boolean ignoreNulls) {
        RexProgram program = rel.getProgram();
        return RelMdUniqueKeys.getProjectUniqueKeys(rel, mq, ignoreNulls, Util.transform(program.getProjectList(), program::expandLocalRef));
    }

    private static Set<ImmutableBitSet> getProjectUniqueKeys(SingleRel rel, RelMetadataQuery mq, boolean ignoreNulls, List<RexNode> projExprs) {
        ImmutableMultimap.Builder<Integer, Integer> inToOutPosBuilder = ImmutableMultimap.builder();
        ImmutableBitSet.Builder mappedInColumnsBuilder = ImmutableBitSet.builder();
        for (int i = 0; i < projExprs.size(); ++i) {
            RexNode projExpr = projExprs.get(i);
            if (!(projExpr instanceof RexInputRef)) continue;
            int inputIndex = ((RexInputRef)projExpr).getIndex();
            inToOutPosBuilder.put(inputIndex, i);
            mappedInColumnsBuilder.set(inputIndex);
        }
        ImmutableBitSet inColumnsUsed = mappedInColumnsBuilder.build();
        if (inColumnsUsed.isEmpty()) {
            return ImmutableSet.of();
        }
        Set<ImmutableBitSet> childUniqueKeySet = mq.getUniqueKeys(rel.getInput(), ignoreNulls);
        if (childUniqueKeySet == null) {
            return ImmutableSet.of();
        }
        Map mapInToOutPos = Maps.transformValues(inToOutPosBuilder.build().asMap(), ImmutableBitSet::of);
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (ImmutableBitSet colMask : childUniqueKeySet) {
            if (!inColumnsUsed.contains(colMask)) continue;
            Iterable product = Linq4j.product(Util.transform(colMask, in -> Util.filter(((ImmutableBitSet)Objects.requireNonNull(mapInToOutPos.get(in), () -> "no entry for column " + in + " in mapInToOutPos: " + mapInToOutPos)).powerSet(), bs -> !bs.isEmpty())));
            resultBuilder.addAll(Util.transform(product, ImmutableBitSet::union));
        }
        return resultBuilder.build();
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(Join rel, RelMetadataQuery mq, boolean ignoreNulls) {
        if (!rel.getJoinType().projectsRight()) {
            return mq.getUniqueKeys(rel.getLeft(), ignoreNulls);
        }
        RelNode left = rel.getLeft();
        RelNode right = rel.getRight();
        HashSet<ImmutableBitSet> retSet = new HashSet<ImmutableBitSet>();
        Set<ImmutableBitSet> leftSet = mq.getUniqueKeys(left, ignoreNulls);
        HashSet<ImmutableBitSet> rightSet = null;
        Set<ImmutableBitSet> tmpRightSet = mq.getUniqueKeys(right, ignoreNulls);
        int nFieldsOnLeft = left.getRowType().getFieldCount();
        if (tmpRightSet != null) {
            rightSet = new HashSet<ImmutableBitSet>();
            for (ImmutableBitSet colMask : tmpRightSet) {
                ImmutableBitSet.Builder tmpMask = ImmutableBitSet.builder();
                for (int bit : colMask) {
                    tmpMask.set(bit + nFieldsOnLeft);
                }
                rightSet.add(tmpMask.build());
            }
            if (leftSet != null) {
                for (ImmutableBitSet colMaskRight : rightSet) {
                    for (ImmutableBitSet colMaskLeft : leftSet) {
                        retSet.add(colMaskLeft.union(colMaskRight));
                    }
                }
            }
        }
        JoinInfo joinInfo = rel.analyzeCondition();
        Boolean leftUnique = mq.areColumnsUnique(left, joinInfo.leftSet(), ignoreNulls);
        Boolean rightUnique = mq.areColumnsUnique(right, joinInfo.rightSet(), ignoreNulls);
        if (rightUnique != null && rightUnique.booleanValue() && leftSet != null && !rel.getJoinType().generatesNullsOnLeft()) {
            retSet.addAll(leftSet);
        }
        if (leftUnique != null && leftUnique.booleanValue() && rightSet != null && !rel.getJoinType().generatesNullsOnRight()) {
            retSet.addAll(rightSet);
        }
        return retSet;
    }

    public Set<ImmutableBitSet> getUniqueKeys(Aggregate rel, RelMetadataQuery mq, boolean ignoreNulls) {
        if (Aggregate.isSimple(rel) || ignoreNulls) {
            return ImmutableSet.of(rel.getGroupSet());
        }
        return ImmutableSet.of();
    }

    public Set<ImmutableBitSet> getUniqueKeys(Union rel, RelMetadataQuery mq, boolean ignoreNulls) {
        if (!rel.all) {
            return ImmutableSet.of(ImmutableBitSet.range(rel.getRowType().getFieldCount()));
        }
        return ImmutableSet.of();
    }

    public Set<ImmutableBitSet> getUniqueKeys(Intersect rel, RelMetadataQuery mq, boolean ignoreNulls) {
        ImmutableSet.Builder keys = new ImmutableSet.Builder();
        for (RelNode input : rel.getInputs()) {
            Set<ImmutableBitSet> uniqueKeys = mq.getUniqueKeys(input, ignoreNulls);
            if (uniqueKeys == null) continue;
            keys.addAll(uniqueKeys);
        }
        ImmutableCollection uniqueKeys = keys.build();
        if (!uniqueKeys.isEmpty()) {
            return uniqueKeys;
        }
        if (!rel.all) {
            return ImmutableSet.of(ImmutableBitSet.range(rel.getRowType().getFieldCount()));
        }
        return ImmutableSet.of();
    }

    public Set<ImmutableBitSet> getUniqueKeys(Minus rel, RelMetadataQuery mq, boolean ignoreNulls) {
        Set<ImmutableBitSet> uniqueKeys = mq.getUniqueKeys(rel.getInput(0), ignoreNulls);
        if (uniqueKeys != null) {
            return uniqueKeys;
        }
        if (!rel.all) {
            return ImmutableSet.of(ImmutableBitSet.range(rel.getRowType().getFieldCount()));
        }
        return ImmutableSet.of();
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(TableScan rel, RelMetadataQuery mq, boolean ignoreNulls) {
        List<ImmutableBitSet> keys = rel.getTable().getKeys();
        if (keys == null) {
            return null;
        }
        for (ImmutableBitSet key : keys) {
            assert (rel.getTable().isKey(key));
        }
        return ImmutableSet.copyOf(keys);
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(RelNode rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return null;
    }
}

