/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel;

import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelTraitDef;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelCollations;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalSort;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;

public class RelCollationTraitDef
extends RelTraitDef<RelCollation> {
    public static final RelCollationTraitDef INSTANCE = new RelCollationTraitDef();

    private RelCollationTraitDef() {
    }

    @Override
    public Class<RelCollation> getTraitClass() {
        return RelCollation.class;
    }

    @Override
    public String getSimpleName() {
        return "sort";
    }

    @Override
    public boolean multiple() {
        return true;
    }

    @Override
    public RelCollation getDefault() {
        return RelCollations.EMPTY;
    }

    @Override
    public @Nullable RelNode convert(RelOptPlanner planner, RelNode rel, RelCollation toCollation, boolean allowInfiniteCostConverters) {
        if (toCollation.getFieldCollations().isEmpty()) {
            return null;
        }
        LogicalSort sort = LogicalSort.create(rel, toCollation, null, null);
        RelNode newRel = planner.register(sort, rel);
        RelTraitSet newTraitSet = rel.getTraitSet().replace(toCollation);
        if (!newRel.getTraitSet().equals(newTraitSet)) {
            newRel = planner.changeTraits(newRel, newTraitSet);
        }
        return newRel;
    }

    @Override
    public boolean canConvert(RelOptPlanner planner, RelCollation fromTrait, RelCollation toTrait) {
        return true;
    }
}

