/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.plan.volcano;

import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.plan.RelTraitDef;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.plan.volcano.ImmutableConverter;
import com.hazelcast.org.apache.calcite.plan.volcano.RelSubset;
import com.hazelcast.org.apache.calcite.plan.volcano.VolcanoPlanner;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelWriter;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterImpl;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;
import org.immutables.value.Value;

@Value.Enclosing
public class AbstractConverter
extends ConverterImpl {
    public AbstractConverter(RelOptCluster cluster, RelSubset rel, @Nullable RelTraitDef traitDef, RelTraitSet traits) {
        super(cluster, traitDef, traits, rel);
        assert (traits.allSimple());
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new AbstractConverter(this.getCluster(), (RelSubset)AbstractConverter.sole(inputs), this.traitDef, traitSet);
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeInfiniteCost();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (RelTrait trait : this.traitSet) {
            pw.item(trait.getTraitDef().getSimpleName(), trait);
        }
        return pw;
    }

    @Override
    public boolean isEnforcer() {
        return true;
    }

    public static class ExpandConversionRule
    extends RelRule<Config> {
        public static final ExpandConversionRule INSTANCE = Config.DEFAULT.toRule();

        protected ExpandConversionRule(Config config) {
            super(config);
        }

        @Deprecated
        public ExpandConversionRule(RelBuilderFactory relBuilderFactory) {
            this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            AbstractConverter converter;
            RelNode child;
            VolcanoPlanner planner = (VolcanoPlanner)call.getPlanner();
            RelNode converted = planner.changeTraitsUsingConverters(child = (converter = (AbstractConverter)call.rel(0)).getInput(), converter.traitSet);
            if (converted != null) {
                call.transformTo(converted);
            }
        }

        @Value.Immutable
        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = ImmutableConverter.Config.of().withOperandSupplier(b -> b.operand(AbstractConverter.class).anyInputs());

            @Override
            default public ExpandConversionRule toRule() {
                return new ExpandConversionRule(this);
            }
        }
    }
}

