/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.materialize;

import com.hazelcast.com.google.common.base.Preconditions;
import com.hazelcast.com.google.common.collect.HashMultimap;
import com.hazelcast.com.google.common.collect.Multimap;
import com.hazelcast.org.apache.calcite.jdbc.CalciteSchema;
import com.hazelcast.org.apache.calcite.materialize.MaterializationKey;
import com.hazelcast.org.apache.calcite.materialize.TileKey;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class MaterializationActor {
    final Map<MaterializationKey, Materialization> keyMap = new HashMap<MaterializationKey, Materialization>();
    final Map<QueryKey, MaterializationKey> keyBySql = new HashMap<QueryKey, MaterializationKey>();
    final Map<TileKey, MaterializationKey> keyByTile = new HashMap<TileKey, MaterializationKey>();
    final Multimap<TileKey, TileKey> tilesByDimensionality = HashMultimap.create();

    MaterializationActor() {
    }

    static class QueryKey {
        final String sql;
        final CalciteSchema schema;
        final @Nullable List<String> path;

        QueryKey(String sql, CalciteSchema schema, @Nullable List<String> path) {
            this.sql = sql;
            this.schema = schema;
            this.path = path;
        }

        public boolean equals(@Nullable Object obj) {
            return obj == this || obj instanceof QueryKey && this.sql.equals(((QueryKey)obj).sql) && this.schema.equals(((QueryKey)obj).schema) && Objects.equals(this.path, ((QueryKey)obj).path);
        }

        public int hashCode() {
            return Objects.hash(this.sql, this.schema, this.path);
        }
    }

    static class Materialization {
        final MaterializationKey key;
        final CalciteSchema rootSchema;
        @Nullable CalciteSchema.TableEntry materializedTable;
        final String sql;
        final RelDataType rowType;
        final @Nullable List<String> viewSchemaPath;

        Materialization(MaterializationKey key, CalciteSchema rootSchema, @Nullable CalciteSchema.TableEntry materializedTable, String sql, RelDataType rowType, @Nullable List<String> viewSchemaPath) {
            this.key = key;
            this.rootSchema = Objects.requireNonNull(rootSchema, "rootSchema");
            Preconditions.checkArgument(rootSchema.isRoot(), "must be root schema");
            this.materializedTable = materializedTable;
            this.sql = sql;
            this.rowType = rowType;
            this.viewSchemaPath = viewSchemaPath;
        }
    }
}

